/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.transport;

import com.botbox.util.ArrayUtils;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Hashtable;
import se.sics.isl.transport.BinaryTransport;
import se.sics.isl.transport.TransportReader;

public class BinaryTransportReader
extends TransportReader
implements BinaryTransport {
    private static final int DEF_SIZE = 10;
    private int currentPosition = -1;
    private int currentNode = -1;
    private int currentValue = -1;
    private byte[] messageData;
    private int dataOffset;
    private int dataLen;
    private int[] nodeStack = new int[10];
    private int nodeLevel = 0;
    private boolean nodeEntered = false;
    private String[] aliases = new String[48];
    private Hashtable nameLookup = new Hashtable();

    public void setMessage(byte[] byArray) {
        this.setMessage(byArray, 0, byArray.length);
    }

    public void setMessage(byte[] byArray, int n, int n2) {
        if ((n | n2 | byArray.length - n - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.messageData = byArray;
        this.dataOffset = n;
        this.dataLen = n + n2;
        this.nodeLevel = 0;
        this.reset();
    }

    public void clear() {
        this.nodeLevel = 0;
        this.dataLen = 0;
        this.dataOffset = 0;
        this.reset();
        this.messageData = null;
    }

    public void reset() {
        if (this.nodeLevel == 0) {
            this.currentPosition = this.dataOffset - 1;
            this.nodeEntered = false;
            this.currentValue = -1;
            this.currentNode = -1;
        } else {
            this.currentNode = this.currentPosition = this.nodeStack[this.nodeLevel - 1];
            this.currentValue = this.getValuePosForNode(this.currentNode);
            this.nodeEntered = true;
        }
    }

    protected int getPosition() {
        return this.currentPosition;
    }

    private int getAlias(String string) {
        Integer n = (Integer)this.nameLookup.get(string);
        return n == null ? -1 : n;
    }

    private int addAliases(int n) throws ParseException {
        while (n < this.dataLen && (this.messageData[n] & 0xFF) == 65) {
            n = this.addAlias(n);
        }
        return n;
    }

    private int addAlias(int n) throws ParseException {
        int n2;
        String string;
        if (n + 5 >= this.dataLen) {
            throw new ParseException("unexpected EOF", n);
        }
        int n3 = ((this.messageData[++n] & 0xFF) << 8) + (this.messageData[n + 1] & 0xFF);
        n += 2;
        if (this.nameLookup.get(string = this.getSValue(n += 2, n2 = ((this.messageData[n] & 0xFF) << 8) + (this.messageData[n + 1] & 0xFF))) == null) {
            this.nameLookup.put(string, new Integer(n3));
        }
        if (this.aliases.length <= n3) {
            this.aliases = (String[])ArrayUtils.setSize(this.aliases, n3 + 32);
        }
        this.aliases[n3] = string;
        return n + n2;
    }

    public boolean hasMoreNodes() throws ParseException {
        int n = this.currentPosition;
        int n2 = this.currentNode;
        int n3 = this.currentValue;
        boolean bl = this.nodeEntered;
        if (this.nextNode(false)) {
            this.currentPosition = n;
            this.currentNode = n2;
            this.currentValue = n3;
            this.nodeEntered = bl;
            return true;
        }
        return false;
    }

    public boolean nextNode(boolean bl) throws ParseException {
        if (this.skipToNextNode()) {
            return true;
        }
        if (bl) {
            throw new ParseException("no more nodes", this.currentPosition);
        }
        return false;
    }

    private boolean skipToNextNode() throws ParseException {
        if (this.currentPosition < this.dataOffset) {
            if (this.dataLen == this.dataOffset) {
                return false;
            }
            this.dataOffset = this.addAliases(this.dataOffset);
            if (this.dataOffset >= this.dataLen) {
                return false;
            }
            this.currentPosition = this.dataOffset;
            if ((this.messageData[this.currentPosition] & 0xFF) == 84) {
                throw new ParseException("table without type", this.currentPosition);
            }
            this.currentNode = this.currentPosition;
            this.currentValue = this.getValuePosForNode(this.currentNode);
            return true;
        }
        int n = this.currentPosition;
        int n2 = this.messageData[n] & 0xFF;
        if (this.nodeEntered && (n2 == 78 || n2 == 84)) {
            return false;
        }
        n = this.skipNode(this.currentNode, this.currentValue);
        if (n >= this.dataLen) {
            return false;
        }
        if (n2 == 78 || n2 == 84) {
            if ((n = this.addAliases(n)) < this.dataLen) {
                switch (this.messageData[n] & 0xFF) {
                    case 78: 
                    case 110: {
                        this.currentNode = this.currentPosition = n;
                        this.currentValue = this.getValuePosForNode(this.currentNode);
                        return true;
                    }
                    case 84: {
                        this.currentPosition = n;
                        this.currentValue = n + 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        int n3 = 1;
        int n4 = this.nodeEntered ? 1 : 0;
        int n5 = this.currentNode;
        block11: while (n < this.dataLen && n3 >= 0) {
            n2 = this.messageData[n] & 0xFF;
            switch (n2) {
                case 10: {
                    if (this.nodeEntered && --n3 == 0) {
                        return false;
                    }
                    ++n;
                    n5 = -1;
                    continue block11;
                }
                case 65: {
                    n = this.addAlias(n);
                    continue block11;
                }
                case 78: {
                    if (n3 == n4) {
                        this.currentNode = this.currentPosition = n;
                        this.currentValue = this.getValuePosForNode(this.currentNode);
                        this.nodeEntered = false;
                        return true;
                    }
                    n5 = n;
                    n = this.skipNode(n, this.getValuePosForNode(n));
                    continue block11;
                }
                case 84: {
                    if (n3 == n4) {
                        this.currentPosition = n;
                        this.currentValue = n + 1;
                        this.nodeEntered = false;
                        return true;
                    }
                    n = this.skipNode(n5, n + 1);
                    continue block11;
                }
                case 110: {
                    if (n3 == n4) {
                        this.currentNode = this.currentPosition = n;
                        this.currentValue = this.getValuePosForNode(this.currentNode);
                        this.nodeEntered = false;
                        return true;
                    }
                    n5 = n;
                    n = this.skipNode(n, this.getValuePosForNode(n));
                    ++n3;
                    continue block11;
                }
            }
            throw new ParseException("unknown op '" + n2 + '\'', n);
        }
        return false;
    }

    private int getValuePosForNode(int n) {
        return n + 4 + 3 * (this.messageData[n + 1] & 0xFF);
    }

    private int skipNode(int n, int n2) {
        if (n + 4 >= this.dataLen) {
            return this.dataLen;
        }
        int n3 = this.messageData[n + 1] & 0xFF;
        n += 4;
        for (int i = 0; i < n3; ++i) {
            switch (this.messageData[n] & 0xFF) {
                case 102: 
                case 105: {
                    n2 += 4;
                    break;
                }
                case 108: {
                    n2 += 8;
                    break;
                }
                case 115: {
                    int n4 = ((this.messageData[n2] & 0xFF) << 8) + (this.messageData[n2 + 1] & 0xFF);
                    n2 += n4 + 2;
                    break;
                }
                case 83: {
                    n2 += 2;
                    break;
                }
                case 73: {
                    int n4 = ((this.messageData[n2] & 0xFF) << 8) + (this.messageData[n2 + 1] & 0xFF);
                    n2 += n4 * 4 + 2;
                    break;
                }
            }
            n += 3;
        }
        return n2;
    }

    private int getIValue(int n) {
        return ((this.messageData[n] & 0xFF) << 24) + ((this.messageData[n + 1] & 0xFF) << 16) + ((this.messageData[n + 2] & 0xFF) << 8) + (this.messageData[n + 3] & 0xFF);
    }

    private long getLValue(int n) {
        long l = (((long)this.messageData[n] & 0xFFL) << 56) + (((long)this.messageData[n + 1] & 0xFFL) << 48) + (((long)this.messageData[n + 2] & 0xFFL) << 40) + (((long)this.messageData[n + 3] & 0xFFL) << 32) + (((long)this.messageData[n + 4] & 0xFFL) << 24) + (((long)this.messageData[n + 5] & 0xFFL) << 16) + (((long)this.messageData[n + 6] & 0xFFL) << 8) + ((long)this.messageData[n + 7] & 0xFFL);
        return l;
    }

    private String getSValue(int n, int n2) throws ParseException {
        int n3 = n + n2;
        if (n3 > this.dataLen) {
            throw new ParseException("unexpected EOF", n);
        }
        char[] cArray = new char[n2];
        int n4 = 0;
        block5: while (n < n3) {
            int n5 = this.messageData[n] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n;
                    cArray[n4++] = (char)n5;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n += 2) > n3) {
                        throw new ParseException("malformed UTF-8", n);
                    }
                    int n6 = this.messageData[n - 1] & 0xFF;
                    if ((n6 & 0xC0) != 128) {
                        throw new ParseException("malformed UTF-8", n - 2);
                    }
                    cArray[n4++] = (char)((n5 & 0x1F) << 6 | n6 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((n += 3) > n3) {
                        throw new ParseException("malformed UTF-8", n);
                    }
                    int n6 = this.messageData[n - 2] & 0xFF;
                    int n7 = this.messageData[n - 1] & 0xFF;
                    if ((n6 & 0xC0) != 128 || (n7 & 0xC0) != 128) {
                        throw new ParseException("malformed UTF-8", n - 3);
                    }
                    cArray[n4++] = (char)((n5 & 0xF) << 12 | (n6 & 0x3F) << 6 | (n7 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new ParseException("malformed UTF-8", n);
        }
        return new String(cArray, 0, n4);
    }

    private String getCValue(int n) throws ParseException {
        int n2 = ((this.messageData[n] & 0xFF) << 8) + (this.messageData[n + 1] & 0xFF);
        return this.getName(n2);
    }

    private String getName(int n) throws ParseException {
        if (n >= this.aliases.length || this.aliases[n] == null) {
            throw new ParseException("no alias for id " + n, this.currentPosition);
        }
        return this.aliases[n];
    }

    public boolean nextNode(String string, boolean bl) throws ParseException {
        int n = this.currentPosition;
        int n2 = this.currentNode;
        int n3 = this.currentValue;
        boolean bl2 = this.nodeEntered;
        while (this.nextNode(false)) {
            if (!this.isNode(string)) continue;
            return true;
        }
        this.currentPosition = n;
        this.currentNode = n2;
        this.currentValue = n3;
        this.nodeEntered = bl2;
        if (bl) {
            throw new ParseException("node '" + string + "' not found", this.currentPosition);
        }
        return false;
    }

    public String getNodeName() throws ParseException {
        if (this.currentNode < 0) {
            throw new ParseException("before first node", 0);
        }
        int n = ((this.messageData[this.currentNode + 2] & 0xFF) << 8) + (this.messageData[this.currentNode + 3] & 0xFF);
        return this.getName(n);
    }

    public boolean isNode() throws ParseException {
        return this.currentNode >= 0;
    }

    public boolean isNode(String string) throws ParseException {
        if (this.currentNode < 0) {
            return false;
        }
        int n = ((this.messageData[this.currentNode + 2] & 0xFF) << 8) + (this.messageData[this.currentNode + 3] & 0xFF);
        return n == this.getAlias(string);
    }

    public boolean enterNode() throws ParseException {
        if (this.nodeEntered || this.currentNode < 0) {
            return false;
        }
        if (this.nodeLevel >= this.nodeStack.length) {
            int n = this.nodeStack.length + 10;
            this.nodeStack = ArrayUtils.setSize(this.nodeStack, n);
        }
        this.nodeStack[this.nodeLevel++] = this.currentPosition;
        this.nodeEntered = true;
        return true;
    }

    public boolean exitNode() throws ParseException {
        if (this.nodeLevel > 0) {
            --this.nodeLevel;
            this.currentPosition = this.nodeStack[this.nodeLevel];
            if ((this.messageData[this.currentPosition] & 0xFF) == 84) {
                this.currentValue = this.currentPosition + 1;
            } else {
                this.currentNode = this.currentPosition;
                this.currentValue = this.getValuePosForNode(this.currentNode);
            }
            this.nodeEntered = false;
            return true;
        }
        return false;
    }

    public int getAttributeCount() {
        if (this.currentNode >= 0) {
            return this.messageData[this.currentNode + 1] & 0xFF;
        }
        return 0;
    }

    public String getAttributeName(int n) throws ParseException {
        int n2 = this.getAttributeCount();
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + n2);
        }
        int n3 = this.currentNode + 5 + n * 3;
        int n4 = ((this.messageData[n3] & 0xFF) << 8) + (this.messageData[n3 + 1] & 0xFF);
        return this.getName(n4);
    }

    private Object getAttributeAsObject(int n) throws ParseException {
        if (this.currentNode < 0) {
            return null;
        }
        int n2 = this.messageData[this.currentNode + 1] & 0xFF;
        int n3 = this.currentNode + 4;
        int n4 = this.currentValue;
        for (int i = 0; i < n2; ++i) {
            int n5 = ((this.messageData[n3 + 1] & 0xFF) << 8) + (this.messageData[n3 + 2] & 0xFF);
            switch (this.messageData[n3] & 0xFF) {
                case 105: {
                    if (n5 == n) {
                        return Integer.toString(this.getIValue(n4));
                    }
                    n4 += 4;
                    break;
                }
                case 108: {
                    if (n5 == n) {
                        return Long.toString(this.getLValue(n4));
                    }
                    n4 += 8;
                    break;
                }
                case 102: {
                    if (n5 == n) {
                        return Float.toString(Float.intBitsToFloat(this.getIValue(n4)));
                    }
                    n4 += 4;
                    break;
                }
                case 115: {
                    int n6 = ((this.messageData[n4] & 0xFF) << 8) + (this.messageData[n4 + 1] & 0xFF);
                    if (n5 == n) {
                        return this.getSValue(n4 + 2, n6);
                    }
                    n4 += n6 + 2;
                    break;
                }
                case 83: {
                    if (n5 == n) {
                        return this.getCValue(n4);
                    }
                    n4 += 2;
                    break;
                }
                case 73: {
                    int n6 = ((this.messageData[n4] & 0xFF) << 8) + (this.messageData[n4 + 1] & 0xFF);
                    if (n5 == n) {
                        return this.getAttributeAsIntArray(n4 + 2, n6);
                    }
                    n4 += n6 * 4 + 2;
                    break;
                }
            }
            n3 += 3;
        }
        return null;
    }

    private String getAttributeAsString(int n) throws ParseException {
        Object object = this.getAttributeAsObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append("" + nArray[i]);
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new ParseException("Illegal object type: " + object, this.currentPosition);
    }

    protected String getAttribute(String string, String string2, boolean bl) throws ParseException {
        String string3;
        Integer n = (Integer)this.nameLookup.get(string);
        String string4 = string3 = n != null ? this.getAttributeAsString(n) : null;
        if (string3 == null) {
            if (bl) {
                throw new ParseException("attribute " + string + " not found", this.currentPosition);
            }
            return string2;
        }
        return string3;
    }

    private int[] getAttributeAsIntArray(int n, int n2) {
        int[] nArray = new int[n2];
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.getIValue(n + i * 4);
        }
        return nArray;
    }

    protected int[] getAttributeAsIntArray(String string, boolean bl) throws ParseException {
        Object object;
        Integer n = (Integer)this.nameLookup.get(string);
        Object object2 = object = n != null ? this.getAttributeAsObject(n) : null;
        if (object != null) {
            if (object instanceof int[]) {
                return (int[])object;
            }
            throw new ParseException("Illegal value type, expected int[] got " + object, 0);
        }
        return null;
    }

    public void printMessage() throws ParseException {
        this.printMessage(System.out);
    }

    public void printMessage(PrintStream printStream) throws ParseException {
        while (this.exitNode()) {
        }
        this.reset();
        this.printNodes(printStream, "");
    }

    private boolean printNodes(PrintStream printStream, String string) throws ParseException {
        boolean bl = false;
        String string2 = string + "  ";
        while (this.nextNode(false)) {
            int n;
            if (!bl) {
                bl = true;
                if (string != "") {
                    printStream.println('>');
                }
            }
            printStream.print(string);
            printStream.print('<');
            printStream.print(this.getNodeName());
            int n2 = this.getAttributeCount();
            for (n = 0; n < n2; ++n) {
                printStream.print(' ' + this.getAttributeName(n) + "=\"" + this.getAttribute(n) + '\"');
            }
            this.enterNode();
            n = this.printNodes(printStream, string2) ? 1 : 0;
            this.exitNode();
            if (n != 0) {
                printStream.print(string);
                printStream.print("</");
                printStream.print(this.getNodeName());
                printStream.println('>');
                continue;
            }
            printStream.println(" />");
        }
        return bl;
    }
}

