/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.transport;

import com.botbox.util.ArrayUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import se.sics.isl.transport.BinaryTransport;
import se.sics.isl.transport.TransportWriter;

public class BinaryTransportWriter
extends TransportWriter
implements BinaryTransport {
    public static final String SUPPORT_CONSTANTS = "constants";
    public static final String SUPPORT_TABLES = "tables";
    private static final int DEF_SIZE = 10;
    private static final int ALIAS_SIZE = 256;
    private static final int DATA_SIZE = 1024;
    private static final int TYPE_POS = 0;
    private static final int NAME_POS = 1;
    private Hashtable constantLookup = new Hashtable();
    private boolean inNode = false;
    private int nodeLevel = 0;
    private boolean isTablesSupported = false;
    private boolean isConstantsSupported = false;
    private int[][] currentRow = new int[2][20];
    private long[][] currentIValues = new long[2][10];
    private float[][] currentFValues = new float[2][10];
    private Object[][] currentOValues = new Object[2][10];
    private int[] attrCount = new int[2];
    private int[] nodeName = new int[2];
    private boolean[] nodeWritten = new boolean[2];
    private int currentPos = 0;
    private int nextID = 0;
    private byte[] aliasData = new byte[256];
    private int aliasSize = 0;
    private byte[] byteData = new byte[1024];
    private int nrOfBytes;

    public BinaryTransportWriter() {
        this.clear();
    }

    public boolean isSupported(String string) {
        if (SUPPORT_CONSTANTS.equals(string)) {
            return this.isConstantsSupported;
        }
        if (SUPPORT_TABLES.equals(string)) {
            return this.isTablesSupported;
        }
        return false;
    }

    public void setSupported(String string, boolean bl) {
        if (SUPPORT_CONSTANTS.equals(string)) {
            this.isConstantsSupported = bl;
        } else if (SUPPORT_TABLES.equals(string)) {
            this.isTablesSupported = bl;
        }
    }

    private void writeInit() {
        Enumeration enumeration = this.constantLookup.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = (Integer)this.constantLookup.get(string);
            this.writeByte(65);
            this.writeShort(n);
            this.writeString(string);
        }
    }

    public int getInitSize() {
        int n = this.nrOfBytes;
        this.writeInit();
        int n2 = this.nrOfBytes - n;
        this.nrOfBytes = n;
        return n2;
    }

    public byte[] getInitBytes() {
        int n = this.nrOfBytes;
        this.writeInit();
        if (n != this.nrOfBytes) {
            int n2 = this.nrOfBytes - n;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.byteData, n, byArray, 0, n2);
            this.nrOfBytes = n;
            return byArray;
        }
        return null;
    }

    public void writeInit(ByteBuffer byteBuffer) {
        int n = this.nrOfBytes;
        this.writeInit();
        if (n != this.nrOfBytes) {
            byteBuffer.put(this.byteData, n, this.nrOfBytes - n);
            this.nrOfBytes = n;
        }
    }

    public void writeInit(OutputStream outputStream) throws IOException {
        int n = this.nrOfBytes;
        this.writeInit();
        if (n != this.nrOfBytes) {
            outputStream.write(this.byteData, n, this.nrOfBytes - n);
            this.nrOfBytes = n;
        }
    }

    public int size() {
        return this.aliasSize + this.nrOfBytes;
    }

    public void write(ByteBuffer byteBuffer) {
        if (this.aliasSize > 0) {
            byteBuffer.put(this.aliasData, 0, this.aliasSize);
        }
        if (this.nrOfBytes > 0) {
            byteBuffer.put(this.byteData, 0, this.nrOfBytes);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.aliasSize > 0) {
            outputStream.write(this.aliasData, 0, this.aliasSize);
        }
        if (this.nrOfBytes > 0) {
            outputStream.write(this.byteData, 0, this.nrOfBytes);
        }
    }

    public void write(byte[] byArray) {
        if (byArray.length < this.aliasSize + this.nrOfBytes) {
            throw new IndexOutOfBoundsException("Too many bytes to fit array, requires " + (this.aliasSize + this.nrOfBytes) + ", got " + byArray.length);
        }
        if (this.aliasSize > 0) {
            System.arraycopy(this.aliasData, 0, byArray, 0, this.aliasSize);
        }
        if (this.nrOfBytes > 0) {
            System.arraycopy(this.byteData, 0, byArray, this.aliasSize, this.nrOfBytes);
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.aliasSize + this.nrOfBytes];
        if (this.aliasSize > 0) {
            System.arraycopy(this.aliasData, 0, byArray, 0, this.aliasSize);
        }
        if (this.nrOfBytes > 0) {
            System.arraycopy(this.byteData, 0, byArray, this.aliasSize, this.nrOfBytes);
        }
        return byArray;
    }

    public void addConstant(String string) {
        if (this.isConstantsSupported) {
            this.createConstantID(string);
        }
    }

    public TransportWriter attr(String string, int n) {
        if (!this.inNode) {
            throw new IllegalArgumentException("Can not output attributes outside of nodes");
        }
        int n2 = this.createConstantID(string);
        int n3 = this.setType(105, n2);
        this.currentIValues[this.currentPos][n3] = n;
        return this;
    }

    public TransportWriter attr(String string, long l) {
        if (!this.inNode) {
            throw new IllegalArgumentException("Can not output attributes outside of nodes");
        }
        int n = this.createConstantID(string);
        int n2 = this.setType(108, n);
        this.currentIValues[this.currentPos][n2] = l;
        return this;
    }

    public TransportWriter attr(String string, float f) {
        if (!this.inNode) {
            throw new IllegalArgumentException("Can not output attributes outside of nodes");
        }
        int n = this.createConstantID(string);
        int n2 = this.setType(102, n);
        this.currentFValues[this.currentPos][n2] = f;
        return this;
    }

    public TransportWriter attr(String string, String string2) {
        int n;
        if (!this.inNode) {
            throw new IllegalArgumentException("Can not output attributes outside of nodes");
        }
        int n2 = this.createConstantID(string);
        if (this.isConstantsSupported && (n = this.getConstantID(string2)) >= 0) {
            int n3 = this.setType(83, n2);
            this.currentIValues[this.currentPos][n3] = n;
        } else {
            int n4 = this.setType(115, n2);
            this.currentOValues[this.currentPos][n4] = string2;
        }
        return this;
    }

    public TransportWriter attr(String string, int[] nArray) {
        if (!this.inNode) {
            throw new IllegalArgumentException("Can not output attributes outside of nodes");
        }
        int n = this.createConstantID(string);
        int n2 = this.setType(73, n);
        this.currentOValues[this.currentPos][n2] = nArray;
        return this;
    }

    public int getNodeLevel() {
        return this.nodeLevel;
    }

    public TransportWriter node(String string) {
        if (this.inNode) {
            this.writeCurrentNode((byte)110, this.currentPos);
        }
        this.currentPos = 1 - this.currentPos;
        this.nodeName[this.currentPos] = this.createConstantID(string);
        this.nodeWritten[this.currentPos] = false;
        this.attrCount[this.currentPos] = 0;
        ++this.nodeLevel;
        this.inNode = true;
        return this;
    }

    public TransportWriter endNode(String string) {
        return this.endNode();
    }

    private TransportWriter endNode() {
        if (this.nodeLevel > 0) {
            this.writeCurrentNode((byte)10, this.currentPos);
            --this.nodeLevel;
        }
        this.inNode = false;
        return this;
    }

    private void writeCurrentNode(byte by, int n) {
        int n2 = this.nodeName[n];
        if (n2 == -1 || this.nodeWritten[n]) {
            if (by == 10) {
                this.writeByte(10);
            }
        } else {
            int n3;
            int n4;
            int n5;
            boolean bl = true;
            if (by == 10) {
                n5 = 1 - n;
                if (this.isTablesSupported && this.nodeName[n5] == n2 && this.nodeWritten[n5] && this.attrCount[n] == this.attrCount[n5]) {
                    bl = false;
                    n4 = this.attrCount[n] * 2;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (this.currentRow[n][n3] == this.currentRow[n5][n3]) continue;
                        bl = true;
                        break;
                    }
                }
                this.writeByte(bl ? 78 : 84);
            } else {
                this.writeByte(110);
            }
            if (bl) {
                this.writeByte(this.attrCount[n]);
                this.writeShort(n2);
                n3 = this.attrCount[n] * 2;
                for (n5 = 0; n5 < n3; n5 += 2) {
                    n4 = this.currentRow[n][n5 + 0];
                    this.writeByte(n4);
                    this.writeShort(this.currentRow[n][n5 + 1]);
                }
            }
            n3 = this.attrCount[n];
            block10: for (n5 = 0; n5 < n3; ++n5) {
                n4 = this.currentRow[n][n5 * 2 + 0];
                switch (n4) {
                    case 105: {
                        this.writeInt((int)this.currentIValues[n][n5]);
                        continue block10;
                    }
                    case 108: {
                        this.writeLong(this.currentIValues[n][n5]);
                        continue block10;
                    }
                    case 102: {
                        this.writeFloat(this.currentFValues[n][n5]);
                        continue block10;
                    }
                    case 115: {
                        this.writeString((String)this.currentOValues[n][n5]);
                        continue block10;
                    }
                    case 83: {
                        this.writeShort((int)this.currentIValues[n][n5]);
                        continue block10;
                    }
                    case 73: {
                        this.writeIntArr((int[])this.currentOValues[n][n5]);
                    }
                }
            }
            this.nodeWritten[n] = true;
        }
    }

    private void writeByte(int n) {
        if (this.nrOfBytes >= this.byteData.length) {
            this.byteData = ArrayUtils.setSize(this.byteData, this.nrOfBytes + 1024);
        }
        this.byteData[this.nrOfBytes++] = (byte)(n & 0xFF);
    }

    private void writeShort(int n) {
        this.writeByte(n >> 8 & 0xFF);
        this.writeByte(n & 0xFF);
    }

    private void writeInt(int n) {
        this.writeByte(n >>> 24 & 0xFF);
        this.writeByte(n >>> 16 & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
        this.writeByte(n & 0xFF);
    }

    private void writeLong(long l) {
        this.writeByte((int)(l >>> 56) & 0xFF);
        this.writeByte((int)(l >>> 48) & 0xFF);
        this.writeByte((int)(l >>> 40) & 0xFF);
        this.writeByte((int)(l >>> 32) & 0xFF);
        this.writeByte((int)(l >>> 24) & 0xFF);
        this.writeByte((int)(l >>> 16) & 0xFF);
        this.writeByte((int)(l >>> 8) & 0xFF);
        this.writeByte((int)(l & 0xFFL));
    }

    private void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    private void writeString(String string) {
        int n = this.getMaxUTF8Size(string);
        if (this.nrOfBytes + n > this.byteData.length) {
            this.byteData = ArrayUtils.setSize(this.byteData, this.nrOfBytes + n + 1024);
        }
        int n2 = this.writeUTF8(this.byteData, this.nrOfBytes, string);
        this.nrOfBytes += n2;
    }

    private void writeAlias(int n, String string) {
        int n2 = 3 + this.getMaxUTF8Size(string);
        if (this.aliasSize + n2 > this.aliasData.length) {
            this.aliasData = ArrayUtils.setSize(this.aliasData, this.aliasSize + n2 + 256);
        }
        this.aliasData[this.aliasSize++] = 65;
        this.aliasData[this.aliasSize++] = (byte)(n >> 8 & 0xFF);
        this.aliasData[this.aliasSize++] = (byte)(n & 0xFF);
        this.aliasSize += this.writeUTF8(this.aliasData, this.aliasSize, string);
    }

    private int getMaxUTF8Size(String string) {
        int n = string.length();
        return n * 3 + 2;
    }

    private int writeUTF8(byte[] byArray, int n, String string) {
        int n2;
        int n3 = n + 2;
        int n4 = string.length();
        for (n2 = 0; n2 < n4; ++n2) {
            char c = string.charAt(n2);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        n2 = n3 - n - 2;
        if (n2 > 65535) {
            throw new IllegalArgumentException("too large string: " + string.length());
        }
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
        return n2 + 2;
    }

    private void writeIntArr(int[] nArray) {
        int n = nArray.length;
        if (this.nrOfBytes + n * 4 >= this.byteData.length) {
            this.byteData = ArrayUtils.setSize(this.byteData, this.nrOfBytes + n * 4 + 1024);
        }
        this.writeShort(n);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            this.writeInt(nArray[i]);
        }
    }

    private int getConstantID(String string) {
        Integer n = (Integer)this.constantLookup.get(string);
        return n != null ? n : -1;
    }

    private int createConstantID(String string) {
        Integer n = (Integer)this.constantLookup.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.nextID++;
        this.constantLookup.put(string, new Integer(n2));
        this.writeAlias(n2, string);
        return n2;
    }

    public void finish() {
        if (this.nodeLevel > 0) {
            int n = this.nodeLevel;
            for (int i = 0; i < n; ++i) {
                this.endNode();
            }
        }
    }

    public void clear() {
        this.aliasSize = 0;
        this.nrOfBytes = 0;
        this.nodeLevel = 0;
        this.inNode = false;
        this.nodeName[0] = -1;
        this.nodeWritten[0] = false;
        this.nodeName[1] = -1;
        this.nodeWritten[1] = false;
    }

    private int setType(int n, int n2) {
        int n3 = this.attrCount[this.currentPos];
        if (n3 >= this.currentIValues[this.currentPos].length) {
            int n4 = n3 + 10;
            this.currentIValues[this.currentPos] = ArrayUtils.setSize(this.currentIValues[this.currentPos], n4);
            this.currentFValues[this.currentPos] = ArrayUtils.setSize(this.currentFValues[this.currentPos], n4);
            this.currentOValues[this.currentPos] = ArrayUtils.setSize(this.currentOValues[this.currentPos], n4);
            this.currentRow[this.currentPos] = ArrayUtils.setSize(this.currentRow[this.currentPos], n4 * 2);
        }
        this.currentRow[this.currentPos][n3 * 2] = n;
        this.currentRow[this.currentPos][n3 * 2 + 1] = n2;
        int n5 = this.currentPos;
        int n6 = this.attrCount[n5];
        this.attrCount[n5] = n6 + 1;
        return n6;
    }
}

