/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.transport;

import java.text.ParseException;
import se.sics.isl.transport.Context;
import se.sics.isl.transport.Transportable;

public abstract class TransportReader {
    private Context currentContext;

    protected TransportReader() {
    }

    public void setContext(Context context) {
        this.currentContext = context;
    }

    public abstract void reset();

    protected abstract int getPosition();

    public Transportable readTransportable() throws ParseException {
        String string = this.getNodeName();
        String string2 = this.getTransportableClass(string);
        Transportable transportable = this.createTransportable(string2);
        this.readTransportable(transportable);
        return transportable;
    }

    protected String getTransportableClass(String string) throws ParseException {
        Context context = this.currentContext;
        if (context == null) {
            throw new ParseException("no context for node " + string, this.getPosition());
        }
        String string2 = context.lookupClass(string);
        if (string2 != null) {
            return string2;
        }
        throw new ParseException("no node named " + string + " in context " + context.getName(), this.getPosition());
    }

    protected Transportable createTransportable(String string) throws ParseException {
        try {
            return (Transportable)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw (ParseException)new ParseException("could not create transportable of type '" + string + '\'', this.getPosition()).initCause(exception);
        }
    }

    protected void readTransportable(Transportable transportable) throws ParseException {
        this.enterNode();
        transportable.read(this);
        this.exitNode();
    }

    public abstract boolean hasMoreNodes() throws ParseException;

    public abstract boolean nextNode(boolean var1) throws ParseException;

    public abstract boolean nextNode(String var1, boolean var2) throws ParseException;

    public abstract String getNodeName() throws ParseException;

    public abstract boolean isNode() throws ParseException;

    public abstract boolean isNode(String var1) throws ParseException;

    public abstract boolean enterNode() throws ParseException;

    public abstract boolean exitNode() throws ParseException;

    public abstract int getAttributeCount();

    public abstract String getAttributeName(int var1) throws ParseException;

    public String getAttribute(int n) throws ParseException {
        return this.getAttribute(this.getAttributeName(n), null);
    }

    public String getAttribute(String string) throws ParseException {
        return this.getAttribute(string, null, true);
    }

    public String getAttribute(String string, String string2) throws ParseException {
        return this.getAttribute(string, string2, false);
    }

    protected abstract String getAttribute(String var1, String var2, boolean var3) throws ParseException;

    public int getAttributeAsInt(String string) throws ParseException {
        return this.getAttributeAsInt(string, 0, true);
    }

    public int getAttributeAsInt(String string, int n) throws ParseException {
        return this.getAttributeAsInt(string, n, false);
    }

    protected int getAttributeAsInt(String string, int n, boolean bl) throws ParseException {
        String string2 = this.getAttribute(string, null, bl);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public long getAttributeAsLong(String string) throws ParseException {
        return this.getAttributeAsLong(string, 0L, true);
    }

    public long getAttributeAsLong(String string, long l) throws ParseException {
        return this.getAttributeAsLong(string, l, false);
    }

    protected long getAttributeAsLong(String string, long l, boolean bl) throws ParseException {
        String string2 = this.getAttribute(string, null, bl);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public float getAttributeAsFloat(String string) throws ParseException {
        return this.getAttributeAsFloat(string, 0.0f, true);
    }

    public float getAttributeAsFloat(String string, float f) throws ParseException {
        return this.getAttributeAsFloat(string, f, false);
    }

    protected float getAttributeAsFloat(String string, float f, boolean bl) throws ParseException {
        String string2 = this.getAttribute(string, null, bl);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    public int[] getAttributeAsIntArray(String string) throws ParseException {
        return this.getAttributeAsIntArray(string, false);
    }

    protected int[] getAttributeAsIntArray(String string, boolean bl) throws ParseException {
        System.out.println("Conversion of String value to int[] not *yet* supported");
        return null;
    }
}

