/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.util;

import se.sics.isl.util.ConfigManager;

public class ArgumentManager
extends ConfigManager {
    private static final int OPTION = 0;
    private static final int ARG_NAME = 1;
    private static final int DESCRIPTION = 2;
    private static final int TYPE = 3;
    private static final int PARTS = 4;
    private String programName;
    private String[] originalArguments;
    private Object[] descriptions;
    private int descriptionCount = 0;
    private int columnWidth = 72;
    private String[] arguments;
    private int argLen;

    public ArgumentManager(String string, String[] stringArray) {
        this.programName = string;
        this.originalArguments = stringArray;
    }

    public ArgumentManager(ConfigManager configManager, String string, String[] stringArray) {
        super(configManager);
        this.programName = string;
        this.originalArguments = stringArray;
    }

    public void addOption(String string, String string2, String string3) {
        this.addOption(string, string2, string3, String.class);
    }

    public void addOption(String string, String string2) {
        this.addOption(string, null, string2, Boolean.class);
    }

    public void addHelp(String string, String string2) {
        this.addOption(string, null, string2, null);
    }

    public void addHelp(String string) {
        this.addOption(string, null, null, null);
    }

    private void addOption(String string, String string2, String string3, Class clazz) {
        int n = this.descriptionCount * 4;
        if (this.descriptions == null) {
            this.descriptions = new Object[40];
        } else if (n == this.descriptions.length) {
            Object[] objectArray = new Object[n + 40];
            System.arraycopy(this.descriptions, 0, objectArray, 0, n);
            this.descriptions = objectArray;
        }
        this.descriptions[n + 0] = string;
        this.descriptions[n + 1] = string2;
        this.descriptions[n + 2] = string3;
        this.descriptions[n + 3] = clazz;
        ++this.descriptionCount;
    }

    public void validateArguments() {
        if (this.originalArguments == null || this.descriptionCount == 0) {
            return;
        }
        String[] stringArray = new String[this.originalArguments.length];
        int n = 0;
        int n2 = this.originalArguments.length;
        for (int i = 0; i < n2; ++i) {
            String string = this.originalArguments[i];
            if (string.length() > 1 && string.charAt(0) == '-') {
                Object object;
                int n3 = this.keyValuesIndexOf(this.descriptions, 4, 0, this.descriptionCount * 4, string = string.substring(1));
                if (n3 < 0) {
                    System.err.println("illegal argument '" + string + '\'');
                    this.usage(1);
                    return;
                }
                if (n + 2 >= stringArray.length) {
                    object = new String[n + 4];
                    System.arraycopy(stringArray, 0, object, 0, stringArray.length);
                    stringArray = object;
                }
                stringArray[n++] = string;
                object = this.descriptions[n3 + 3];
                if (object == Boolean.class) {
                    stringArray[n++] = "true";
                    continue;
                }
                if (object == null) {
                    this.usage(0);
                    return;
                }
                if (++i >= n2) {
                    System.err.println("argument '" + string + "' needs a value");
                    this.usage(1);
                    return;
                }
                stringArray[n++] = this.originalArguments[i];
                continue;
            }
            System.err.println("illegal argument '" + string + '\'');
            this.usage(1);
            return;
        }
        if (n > 0) {
            this.arguments = stringArray;
            this.argLen = n;
        } else {
            this.arguments = null;
            this.argLen = 0;
        }
    }

    public void finishArguments() {
        this.originalArguments = null;
        this.descriptionCount = 0;
        this.descriptions = null;
        this.programName = null;
    }

    public void usage(int n) {
        if (this.descriptionCount > 0 && this.programName != null) {
            String string;
            String string2;
            int n2;
            int n3 = 0;
            int n4 = this.columnWidth / 2;
            int n5 = this.descriptionCount * 4;
            for (n2 = 0; n2 < n5; n2 += 4) {
                string2 = (String)this.descriptions[n2 + 0];
                string = (String)this.descriptions[n2 + 1];
                int n6 = string2.length() + (string == null ? 0 : string.length() + 3);
                if (n6 <= n3 || n6 >= n4) continue;
                n3 = n6;
            }
            n3 += 4;
            System.out.println("Usage: " + this.programName + " [-options]");
            System.out.println("where options include:");
            n5 = this.descriptionCount * 4;
            for (n2 = 0; n2 < n5; n2 += 4) {
                int n7;
                string2 = (String)this.descriptions[n2 + 2];
                if (string2 == null || string2.length() <= 0) continue;
                string = (String)this.descriptions[n2 + 0];
                String string3 = (String)this.descriptions[n2 + 1];
                if (string3 == null) {
                    System.out.print("  -" + string);
                    n7 = string.length() + 3;
                } else {
                    System.out.print("  -" + string + " <" + string3 + '>');
                    n7 = string.length() + string3.length() + 3 + 3;
                }
                if (n7 > n4) {
                    System.out.println();
                    n7 = 0;
                }
                for (int i = n7; i < n3; ++i) {
                    System.out.print(' ');
                }
                System.out.println(string2);
            }
        }
        System.exit(n);
    }

    public boolean hasArgument(String string) {
        return this.keyValuesIndexOf(this.arguments, 2, 0, this.argLen, string) >= 0;
    }

    public String getArgument(String string) {
        return this.getArgument(string, null);
    }

    public String getArgument(String string, String string2) {
        if (this.argLen == 0) {
            return string2;
        }
        int n = this.keyValuesIndexOf(this.arguments, 2, 0, this.argLen, string);
        return n < 0 ? string2 : this.arguments[n + 1];
    }

    public int getArgumentAsInt(String string, int n) {
        String string2 = this.getArgument(string, null);
        return string2 != null ? this.parseInt(string, string2, n) : n;
    }

    public long getArgumentAsLong(String string, long l) {
        String string2 = this.getArgument(string, null);
        return string2 != null ? this.parseLong(string, string2, l) : l;
    }

    public float getArgumentAsFloat(String string, float f) {
        String string2 = this.getArgument(string, null);
        return string2 != null ? this.parseFloat(string, string2, f) : f;
    }

    public double getArgumentAsDouble(String string, double d) {
        String string2 = this.getArgument(string, null);
        return string2 != null ? this.parseDouble(string, string2, d) : d;
    }

    public boolean getArgumentAsBoolean(String string, boolean bl) {
        String string2 = this.getArgument(string, null);
        return string2 != null ? this.parseBoolean(string, string2, bl) : bl;
    }

    public void removeArgument(String string) {
        int n;
        if (this.argLen > 0 && (n = this.keyValuesIndexOf(this.arguments, 2, 0, this.argLen, string)) >= 0) {
            String string2 = this.arguments[n + 1];
            this.argLen -= 2;
            this.arguments[n] = this.arguments[this.argLen];
            this.arguments[n + 1] = this.arguments[this.argLen + 1];
        }
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getArgument(string, null);
        return string3 == null ? super.getProperty(string, string2) : string3;
    }

    public void setProperty(String string, String string2) {
        this.removeArgument(string);
        super.setProperty(string, string2);
    }

    private int keyValuesIndexOf(Object[] objectArray, int n, int n2, int n3, Object object) {
        for (int i = n2; i < n3; i += n) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }
}

