/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import se.sics.isl.util.IllegalConfigurationException;

public class ConfigManager {
    private static Logger logCache;
    protected final ConfigManager parent;
    protected final Properties properties = new Properties();

    public ConfigManager() {
        this(null);
    }

    public ConfigManager(ConfigManager configManager) {
        this.parent = configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfiguration(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            try {
                this.loadConfiguration(bufferedInputStream);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw (IllegalArgumentException)new IllegalArgumentException("could not read config file '" + string + '\'').initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfiguration(URL uRL) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                this.loadConfiguration(bufferedInputStream);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            throw (IllegalArgumentException)new IllegalArgumentException("could not read config file '" + uRL + '\'').initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(InputStream inputStream) throws IOException {
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.clear();
            this.properties.load(inputStream);
        }
    }

    public Enumeration names() {
        return this.properties.keys();
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.properties.getProperty(string);
        if (string3 == null || string3.length() == 0) {
            string3 = this.parent != null ? this.parent.getProperty(string, string2) : string2;
        }
        return string3;
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public String[] getPropertyAsArray(String string) {
        return this.getPropertyAsArray(string, null);
    }

    public String[] getPropertyAsArray(String string, String string2) {
        StringTokenizer stringTokenizer;
        int n;
        String string3 = this.getProperty(string, string2);
        if (string3 != null && (n = (stringTokenizer = new StringTokenizer(string3, ", \t")).countTokens()) > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            return stringArray;
        }
        return null;
    }

    public int getPropertyAsInt(String string, int n) {
        String string2 = this.getProperty(string, null);
        return string2 != null ? this.parseInt(string, string2, n) : n;
    }

    public long getPropertyAsLong(String string, long l) {
        String string2 = this.getProperty(string, null);
        return string2 != null ? this.parseLong(string, string2, l) : l;
    }

    public float getPropertyAsFloat(String string, float f) {
        String string2 = this.getProperty(string, null);
        return string2 != null ? this.parseFloat(string, string2, f) : f;
    }

    public double getPropertyAsDouble(String string, double d) {
        String string2 = this.getProperty(string, null);
        return string2 != null ? this.parseDouble(string, string2, d) : d;
    }

    public boolean getPropertyAsBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string, null);
        return string2 != null ? this.parseBoolean(string, string2, bl) : bl;
    }

    protected int parseInt(String string, String string2, int n) {
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            if (logCache == null) {
                logCache = Logger.getLogger(ConfigManager.class.getName());
            }
            logCache.warning("config '" + string + "' has a non-integer value '" + string2 + '\'');
            return n;
        }
    }

    protected long parseLong(String string, String string2, long l) {
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            if (logCache == null) {
                logCache = Logger.getLogger(ConfigManager.class.getName());
            }
            logCache.warning("config '" + string + "' has a non-long value '" + string2 + '\'');
            return l;
        }
    }

    protected float parseFloat(String string, String string2, float f) {
        try {
            return Float.parseFloat(string2);
        }
        catch (Exception exception) {
            if (logCache == null) {
                logCache = Logger.getLogger(ConfigManager.class.getName());
            }
            logCache.warning("config '" + string + "' has a non-float value '" + string2 + '\'');
            return f;
        }
    }

    protected double parseDouble(String string, String string2, double d) {
        try {
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            if (logCache == null) {
                logCache = Logger.getLogger(ConfigManager.class.getName());
            }
            logCache.warning("config '" + string + "' has a non-double value '" + string2 + '\'');
            return d;
        }
    }

    protected boolean parseBoolean(String string, String string2, boolean bl) {
        return "true".equals(string2) || "yes".equals(string2) || "1".equals(string2);
    }

    public Object[] createInstances(String string, Class clazz) throws IllegalConfigurationException {
        return this.createInstances(string, clazz, this.getPropertyAsArray(string + ".names"));
    }

    public Object[] createInstances(String string, Class clazz, String[] stringArray) throws IllegalConfigurationException {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string2 = null;
        String string32 = null;
        String string4 = this.getProperty(string + ".class");
        try {
            Object[] objectArray = (Object[])Array.newInstance(clazz, stringArray.length);
            for (String string32 : stringArray) {
                string2 = this.getProperty(string + '.' + string32 + ".class", string4);
                if (string2 == null) {
                    throw new IllegalConfigurationException("no class definition for " + string + ' ' + string32);
                }
                objectArray[var8_10] = Class.forName(string2).newInstance();
            }
            return objectArray;
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            throw illegalConfigurationException;
        }
        catch (Exception exception) {
            throw (IllegalConfigurationException)new IllegalConfigurationException("could not create " + string + ' ' + string32 + " '" + string2 + '\'').initCause(exception);
        }
    }

    public static int compareVersion(String string, String string2) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        do {
            int n5;
            int n6 = string.indexOf(46, n);
            int n7 = string2.indexOf(46, n2);
            if (n6 < 0) {
                n6 = n3;
            }
            if (n7 < 0) {
                n7 = n4;
            }
            if ((n5 = ConfigManager.compareVersion(string, n, n6, string2, n2, n7)) != 0) {
                return n5;
            }
            n = n6 + 1;
            n2 = n7 + 1;
        } while (n < n3 || n2 < n4);
        return 0;
    }

    private static int compareVersion(String string, int n, int n2, String string2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = n4 - n3;
        int n7 = n5 > n6 ? n5 : n6;
        int n8 = 0;
        int n9 = n2 - n7;
        int n10 = n4 - n7;
        while (n8 < n7) {
            int n11;
            int n12 = n9 < n || n9 >= n2 ? 48 : (int)string.charAt(n9);
            int n13 = n11 = n10 < n3 || n10 >= n4 ? 48 : (int)string2.charAt(n10);
            if (n12 < n11) {
                return -1;
            }
            if (n12 > n11) {
                return 1;
            }
            ++n8;
            ++n9;
            ++n10;
        }
        return 0;
    }
}

