/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.util;

public class FormatUtils {
    private FormatUtils() {
    }

    public static String formatAmount(long l) {
        long l2 = l >= 0L ? l : -l;
        String string = Long.toString(l2);
        boolean bl = string.length() > 6;
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 0L) {
            stringBuffer.append('-');
        }
        int n = string.length() - (bl ? 6 : 0);
        int n2 = 0;
        for (int i = n; i > 0; --i) {
            stringBuffer.append(string.charAt(n - i));
            if (i > 1 && (2 + n - n2) % 3 == 0) {
                stringBuffer.append(' ');
            }
            ++n2;
        }
        if (n2 < 4 && bl) {
            stringBuffer.append('.');
            while (n2 < 4) {
                stringBuffer.append(string.charAt(n++));
                ++n2;
            }
        }
        if (bl) {
            stringBuffer.append(" M");
        }
        return stringBuffer.toString();
    }

    public static String formatLong(long l) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        char[] cArray = new char[26];
        int n = cArray.length - 1;
        if (l == 0L) {
            cArray[n--] = 48;
        } else {
            int n2 = 0;
            while (l > 0L && n >= 0) {
                if (n2 % 3 == 0 && n2 > 0 && n > 0) {
                    cArray[n--] = 32;
                }
                cArray[n--] = (char)(48L + l % 10L);
                l /= 10L;
                ++n2;
            }
        }
        if (bl && n >= 0) {
            cArray[n--] = 45;
        }
        return new String(cArray, n + 1, cArray.length - n - 1);
    }

    public static String formatLong(long l, String string) {
        boolean bl;
        boolean bl2 = bl = l < 0L;
        if (bl) {
            l = -l;
        }
        int n = string.length();
        int n2 = 20 + 6 * n;
        char[] cArray = new char[n2];
        int n3 = n2 - 1;
        if (l == 0L) {
            cArray[n3--] = 48;
        } else {
            int n4 = 0;
            while (l > 0L && n3 >= 0) {
                if (n4 % 3 == 0 && n4 > 0 && n3 > n) {
                    string.getChars(0, n, cArray, (n3 -= n) + 1);
                }
                cArray[n3--] = (char)(48L + l % 10L);
                l /= 10L;
                ++n4;
            }
        }
        if (bl && n3 >= 0) {
            cArray[n3--] = 45;
        }
        return new String(cArray, n3 + 1, n2 - n3 - 1);
    }

    public static String formatDouble(double d) {
        boolean bl;
        boolean bl2 = bl = d < 0.0 || d == 0.0 && 1.0 / d < 0.0;
        if (bl) {
            d = -d;
        }
        char[] cArray = new char[29];
        long l = (long)d;
        int n = (int)((d - (double)l) * 100.0 + 0.5);
        int n2 = cArray.length - 1;
        cArray[n2--] = (char)(48 + n % 10);
        cArray[n2--] = (char)(48 + n / 10 % 10);
        cArray[n2--] = 46;
        if (l == 0L) {
            cArray[n2--] = 48;
        } else {
            int n3 = 0;
            while (l > 0L && n2 >= 0) {
                if (n3 % 3 == 0 && n3 > 0 && n2 > 0) {
                    cArray[n2--] = 32;
                }
                cArray[n2--] = (char)(48L + l % 10L);
                l /= 10L;
                ++n3;
            }
        }
        if (bl && n2 >= 0) {
            cArray[n2--] = 45;
        }
        return new String(cArray, n2 + 1, cArray.length - n2 - 1);
    }

    public static String formatDouble(double d, String string) {
        boolean bl;
        boolean bl2 = bl = d < 0.0 || d == 0.0 && 1.0 / d < 0.0;
        if (bl) {
            d = -d;
        }
        int n = string.length();
        int n2 = 20 + 6 * n + 3;
        char[] cArray = new char[n2];
        long l = (long)d;
        int n3 = (int)((d - (double)l) * 100.0 + 0.5);
        int n4 = n2 - 1;
        cArray[n4--] = (char)(48 + n3 % 10);
        cArray[n4--] = (char)(48 + n3 / 10 % 10);
        cArray[n4--] = 46;
        if (l == 0L) {
            cArray[n4--] = 48;
        } else {
            int n5 = 0;
            while (l > 0L && n4 >= 0) {
                if (n5 % 3 == 0 && n5 > 0 && n4 > n) {
                    string.getChars(0, n, cArray, (n4 -= n) + 1);
                }
                cArray[n4--] = (char)(48L + l % 10L);
                l /= 10L;
                ++n5;
            }
        }
        if (bl && n4 >= 0) {
            cArray[n4--] = 45;
        }
        return new String(cArray, n4 + 1, n2 - n4 - 1);
    }
}

