/*
 * Decompiled with CFR 0.152.
 */
package se.sics.isl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogFormatter
extends Formatter {
    private static final String EOL = System.getProperty("line.separator", "\r\n");
    private Hashtable aliasTable;
    private int aliasLevel = 0;
    private SimpleDateFormat dFormat = new SimpleDateFormat("dd/MM HH:mm:ss");
    private Date date = new Date(0L);
    private boolean isUTC = false;
    private long timeDiff = 0L;
    private boolean isShowingThreads = false;
    private Thread lastThread = null;
    private String lastThreadName = null;

    public synchronized String format(LogRecord logRecord) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.date.setTime(logRecord.getMillis() + this.timeDiff);
        stringBuffer.append(this.dFormat.format(this.date));
        if (this.isShowingThreads) {
            object = Thread.currentThread();
            if (object != this.lastThread) {
                this.lastThread = object;
                this.lastThreadName = ((Thread)object).getName();
            }
            stringBuffer.append(" [").append(this.lastThreadName).append(']');
        }
        stringBuffer.append(' ').append(logRecord.getLevel()).append(' ').append(this.getAliasFor(logRecord.getLoggerName())).append('|').append(logRecord.getMessage()).append(EOL);
        if (logRecord.getThrown() != null) {
            try {
                object = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)object);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(((StringWriter)object).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public synchronized void setLogTime(long l) {
        this.timeDiff = l - System.currentTimeMillis();
        if (!this.isUTC) {
            this.isUTC = true;
            this.dFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        }
    }

    public boolean isShowingThreads() {
        return this.isShowingThreads;
    }

    public synchronized void setShowingThreads(boolean bl) {
        this.isShowingThreads = bl;
        if (!bl) {
            this.lastThread = null;
            this.lastThreadName = null;
        }
    }

    private String getAliasFor(String string) {
        Hashtable hashtable = this.aliasTable;
        if (hashtable == null) {
            return string;
        }
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return string2;
        }
        int n = this.aliasLevel;
        if (n > 0) {
            String string3;
            if (n == 1) {
                int n2 = string.lastIndexOf(46);
                string3 = n2 >= 0 && n2 < string.length() - 1 ? string.substring(n2 + 1) : string;
            } else {
                int n3;
                for (n3 = string.length() - 2; n3 >= 0 && (string.charAt(n3) != '.' || --n != 0); --n3) {
                }
                string3 = n3 >= 0 ? string.substring(n3 + 1) : string;
            }
            hashtable.put(string, string3);
            return string3;
        }
        this.aliasTable = null;
        return string;
    }

    public synchronized void setAliasLevel(int n) {
        if (this.aliasLevel != n) {
            this.aliasLevel = n;
            this.aliasTable = n > 0 ? new Hashtable() : null;
        }
    }

    public static void separator(Logger logger, Level level, String string) {
        LogFormatter.separator(logger, level, string, string);
    }

    public static void separator(Logger logger, Level level, String string, String string2) {
        logger.log(level, string + EOL + "************************************************************" + EOL + "* " + string2 + EOL + "************************************************************" + EOL + EOL);
    }

    public static void setFormatterForAllHandlers(Formatter formatter) {
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        if (handlerArray != null) {
            int n = handlerArray.length;
            for (int i = 0; i < n; ++i) {
                handlerArray[i].setFormatter(formatter);
            }
        }
    }

    public static void setConsoleLevel(Level level) {
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        if (handlerArray != null) {
            int n = handlerArray.length;
            for (int i = 0; i < n; ++i) {
                if (!(handlerArray[i] instanceof ConsoleHandler)) continue;
                handlerArray[i].setLevel(level);
            }
        }
    }

    public static Level getLogLevel(int n) {
        if (n <= 0) {
            return Level.ALL;
        }
        switch (n) {
            case 1: {
                return Level.FINEST;
            }
            case 2: {
                return Level.FINER;
            }
            case 3: {
                return Level.FINE;
            }
            case 4: {
                return Level.WARNING;
            }
            case 5: {
                return Level.SEVERE;
            }
        }
        return Level.OFF;
    }

    public static void setFileLevel(Level level) {
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        if (handlerArray != null) {
            int n = handlerArray.length;
            for (int i = 0; i < n; ++i) {
                if (!(handlerArray[i] instanceof FileHandler)) continue;
                handlerArray[i].setLevel(level);
            }
        }
    }

    public static void setLevelForAllHandlers(Level level) {
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        if (handlerArray != null) {
            int n = handlerArray.length;
            for (int i = 0; i < n; ++i) {
                handlerArray[i].setLevel(level);
            }
        }
    }
}

