/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw;

import java.util.Enumeration;
import java.util.Hashtable;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.aw.AgentService;
import se.sics.tasim.aw.Message;
import se.sics.tasim.aw.TimeListener;

public abstract class Agent {
    public static final String COORDINATOR = "coordinator";
    public static final String ADMIN = "admin";
    private static int lastID = 0;
    private AgentService service;

    private synchronized int generateNextID() {
        return lastID++;
    }

    protected Agent() {
    }

    final void init(AgentService agentService) {
        if (this.service != null) {
            throw new IllegalStateException("already initialized");
        }
        this.service = agentService;
    }

    public String getName() {
        return this.service.getName();
    }

    public String getAddress() {
        return this.service.getAddress();
    }

    protected long getServerTime() {
        return this.service.getServerTime();
    }

    protected int getNextID() {
        return this.generateNextID();
    }

    protected void addTimeListener(TimeListener timeListener) {
        this.service.addTimeListener(timeListener);
    }

    protected void removeTimeListener(TimeListener timeListener) {
        this.service.removeTimeListener(timeListener);
    }

    protected void sendMessage(Message message) {
        this.service.sendMessage(message);
    }

    protected void sendMessage(String string, Transportable transportable) {
        this.service.sendMessage(new Message(string, transportable));
    }

    protected void sendMessages(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Transportable transportable = (Transportable)hashtable.get(string);
            this.sendMessage(string, transportable);
        }
    }

    protected void sendToRole(int n, Transportable transportable) {
        this.service.sendToRole(n, transportable);
    }

    protected abstract void messageReceived(Message var1);

    protected abstract void simulationSetup();

    protected void simulationStopped() {
    }

    protected abstract void simulationFinished();
}

