/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw;

import se.sics.isl.transport.Transportable;
import se.sics.tasim.aw.Agent;
import se.sics.tasim.aw.Message;
import se.sics.tasim.aw.TimeListener;

public abstract class AgentService {
    private final Agent agent;
    private String name;
    private String address;

    protected AgentService(Agent agent, String string) {
        if (agent == null || string == null) {
            throw new NullPointerException();
        }
        this.agent = agent;
        this.address = this.name = string;
    }

    protected void initializeAgent() {
        this.agent.init(this);
    }

    protected void simulationSetup(String string) {
        if (string != null) {
            this.address = string;
        }
        this.agent.simulationSetup();
    }

    protected void simulationStopped() {
        this.agent.simulationStopped();
    }

    protected void simulationFinished() {
        this.agent.simulationFinished();
    }

    protected abstract void addTimeListener(TimeListener var1);

    protected abstract void removeTimeListener(TimeListener var1);

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public Agent getAgent() {
        return this.agent;
    }

    protected abstract long getServerTime();

    protected void sendMessage(Message message) {
        if (this.address == null) {
            throw new IllegalStateException("not initialized");
        }
        String string = message.getSender();
        if (string == null) {
            message.setSender(this.address);
        } else if (!string.equals(this.address)) {
            throw new SecurityException("Can not send message from other than self: Self=" + this.address + ", Sender=" + string);
        }
        this.deliverToServer(message);
    }

    protected abstract void deliverToServer(Message var1);

    protected void sendToRole(int n, Transportable transportable) {
        if (this.address == null) {
            throw new IllegalStateException("not initialized");
        }
        this.deliverToServer(n, transportable);
    }

    protected abstract void deliverToServer(int var1, Transportable var2);

    protected void deliverToAgent(Message message) {
        this.agent.messageReceived(message);
    }
}

