/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw;

import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class Message
implements Transportable {
    private String sender;
    private String receiver;
    private Transportable content;

    public Message(String string, Transportable transportable) {
        if (string == null) {
            throw new NullPointerException("receiver");
        }
        if (transportable == null) {
            throw new NullPointerException("content");
        }
        this.receiver = string;
        this.content = transportable;
    }

    public Message(String string, String string2, Transportable transportable) {
        this(string2, transportable);
        this.sender = string;
    }

    public Message() {
    }

    public String getSender() {
        return this.sender;
    }

    public synchronized void setSender(String string) {
        if (this.sender != null) {
            throw new IllegalStateException("sender already set");
        }
        this.sender = string;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public Transportable getContent() {
        return this.content;
    }

    public Message createReply(Transportable transportable) {
        return new Message(this.receiver, this.sender, transportable);
    }

    public String toString() {
        return "Message[" + this.sender + ',' + this.receiver + ',' + this.content + ']';
    }

    public String getTransportName() {
        return "message";
    }

    public void read(TransportReader transportReader) throws ParseException {
        if (this.receiver != null) {
            throw new IllegalStateException("already initialized");
        }
        String string = transportReader.getAttribute("receiver");
        String string2 = transportReader.getAttribute("sender");
        transportReader.nextNode(true);
        this.content = transportReader.readTransportable();
        this.receiver = string;
        this.sender = string2;
    }

    public void write(TransportWriter transportWriter) {
        if (this.receiver == null) {
            throw new IllegalStateException("not initalized");
        }
        if (this.sender == null) {
            throw new IllegalStateException("no sender");
        }
        transportWriter.attr("sender", this.sender);
        transportWriter.attr("receiver", this.receiver);
        transportWriter.write(this.content);
    }
}

