/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw.client;

import com.botbox.util.ArrayUtils;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.aw.Agent;
import se.sics.tasim.aw.AgentService;
import se.sics.tasim.aw.Message;
import se.sics.tasim.aw.TimeListener;
import se.sics.tasim.aw.client.SimClient;
import se.sics.tasim.props.SimulationStatus;
import se.sics.tasim.props.StartInfo;

public class AgentServiceImpl
extends AgentService {
    private static final Logger log = Logger.getLogger(AgentServiceImpl.class.getName());
    private StartInfo startInfo;
    private TimeListener[] timeListeners;
    private SimClient client;
    private int currentTimeUnit = -1;
    private int maxTimeUnits = Integer.MAX_VALUE;
    private int simulationDay = -1;
    private boolean isAwaitingNewDay = true;
    private int timerTimeUnit;
    private Timer timer;
    private TimerTask timerTask;

    public AgentServiceImpl(SimClient simClient, String string, Agent agent, Message message) {
        super(agent, string);
        this.client = simClient;
        this.startInfo = (StartInfo)message.getContent();
        this.initializeAgent();
        this.simulationSetup(message.getReceiver());
        int n = this.startInfo.getSecondsPerDay() * 1000;
        if (n > 0) {
            this.maxTimeUnits = this.startInfo.getNumberOfDays() + 1;
            this.setupTimer(this.startInfo.getStartTime(), n);
        }
    }

    final void stopAgent() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timerTask = null;
        this.timer = null;
        this.simulationStopped();
        this.simulationFinished();
    }

    protected void deliverToServer(Message message) {
        this.client.deliverToServer(message);
    }

    protected void deliverToServer(int n, Transportable transportable) {
        log.severe("Agent can not deliver to role " + n);
    }

    protected long getServerTime() {
        return this.client.getServerTime();
    }

    protected void deliverToAgent(Message message) {
        if (this.isAwaitingNewDay) {
            this.isAwaitingNewDay = false;
            this.notifyTimeListeners(++this.simulationDay);
        }
        try {
            Transportable transportable = message.getContent();
            if (transportable instanceof SimulationStatus) {
                this.simulationDay = ((SimulationStatus)transportable).getCurrentDate();
                this.isAwaitingNewDay = true;
                this.notifyTimeListeners(this.simulationDay);
            }
            super.deliverToAgent(message);
        }
        catch (ThreadDeath threadDeath) {
            log.log(Level.SEVERE, "message thread died", threadDeath);
            throw threadDeath;
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, "agent could not handle message " + message, throwable);
        }
    }

    private void setupTimer(long l, int n) {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            public void run() {
                AgentServiceImpl.this.tick();
            }
        };
        long l2 = l + this.client.getTimeDiff();
        long l3 = this.client.getServerTime();
        if (l3 > l) {
            this.currentTimeUnit = (int)((l3 - l) / (long)n);
            l2 += (long)(this.currentTimeUnit * n);
        }
        this.timer.scheduleAtFixedRate(this.timerTask, new Date(l2), (long)n);
    }

    private void tick() {
        this.notifyTimeListeners(this.timerTimeUnit++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTimeListeners(int n) {
        boolean bl = false;
        TimeListener[] timeListenerArray = this;
        synchronized (this) {
            if (n > this.currentTimeUnit) {
                this.currentTimeUnit = n;
                bl = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (bl) {
                log.fine("*** TIME UNIT " + this.currentTimeUnit);
                if (n > this.maxTimeUnits) {
                    this.client.showWarning("Forced Simulation End", "forcing simulation to end at time unit " + n + " (max " + this.maxTimeUnits + " time units)");
                    this.client.stopSimulation((AgentServiceImpl)this);
                } else {
                    timeListenerArray = this.timeListeners;
                    if (timeListenerArray != null) {
                        int n2 = timeListenerArray.length;
                        for (int i = 0; i < n2; ++i) {
                            try {
                                timeListenerArray[i].nextTimeUnit(this.currentTimeUnit);
                                continue;
                            }
                            catch (ThreadDeath threadDeath) {
                                throw threadDeath;
                            }
                            catch (Throwable throwable) {
                                log.log(Level.SEVERE, "could not deliver time unit " + this.currentTimeUnit + " to " + timeListenerArray[i], throwable);
                            }
                        }
                    }
                }
            }
            return;
        }
    }

    protected synchronized void addTimeListener(TimeListener timeListener) {
        this.timeListeners = (TimeListener[])ArrayUtils.add(TimeListener.class, this.timeListeners, timeListener);
    }

    protected synchronized void removeTimeListener(TimeListener timeListener) {
        this.timeListeners = (TimeListener[])ArrayUtils.remove((Object[])this.timeListeners, timeListener);
    }
}

