/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw.client;

import java.io.IOException;
import se.sics.isl.util.ArgumentManager;
import se.sics.tasim.aw.client.SimClient;

public class Main {
    private static String DEFAULT_HOST = "localhost";
    private static int DEFAULT_PORT = 6502;
    private static final String DEFAULT_CONFIG = "aw.conf";

    private Main() {
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        ArgumentManager argumentManager = new ArgumentManager("scmaw.jar", stringArray);
        argumentManager.addOption("config", "configfile", "set the config file to use");
        argumentManager.addOption("serverHost", "host", "set the TAC server host");
        argumentManager.addOption("serverPort", "port", "set the TAC server port");
        argumentManager.addOption("agentName", "name", "set the agent name");
        argumentManager.addOption("agentPassword", "password", "set the agent password");
        argumentManager.addOption("agentImpl", "class", "set the agent implementation");
        argumentManager.addOption("autojoin", "numberOfTimes", "set the number of times to automatically create and join simulations");
        argumentManager.addOption("log.consoleLevel", "level", "set the console log level");
        argumentManager.addOption("log.fileLevel", "level", "set the file log level");
        argumentManager.addHelp("h", "show this help message");
        argumentManager.addHelp("help");
        argumentManager.validateArguments();
        String string = argumentManager.getArgument("config", DEFAULT_CONFIG);
        try {
            argumentManager.loadConfiguration(string);
            argumentManager.removeArgument("config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            argumentManager.usage(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        String string2 = argumentManager.getProperty("agentImpl");
        if (string2 == null || string2.length() == 0) {
            System.err.println("No agent implementation specified!");
            argumentManager.usage(1);
        }
        try {
            object = Class.forName(string2);
        }
        catch (Exception exception) {
            System.err.println("Could not find the agent implementation '" + string2 + '\'');
            exception.printStackTrace();
            System.exit(1);
        }
        object = argumentManager.getProperty("serverHost", DEFAULT_HOST);
        int n = argumentManager.getPropertyAsInt("serverPort", DEFAULT_PORT);
        String string3 = argumentManager.getProperty("agentName", null);
        String string4 = argumentManager.getProperty("agentPassword", null);
        if (string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0) {
            System.err.println("=============================================");
            System.err.println("You must specify a registered agent name");
            System.err.println("and password in the configuration file");
            System.err.println("or as arguments when starting the AgentWare");
            System.err.println("");
            System.err.println("You can register your agent at:");
            System.err.println("http://" + (String)object + ":8080/");
            System.err.println("=============================================");
            System.exit(1);
        }
        argumentManager.finishArguments();
        SimClient simClient = new SimClient(argumentManager, (String)object, n, string3, string4, string2);
    }
}

