/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw.client;

import com.botbox.util.ArrayQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sics.tasim.aw.Message;
import se.sics.tasim.aw.client.ServerConnection;

public class MessageSender
extends Thread {
    private static final Logger log = Logger.getLogger(MessageSender.class.getName());
    private final ServerConnection connection;
    private ArrayQueue messageQueue = new ArrayQueue();
    private boolean isClosed = false;

    public MessageSender(ServerConnection serverConnection, String string) {
        super(string);
        this.connection = serverConnection;
        this.start();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.messageQueue.clear();
            this.messageQueue.add(null);
            this.notify();
        }
    }

    public synchronized boolean addMessage(Message message) {
        if (this.isClosed) {
            return false;
        }
        this.messageQueue.add(message);
        this.notify();
        return true;
    }

    private synchronized Message nextMessage() {
        while (this.messageQueue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return (Message)this.messageQueue.remove(0);
    }

    public void run() {
        do {
            Message message = null;
            try {
                message = this.nextMessage();
                if (message == null) continue;
                this.connection.deliverMessage(message);
            }
            catch (ThreadDeath threadDeath) {
                log.log(Level.SEVERE, "message thread died", threadDeath);
                throw threadDeath;
            }
            catch (Throwable throwable) {
                log.log(Level.SEVERE, "could not handle message " + message, throwable);
            }
        } while (!this.isClosed);
    }
}

