/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sics.isl.transport.BinaryTransportReader;
import se.sics.isl.transport.BinaryTransportWriter;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.aw.Message;
import se.sics.tasim.aw.client.MessageSender;
import se.sics.tasim.aw.client.SimClient;
import se.sics.tasim.props.AdminContent;
import se.sics.tasim.props.Alert;
import se.sics.tasim.props.Ping;

public class ServerConnection
implements Runnable {
    private static final Logger log = Logger.getLogger(ServerConnection.class.getName());
    private static final byte[] TACT_HEADER = new byte[]{84, 65, 67, 84, 0, 0, 0, 0};
    private static int connectionCounter = 0;
    private final SimClient simClient;
    private int id = -1;
    private long delayInMillis = 0L;
    private MessageSender messageSender;
    private DataInputStream input;
    private DataOutputStream output;
    private Socket socket;
    private BinaryTransportWriter transportWriter = new BinaryTransportWriter();
    private BinaryTransportReader transportReader = new BinaryTransportReader();
    private boolean isAuthenticated = false;

    public ServerConnection(SimClient simClient, long l) {
        this.delayInMillis = l;
        this.simClient = simClient;
        this.transportReader.setContext(simClient.getContext());
    }

    public int getID() {
        return this.id;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticated(boolean bl) {
        this.isAuthenticated = bl;
        if (bl) {
            log.finer("(" + this.id + ") successfully logged in as " + this.simClient.getUserName());
        }
    }

    public void setTransportSupported(String string) {
        this.transportWriter.setSupported(string, true);
    }

    public boolean sendMessage(Message message) {
        if (this.messageSender == null) {
            return false;
        }
        return this.messageSender.addMessage(message);
    }

    public void open() {
        if (this.id > 0) {
            throw new IllegalStateException("already opened");
        }
        this.id = ++connectionCounter;
        new Thread((Runnable)this, "Connection." + this.id).start();
    }

    public void close() {
        AdminContent adminContent = new AdminContent(8);
        Message message = new Message(this.simClient.getUserName(), "admin", adminContent);
        if (!this.sendMessage(message)) {
            this.disconnect();
            this.simClient.connectionClosed(this);
        }
    }

    private boolean connect() {
        try {
            String string = this.simClient.getServerHost();
            int n = this.simClient.getServerPort();
            log.fine("(" + this.id + ") connecting to server " + string + " at port " + n);
            this.socket = new Socket(string, n);
            this.input = new DataInputStream(this.socket.getInputStream());
            this.output = new DataOutputStream(this.socket.getOutputStream());
            this.output.write(TACT_HEADER);
            log.fine("(" + this.id + ") connected to server " + string);
            this.messageSender = new MessageSender(this, "Sender." + this.id);
            return true;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "(" + this.id + ") connection to server failed", exception);
            this.disconnect();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnect() {
        if (this.socket != null) {
            try {
                log.fine("(" + this.id + ") disconnected from server " + this.simClient.getServerHost());
                if (this.output != null) {
                    this.output.close();
                }
                if (this.input != null) {
                    this.input.close();
                }
                this.socket.close();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "(" + this.id + ") could not close connection", exception);
            }
            finally {
                this.socket = null;
                this.output = null;
                this.input = null;
                this.isAuthenticated = false;
                if (this.messageSender != null) {
                    this.messageSender.close();
                    this.messageSender = null;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.delayInMillis > 0L) {
            try {
                Thread.sleep(this.delayInMillis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        do {
            if (this.connect()) continue;
            this.simClient.showWarning("Connection Failed", "Could not connect to " + this.simClient.getServerHost() + " (will retry in 30 seconds)");
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (this.messageSender == null);
        this.simClient.connectionOpened(this);
        try {
            byte[] byArray = new byte[8192];
            while (this.socket != null) {
                Transportable transportable;
                int n = this.input.readInt();
                if (n > byArray.length) {
                    byArray = new byte[n + 8192];
                }
                this.input.readFully(byArray, 0, n);
                Message message = this.parseMessage(byArray, 0, n);
                if (message == null) continue;
                Transportable transportable2 = message.getContent();
                if (transportable2 instanceof AdminContent) {
                    transportable = (AdminContent)transportable2;
                    if (transportable.getType() == 8) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("(" + this.id + ") received " + message);
                        }
                        this.disconnect();
                        this.simClient.connectionClosed(this);
                        continue;
                    }
                    this.simClient.adminFromServer(this, (AdminContent)transportable);
                    continue;
                }
                if (transportable2 instanceof Alert) {
                    transportable = (Alert)transportable2;
                    this.simClient.alertFromServer(this, (Alert)transportable);
                    continue;
                }
                if (transportable2 instanceof Ping) {
                    this.sendMessage(message.createReply(new Ping(1)));
                    continue;
                }
                this.simClient.messageFromServer(this, message);
            }
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, "(" + this.id + ") could not read", throwable);
        }
        finally {
            if (this.disconnect()) {
                this.simClient.connectionClosed(this);
            }
        }
    }

    private Message parseMessage(byte[] byArray, int n, int n2) {
        try {
            Message message = new Message();
            this.transportReader.setMessage(byArray, n, n2);
            if (this.transportReader.nextNode(message.getTransportName(), false)) {
                this.transportReader.enterNode();
                message.read(this.transportReader);
                return message;
            }
            log.warning("(" + this.id + ") no message found in received data");
            return null;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "(" + this.id + ") could not parse message", exception);
            return null;
        }
    }

    boolean deliverMessage(Message message) {
        DataOutputStream dataOutputStream = this.output;
        if (dataOutputStream == null) {
            log.warning("(" + this.id + ") could not send message (closed connection) " + message);
            return false;
        }
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("(" + this.id + ") sending " + message);
            }
            String string = message.getTransportName();
            this.transportWriter.clear();
            this.transportWriter.node(string);
            message.write(this.transportWriter);
            this.transportWriter.endNode(string);
            this.transportWriter.finish();
            try {
                dataOutputStream.writeInt(this.transportWriter.size());
                this.transportWriter.write(dataOutputStream);
                dataOutputStream.flush();
                return true;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "(" + this.id + ") could not send message to server", exception);
                this.simClient.showWarning("Connection Failed", "could not send message to server");
                if (this.disconnect()) {
                    this.simClient.connectionClosed(this);
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "(" + this.id + ") could not generate message " + message, exception);
        }
        return false;
    }
}

