/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw.client;

import com.botbox.util.ArrayQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import se.sics.isl.transport.Context;
import se.sics.isl.transport.Transportable;
import se.sics.isl.util.ConfigManager;
import se.sics.isl.util.LogFormatter;
import se.sics.tasim.aw.Agent;
import se.sics.tasim.aw.Message;
import se.sics.tasim.aw.client.AgentServiceImpl;
import se.sics.tasim.aw.client.InfoViewer;
import se.sics.tasim.aw.client.ServerConnection;
import se.sics.tasim.aw.client.StatusInfo;
import se.sics.tasim.props.AdminContent;
import se.sics.tasim.props.Alert;
import se.sics.tasim.props.SCMInfo;
import se.sics.tasim.props.SimulationStatus;
import se.sics.tasim.props.StartInfo;

public class SimClient
implements Runnable {
    private static final Logger log = Logger.getLogger(SimClient.class.getName());
    private static final String CLIENT_VERSION = "0.9.6";
    private static final int MIN_MILLIS_BEFORE_DISCONNECT = 50000;
    private ConfigManager config;
    private String userName;
    private String userPassword;
    private String serverHost;
    private int serverPort;
    private Context currentContext;
    private long serverTimeDiff = 0L;
    private int autoJoinCount;
    private ServerConnection connection;
    private boolean isOlderServerVersion = false;
    private boolean isQuitPending = false;
    private boolean isAutoJoinPending = false;
    private ArrayQueue messageQueue = new ArrayQueue();
    private String agentImpl;
    private Agent agent;
    private AgentServiceImpl agentService;
    private StatusInfo infoViewer;
    private JFrame window;
    private boolean useGUI = false;
    private String logFilePrefix;
    private String logSimPrefix;
    private LogFormatter formatter;
    private FileHandler rootFileHandler;
    private FileHandler simLogHandler;
    private String simLogName;

    public SimClient(ConfigManager configManager, String string, int n, String string2, String string3, String string4) throws IOException {
        String string5;
        this.config = configManager;
        this.serverHost = string;
        this.serverPort = n;
        this.userName = string2;
        this.userPassword = string3;
        this.agentImpl = string4;
        this.autoJoinCount = configManager.getPropertyAsInt("autojoin", 1);
        String string6 = configManager.getProperty("log.prefix", "aw");
        this.logFilePrefix = this.getLogDirectory("log.directory", string6);
        this.logSimPrefix = this.getLogDirectory("log.sim.directory", string6);
        this.formatter = new LogFormatter();
        this.formatter.setAliasLevel(2);
        LogFormatter.setFormatterForAllHandlers(this.formatter);
        this.setLogging();
        this.currentContext = SCMInfo.createContext(AdminContent.createContext());
        this.useGUI = configManager.getPropertyAsBoolean("useGUI", false);
        if (this.useGUI && (string5 = configManager.getProperty("infoviewer")) != null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                log.warning("unsupported look-and-feel: " + unsupportedLookAndFeelException);
            }
            catch (Exception exception) {
                log.warning("could not change look-and-feel: " + exception);
            }
            try {
                InfoViewer infoViewer = (InfoViewer)Class.forName(string5).newInstance();
                this.infoViewer = new StatusInfo(this, infoViewer);
                this.infoViewer.init(string2);
                this.window = new JFrame("Information about agent " + string2);
                this.window.setDefaultCloseOperation(0);
                this.window.getContentPane().add(this.infoViewer.getComponent());
                this.window.pack();
                this.window.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        SimClient.this.requestQuit();
                    }
                });
                this.window.setVisible(true);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "could not create information viewer " + string5, exception);
                System.exit(1);
            }
        }
        if (!this.createAgentInstance()) {
            this.showWarning("Agent Setup Failed", "could not setup the agent");
            System.exit(1);
        }
        this.connection = new ServerConnection(this, 0L);
        this.connection.open();
        new Thread((Runnable)this, "SimClient").start();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Context getContext() {
        return this.currentContext;
    }

    public long getServerTime() {
        return System.currentTimeMillis() - this.serverTimeDiff;
    }

    public long getTimeDiff() {
        return this.serverTimeDiff;
    }

    private void requestServerTime() {
        AdminContent adminContent = new AdminContent(5);
        Message message = new Message(this.userName, "admin", adminContent);
        this.deliverToServer(message);
    }

    public void requestQuit() {
        this.isQuitPending = true;
        this.clearMessages();
        ServerConnection serverConnection = this.connection;
        if (serverConnection != null) {
            serverConnection.close();
        } else {
            System.exit(1);
        }
    }

    public void autoJoinSimulation(boolean bl) {
        if (this.autoJoinCount > 0 || bl) {
            if (this.isAutoJoinPending) {
                this.isAutoJoinPending = false;
            } else {
                --this.autoJoinCount;
            }
            this.requestJoinSimulation();
        }
    }

    public void requestJoinSimulation() {
        AdminContent adminContent = new AdminContent(7);
        Message message = new Message(this.userName, "admin", adminContent);
        this.deliverToServer(message);
    }

    private boolean createAgentInstance() {
        if (this.agent != null) {
            return true;
        }
        try {
            log.finer("creating agent instance of " + this.agentImpl);
            this.agent = (Agent)Class.forName(this.agentImpl).newInstance();
            return true;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, "could not create an agent instance of " + this.agentImpl, throwable);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupAgent(Message message) {
        this.shutdownAgent();
        if (!this.createAgentInstance()) {
            this.showWarning("Agent Setup Failed", "could not setup the agent");
            this.requestQuit();
            return false;
        }
        StartInfo startInfo = (StartInfo)message.getContent();
        this.enterSimulationLog(startInfo.getSimulationID());
        try {
            Agent agent = this.agent;
            this.agent = null;
            log.finer("creating agent service based on " + startInfo);
            this.agentService = new AgentServiceImpl(this, this.userName, agent, message);
            this.agentService.deliverToAgent(message);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.agentService == null) {
                this.exitSimulationLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAgent() {
        AgentServiceImpl agentServiceImpl = this.agentService;
        if (agentServiceImpl != null) {
            this.agentService = null;
            try {
                log.finer("stopping agent service");
                agentServiceImpl.stopAgent();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "could not stop old agent", exception);
            }
            finally {
                this.exitSimulationLog();
                if (this.infoViewer != null) {
                    this.infoViewer.stopSimulation();
                }
            }
        }
    }

    protected void stopSimulation(AgentServiceImpl agentServiceImpl) {
        if (this.agentService == agentServiceImpl) {
            this.shutdownAgent();
            this.autoJoinSimulation(false);
        }
    }

    protected boolean deliverToServer(Message message) {
        ServerConnection serverConnection = this.connection;
        if (serverConnection == null) {
            return false;
        }
        if (serverConnection.sendMessage(message)) {
            if (this.infoViewer != null) {
                this.infoViewer.messageSent(message.getReceiver(), message.getContent());
            }
            return true;
        }
        return false;
    }

    boolean connectionOpened(ServerConnection serverConnection) {
        if (this.connection != serverConnection) {
            serverConnection.close();
            return false;
        }
        AdminContent adminContent = new AdminContent(4);
        adminContent.setAttribute("name", this.userName);
        adminContent.setAttribute("password", this.userPassword);
        adminContent.setAttribute("client.version", CLIENT_VERSION);
        Message message = new Message(this.userName, "admin", adminContent);
        this.isOlderServerVersion = false;
        return serverConnection.sendMessage(message);
    }

    void connectionClosed(ServerConnection serverConnection) {
        if (this.connection == serverConnection) {
            this.connection = null;
            this.clearMessages();
            if (this.isQuitPending) {
                System.exit(0);
            } else {
                this.isAutoJoinPending = true;
                this.connection = new ServerConnection(this, 30000L);
                this.connection.open();
                this.showWarning("Connection Lost", "Lost connection to " + this.serverHost + " (will reconnect in 30 seconds)");
                this.shutdownAgent();
            }
        }
    }

    void showWarning(String string, String string2) {
        log.severe("************************************************************");
        log.severe("* " + string);
        log.severe("* " + string2);
        log.severe("************************************************************");
    }

    void messageFromServer(ServerConnection serverConnection, Message message) {
        if (this.connection != serverConnection) {
            serverConnection.close();
        } else {
            this.addMessage(message, serverConnection.getID());
        }
    }

    void adminFromServer(ServerConnection serverConnection, AdminContent adminContent) {
        if (this.connection != serverConnection) {
            serverConnection.close();
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("(" + serverConnection.getID() + ") received " + adminContent);
            }
            if (this.infoViewer != null) {
                this.infoViewer.messageReceived("admin", adminContent);
            }
            this.handleAdminContent(adminContent);
        }
    }

    void alertFromServer(ServerConnection serverConnection, Alert alert) {
        if (this.connection != serverConnection) {
            serverConnection.close();
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("(" + serverConnection.getID() + ") received " + alert);
            }
            this.handleAlert(alert);
        }
    }

    private synchronized void addMessage(Message message, int n) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("(" + n + ") received " + message);
        }
        this.messageQueue.add(message);
        this.notify();
    }

    private synchronized Message nextMessage() {
        while (this.messageQueue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return (Message)this.messageQueue.remove(0);
    }

    private synchronized void clearMessages() {
        this.messageQueue.clear();
    }

    public void run() {
        while (true) {
            Message message = null;
            try {
                message = this.nextMessage();
                Transportable transportable = message.getContent();
                if (this.infoViewer != null) {
                    this.infoViewer.messageReceived(message.getSender(), transportable);
                }
                if (transportable instanceof AdminContent) {
                    this.handleAdminContent((AdminContent)transportable);
                    continue;
                }
                if (transportable instanceof StartInfo) {
                    this.setupAgent(message);
                    continue;
                }
                if (transportable instanceof Alert) {
                    this.handleAlert((Alert)transportable);
                    continue;
                }
                if (this.agentService != null) {
                    SimulationStatus simulationStatus;
                    this.agentService.deliverToAgent(message);
                    if (!(transportable instanceof SimulationStatus) || !(simulationStatus = (SimulationStatus)transportable).isSimulationEnded()) continue;
                    this.stopSimulation(this.agentService);
                    continue;
                }
                log.severe("No agent registered to receive " + message);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                log.log(Level.SEVERE, "message thread died", threadDeath);
                throw threadDeath;
            }
            catch (Throwable throwable) {
                log.log(Level.SEVERE, "could not handle message " + message, throwable);
                continue;
            }
            break;
        }
    }

    private void handleAdminContent(AdminContent adminContent) {
        ServerConnection serverConnection = this.connection;
        int n = adminContent.getType();
        if (adminContent.isError()) {
            if (n == 4) {
                this.showWarning("Authentication Failed", "could not login as " + this.userName + ": " + adminContent.getErrorReason());
                this.requestQuit();
            } else {
                this.showWarning("Request Failed", "Failed to " + AdminContent.getTypeAsString(n) + ": " + AdminContent.getErrorAsString(adminContent.getError()) + " (" + adminContent.getErrorReason() + ')');
            }
        } else if (serverConnection != null) {
            switch (n) {
                case 4: {
                    String string = adminContent.getAttribute("server.version");
                    serverConnection.setAuthenticated(true);
                    if (ConfigManager.compareVersion(string, "0.8.13") >= 0) {
                        serverConnection.setTransportSupported("tables");
                    }
                    if (ConfigManager.compareVersion(string, "0.9") >= 0) break;
                    this.isOlderServerVersion = true;
                    this.requestServerTime();
                    this.autoJoinSimulation(false);
                    break;
                }
                case 5: {
                    long l = adminContent.getAttributeAsLong("time", 0L);
                    if (l <= 0L) break;
                    this.serverTimeDiff = System.currentTimeMillis() - l;
                    this.formatter.setLogTime(l);
                    break;
                }
                case 6: 
                case 7: {
                    long l;
                    long l2 = this.getServerTime();
                    long l3 = adminContent.getAttributeAsLong("startTime", 0L);
                    long l4 = 0L;
                    if (l3 > 0L) {
                        String string;
                        int n2 = adminContent.getAttributeAsInt("simulation", -1);
                        String string2 = string = n2 >= 0 ? " " + n2 : "";
                        if (this.agentService == null && !this.createAgentInstance()) {
                            this.showWarning("Agent Setup Failed", "could not setup the agent");
                            this.requestQuit();
                        }
                        if (l3 > l2) {
                            log.info("next simulation" + string + " starts in " + (l3 - l2) / 1000L + " seconds");
                        } else {
                            log.info("next simulation" + string + " has already started");
                        }
                        l4 = l3 - 15000L;
                    } else if (this.autoJoinCount > 0 && n == 6) {
                        this.autoJoinSimulation(false);
                    } else {
                        l4 = adminContent.getAttributeAsLong("nextTime", 0L);
                        if (l4 < l2) {
                            l4 = l2 + 60L * (long)(20000.0 + Math.random() * 5000.0);
                        }
                    }
                    if (l4 <= l2 || (l = l4 - l2) <= 50000L) break;
                    long l5 = 60L * (long)(56000.0 + Math.random() * 1000.0);
                    if (l > l5) {
                        l = l5;
                    }
                    log.info("[will reconnect in " + l / 60000L + " minutes, " + l / 1000L % 60L + " seconds]");
                    this.isAutoJoinPending = true;
                    this.connection = new ServerConnection(this, l);
                    this.connection.open();
                    serverConnection.close();
                    break;
                }
                default: {
                    log.warning("unhandled admin content: " + adminContent);
                }
            }
        }
    }

    private void handleAlert(final Alert alert) {
        this.showWarning("ALERT: " + alert.getTitle(), alert.getMessage());
        if (this.useGUI) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(SimClient.this.window, alert.getMessage(), alert.getTitle(), 0);
                }
            });
        }
    }

    private synchronized void setLogging() throws IOException {
        int n = this.config.getPropertyAsInt("log.consoleLevel", 0);
        int n2 = this.config.getPropertyAsInt("log.fileLevel", 0);
        Level level = LogFormatter.getLogLevel(n);
        Level level2 = LogFormatter.getLogLevel(n2);
        Level level3 = level.intValue() < level2.intValue() ? level : level2;
        boolean bl = this.config.getPropertyAsBoolean("log.threads", false);
        String[] stringArray = this.config.getPropertyAsArray("log.packages", "se.sics");
        if (stringArray != null && stringArray.length > 0) {
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                Logger.getLogger(stringArray[i]).setLevel(level3);
            }
        } else {
            Logger logger = Logger.getLogger("se.sics");
            logger.setLevel(level3);
        }
        this.formatter.setShowingThreads(bl);
        LogFormatter.setConsoleLevel(level);
        Logger logger = Logger.getLogger("");
        if (level2 != Level.OFF) {
            if (this.rootFileHandler == null) {
                this.rootFileHandler = new FileHandler(this.logFilePrefix + "%g.log", 1000000, 10);
                this.rootFileHandler.setFormatter(this.formatter);
                logger.addHandler(this.rootFileHandler);
            }
            this.rootFileHandler.setLevel(level2);
            if (this.simLogHandler != null) {
                this.simLogHandler.setLevel(level2);
            }
        } else if (this.rootFileHandler != null) {
            this.exitSimulationLog();
            logger.removeHandler(this.rootFileHandler);
            this.rootFileHandler.close();
            this.rootFileHandler = null;
        }
    }

    private String getLogDirectory(String string, String string2) throws IOException {
        String string3 = this.config.getProperty(string);
        if (string3 != null) {
            File file = new File(string3);
            if (!file.exists() && !file.mkdirs() || !file.isDirectory()) {
                throw new IOException("could not create directory '" + string3 + '\'');
            }
            return file.getAbsolutePath() + File.separatorChar + string2;
        }
        return string2;
    }

    private synchronized void enterSimulationLog(int n) {
        this.exitSimulationLog();
        if (this.rootFileHandler != null) {
            LogFormatter.separator(log, Level.FINE, "Entering log for simulation " + n);
            try {
                Logger logger = Logger.getLogger("");
                String string = this.logSimPrefix + "_SIM_" + n + ".log";
                this.simLogHandler = new FileHandler(string, true);
                this.simLogHandler.setFormatter(this.formatter);
                this.simLogHandler.setLevel(this.rootFileHandler.getLevel());
                this.simLogName = string;
                logger.addHandler(this.simLogHandler);
                logger.removeHandler(this.rootFileHandler);
                LogFormatter.separator(log, Level.FINE, "Log for simulation " + n + " at " + this.serverHost + ':' + this.serverPort + " started");
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "could not open log file for simulation " + n, exception);
            }
        }
    }

    private synchronized void exitSimulationLog() {
        if (this.simLogHandler != null) {
            Logger logger = Logger.getLogger("");
            LogFormatter.separator(log, Level.FINE, "Simulation log complete");
            logger.addHandler(this.rootFileHandler);
            logger.removeHandler(this.simLogHandler);
            this.simLogHandler.close();
            this.simLogHandler = null;
            if (this.simLogName != null) {
                new File(this.simLogName + ".lck").delete();
                this.simLogName = null;
            }
        }
    }
}

