/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.aw.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.aw.client.InfoViewer;
import se.sics.tasim.aw.client.SimClient;
import se.sics.tasim.props.ActiveOrders;
import se.sics.tasim.props.AdminContent;
import se.sics.tasim.props.SimulationStatus;
import se.sics.tasim.props.StartInfo;

public class StatusInfo
extends InfoViewer
implements ActionListener {
    private SimClient simClient;
    private InfoViewer child;
    private JPanel mainPanel;
    private JLabel simLabel;
    private JLabel dayLabel;
    private int numberOfDays = 0;
    private JButton joinSimButton;
    private JButton exitButton;
    private Timer timer = new Timer(1000, this);
    private JLabel serverTimeLabel;
    private boolean isSimulationRunning = false;
    private int simulationID;
    private long simulationEndTime = 0L;
    private long nextSimulationStarts = 0L;

    public StatusInfo(SimClient simClient, InfoViewer infoViewer) {
        this.simClient = simClient;
        this.child = infoViewer;
    }

    public void init(String string) {
        this.child.init(string);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBackground(Color.white);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel.setBackground(Color.white);
        this.dayLabel = new JLabel("Day: 0 / 0");
        jPanel.add((Component)this.dayLabel, "East");
        this.serverTimeLabel = new JLabel();
        jPanel.add((Component)this.serverTimeLabel, "West");
        this.simLabel = new JLabel("Waiting for next simulation...");
        jPanel.add((Component)this.simLabel, "South");
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)this.child.getComponent(), "Center");
        JPanel jPanel2 = new JPanel();
        this.joinSimButton = new JButton("Join Simulation");
        jPanel2.add(this.joinSimButton);
        this.joinSimButton.addActionListener(this);
        this.exitButton = new JButton("Exit Agent");
        jPanel2.add(this.exitButton);
        this.exitButton.addActionListener(this);
        this.mainPanel.add((Component)jPanel2, "South");
        long l = this.simClient.getServerTime();
        this.updateTime(l);
        this.timer.setInitialDelay((int)(l / 1000L * 1000L + 1000L - l));
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void messageSent(String string, Transportable transportable) {
        this.child.messageSent(string, transportable);
    }

    public void messageReceived(String string, Transportable transportable) {
        if (transportable instanceof SimulationStatus) {
            SimulationStatus simulationStatus = (SimulationStatus)transportable;
            int n = simulationStatus.getCurrentDate();
            if (n < this.numberOfDays) {
                this.setButtons(null, "Day: " + n + " / " + (this.numberOfDays - 1), 0);
            }
        } else if (transportable instanceof ActiveOrders) {
            ActiveOrders activeOrders = (ActiveOrders)transportable;
            int n = activeOrders.getCurrentDate();
            if (n > 0 && n < this.numberOfDays) {
                this.setButtons(null, "Day: " + n + " / " + (this.numberOfDays - 1), 0);
            }
        } else if (transportable instanceof StartInfo) {
            this.startSimulation((StartInfo)transportable);
        } else if (transportable instanceof AdminContent) {
            long l;
            AdminContent adminContent = (AdminContent)transportable;
            int n = adminContent.getType();
            if (!(adminContent.isError() || n != 7 && n != 6 || (l = adminContent.getAttributeAsLong("startTime", 0L)) <= 0L || this.isSimulationRunning)) {
                int n2 = adminContent.getAttributeAsInt("simulation", -1);
                StringBuffer stringBuffer = new StringBuffer();
                if (l > this.simClient.getServerTime()) {
                    this.nextSimulationStarts = l;
                    stringBuffer.append("Next simulation");
                    if (n2 >= 0) {
                        stringBuffer.append(' ').append(n2);
                    }
                    stringBuffer.append(" starts at ");
                    this.appendTime(stringBuffer, this.nextSimulationStarts);
                } else {
                    stringBuffer.append("Simulation ");
                    if (n2 >= 0) {
                        stringBuffer.append(' ').append(n2);
                    }
                    stringBuffer.append(" already started");
                }
                this.setButtons(stringBuffer.toString(), null, 0);
            }
        }
        this.child.messageReceived(string, transportable);
    }

    private synchronized void startSimulation(StartInfo startInfo) {
        this.numberOfDays = startInfo.getNumberOfDays();
        this.simulationID = startInfo.getSimulationID();
        this.simulationEndTime = startInfo.getEndTime();
        this.isSimulationRunning = true;
        this.nextSimulationStarts = 0L;
        this.setButtons("Playing in simulation " + this.simulationID, "Day: 0 / " + (this.numberOfDays - 1), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSimulation() {
        boolean bl = this.isSimulationRunning;
        if (bl) {
            StatusInfo statusInfo = this;
            synchronized (statusInfo) {
                bl = this.isSimulationRunning;
                if (bl) {
                    String string;
                    if (this.nextSimulationStarts > this.simClient.getServerTime()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Next simulation starts at ");
                        this.appendTime(stringBuffer, this.nextSimulationStarts);
                        string = stringBuffer.toString();
                    } else {
                        string = "Simulation " + this.simulationID + " has finished";
                    }
                    this.setButtons(string, null, 1);
                    this.isSimulationRunning = false;
                }
            }
        }
    }

    private void setButtons(final String string, final String string2, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n != 0) {
                    StatusInfo.this.joinSimButton.setEnabled(n > 0);
                }
                if (string != null) {
                    StatusInfo.this.simLabel.setText(string);
                }
                if (string2 != null) {
                    StatusInfo.this.dayLabel.setText(string2);
                }
            }
        });
    }

    private void updateTime(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Server time: ");
        this.appendTime(stringBuffer, l);
        this.serverTimeLabel.setText(stringBuffer.toString());
        if (this.isSimulationRunning && l >= this.simulationEndTime) {
            this.joinSimButton.setEnabled(true);
        }
    }

    private StringBuffer appendTime(StringBuffer stringBuffer, long l) {
        long l2 = (l /= 1000L) % 60L;
        long l3 = l / 60L % 60L;
        long l4 = l / 3600L % 24L;
        if (l4 < 10L) {
            stringBuffer.append('0');
        }
        stringBuffer.append(l4).append(':');
        if (l3 < 10L) {
            stringBuffer.append('0');
        }
        stringBuffer.append(l3).append(':');
        if (l2 < 10L) {
            stringBuffer.append('0');
        }
        stringBuffer.append(l2);
        return stringBuffer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.timer) {
            long l = this.simClient.getServerTime();
            this.updateTime(l);
        } else if (object == this.joinSimButton) {
            this.simClient.requestJoinSimulation();
        } else if (object == this.exitButton) {
            this.simClient.requestQuit();
        }
    }
}

