/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class ActiveOrders
implements Transportable,
Serializable {
    private static final long serialVersionUID = -8093079538891379712L;
    private static final int ORDER_ID = 0;
    private static final int PRODUCT_ID = 1;
    private static final int QUANTITY = 2;
    private static final int UNIT_PRICE = 3;
    private static final int DUEDATE = 4;
    private static final int PENALTY = 5;
    private static final int PARTS = 6;
    private static final String[] names = new String[]{"id", "product", "quantity", "unitprice", "duedate", "penalty"};
    private int simDate;
    private int[] customerData = new int[60];
    private String[] customerAddress = new String[10];
    private int customerCount;
    private int[] supplierData = new int[60];
    private String[] supplierAddress = new String[10];
    private int supplierCount;
    private boolean isLocked = false;

    public ActiveOrders() {
    }

    public ActiveOrders(int n) {
        this();
        this.simDate = n;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    public int getCurrentDate() {
        return this.simDate;
    }

    public void addCustomerOrder(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        if (string == null) {
            throw new NullPointerException("customer");
        }
        int n7 = this.customerCount * 6;
        if (n7 == this.customerData.length) {
            this.customerData = ArrayUtils.setSize(this.customerData, n7 + 300);
            this.customerAddress = (String[])ArrayUtils.setSize(this.customerAddress, this.customerAddress.length + 50);
        }
        this.customerData[n7 + 0] = n;
        this.customerData[n7 + 1] = n2;
        this.customerData[n7 + 2] = n3;
        this.customerData[n7 + 3] = n4;
        this.customerData[n7 + 4] = n5;
        this.customerData[n7 + 5] = n6;
        this.customerAddress[this.customerCount] = string;
        ++this.customerCount;
    }

    public String getCustomerAddress(int n) {
        if (n < 0 || n >= this.customerCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.customerCount);
        }
        return this.customerAddress[n];
    }

    public int getCustomerOrderID(int n) {
        return this.getCustomer(n, 0);
    }

    public int getCustomerProductID(int n) {
        return this.getCustomer(n, 1);
    }

    public int getCustomerQuantity(int n) {
        return this.getCustomer(n, 2);
    }

    public int getCustomerUnitPrice(int n) {
        return this.getCustomer(n, 3);
    }

    public int getCustomerDueDate(int n) {
        return this.getCustomer(n, 4);
    }

    public int getCustomerPenalty(int n) {
        return this.getCustomer(n, 5);
    }

    public int getCustomerOrderCount() {
        return this.customerCount;
    }

    private int getCustomer(int n, int n2) {
        if (n < 0 || n >= this.customerCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.customerCount);
        }
        return this.customerData[n * 6 + n2];
    }

    public void addSupplierOrder(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        if (string == null) {
            throw new NullPointerException("supplier");
        }
        int n7 = this.supplierCount * 6;
        if (n7 == this.supplierData.length) {
            this.supplierData = ArrayUtils.setSize(this.supplierData, n7 + 300);
            this.supplierAddress = (String[])ArrayUtils.setSize(this.supplierAddress, this.supplierAddress.length + 50);
        }
        this.supplierData[n7 + 0] = n;
        this.supplierData[n7 + 1] = n2;
        this.supplierData[n7 + 2] = n3;
        this.supplierData[n7 + 3] = n4;
        this.supplierData[n7 + 4] = n5;
        this.supplierData[n7 + 5] = n6;
        this.supplierAddress[this.supplierCount] = string;
        ++this.supplierCount;
    }

    public String getSupplierAddress(int n) {
        if (n < 0 || n >= this.supplierCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.supplierCount);
        }
        return this.supplierAddress[n];
    }

    public int getSupplierOrderID(int n) {
        return this.getSupplier(n, 0);
    }

    public int getSupplierProductID(int n) {
        return this.getSupplier(n, 1);
    }

    public int getSupplierQuantity(int n) {
        return this.getSupplier(n, 2);
    }

    public int getSupplierUnitPrice(int n) {
        return this.getSupplier(n, 3);
    }

    public int getSupplierDueDate(int n) {
        return this.getSupplier(n, 4);
    }

    public int getSupplierPenalty(int n) {
        return this.getSupplier(n, 5);
    }

    public int getSupplierOrderCount() {
        return this.supplierCount;
    }

    private int getSupplier(int n, int n2) {
        if (n < 0 || n >= this.supplierCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.supplierCount);
        }
        return this.supplierData[n * 6 + n2];
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTransportName()).append("[[");
        int n2 = 0;
        int n3 = 0;
        int n4 = this.customerCount * 6;
        while (n2 < n4) {
            stringBuffer.append('[').append(this.customerAddress[n3]);
            for (n = 0; n < 6; ++n) {
                stringBuffer.append(',').append(this.customerData[n2 + n]);
            }
            stringBuffer.append(']');
            n2 += 6;
            ++n3;
        }
        stringBuffer.append("][");
        n2 = 0;
        n3 = 0;
        n4 = this.supplierCount * 6;
        while (n2 < n4) {
            stringBuffer.append('[').append(this.supplierAddress[n3]);
            for (n = 0; n < 6; ++n) {
                stringBuffer.append(',').append(this.supplierData[n2 + n]);
            }
            stringBuffer.append(']');
            n2 += 6;
            ++n3;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String getTransportName() {
        return "activeOrders";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        this.simDate = transportReader.getAttributeAsInt("date", 0);
        String string = null;
        String string2 = null;
        while (transportReader.nextNode(false)) {
            if (transportReader.isNode("customerOrder")) {
                string = string == null ? transportReader.getAttribute("customer") : transportReader.getAttribute("customer", string);
                this.addCustomerOrder(string, transportReader.getAttributeAsInt(names[0]), transportReader.getAttributeAsInt(names[1]), transportReader.getAttributeAsInt(names[2]), transportReader.getAttributeAsInt(names[3]), transportReader.getAttributeAsInt(names[4]), transportReader.getAttributeAsInt(names[5], 0));
                continue;
            }
            if (!transportReader.isNode("supplierOrder")) continue;
            string2 = string2 == null ? transportReader.getAttribute("supplier") : transportReader.getAttribute("supplier", string2);
            this.addSupplierOrder(string2, transportReader.getAttributeAsInt(names[0]), transportReader.getAttributeAsInt(names[1]), transportReader.getAttributeAsInt(names[2]), transportReader.getAttributeAsInt(names[3]), transportReader.getAttributeAsInt(names[4]), transportReader.getAttributeAsInt(names[5], 0));
        }
        if (bl) {
            this.lock();
        }
    }

    public void write(TransportWriter transportWriter) {
        int n;
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        if (this.simDate > 0) {
            transportWriter.attr("date", this.simDate);
        }
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.customerCount * 6;
        while (n2 < n4) {
            transportWriter.node("customerOrder");
            if (!this.customerAddress[n3].equals(string)) {
                string = this.customerAddress[n3];
                transportWriter.attr("customer", string);
            }
            for (n = 0; n < 6; ++n) {
                transportWriter.attr(names[n], this.customerData[n2 + n]);
            }
            transportWriter.endNode("customerOrder");
            n2 += 6;
            ++n3;
        }
        String string2 = null;
        n3 = 0;
        n4 = 0;
        n = this.supplierCount * 6;
        while (n3 < n) {
            transportWriter.node("supplierOrder");
            if (!this.supplierAddress[n4].equals(string2)) {
                string2 = this.supplierAddress[n4];
                transportWriter.attr("supplier", string2);
            }
            transportWriter.attr(names[0], this.supplierData[n3 + 0]).attr(names[1], this.supplierData[n3 + 1]).attr(names[2], this.supplierData[n3 + 2]).attr(names[3], this.supplierData[n3 + 3]).attr(names[4], this.supplierData[n3 + 4]);
            int n5 = this.supplierData[n3 + 5];
            if (n5 != 0) {
                transportWriter.attr(names[5], n5);
            }
            transportWriter.endNode("supplierOrder");
            n3 += 6;
            ++n4;
        }
    }
}

