/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import java.text.ParseException;
import se.sics.isl.transport.Context;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.tasim.props.SimpleContent;

public class AdminContent
extends SimpleContent {
    private static final long serialVersionUID = -6827270443299040674L;
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int PING = 2;
    public static final int PONG = 3;
    public static final int AUTH = 4;
    public static final int SERVER_TIME = 5;
    public static final int NEXT_SIMULATION = 6;
    public static final int JOIN_SIMULATION = 7;
    public static final int QUIT = 8;
    private static final String[] TYPE_NAMES = new String[]{"<none>", "error", "ping", "pong", "auth", "server time", "next simulation", "join simulation", "quit"};
    public static final int NO_ERROR = 0;
    public static final int NOT_SUPPORTED = 1;
    public static final int NOT_AUTH = 2;
    public static final int NO_SIMULATION_CREATED = 3;
    private static final String[] ERROR_NAMES = new String[]{"no error", "not supported", "not authenticated", "no simulation created"};
    private int type = 0;
    private int error = 0;
    private String errorReason = null;

    public static Context createContext() {
        Context context = new Context("admincontext");
        context.addTransportable(new AdminContent());
        return context;
    }

    public static String getTypeAsString(int n) {
        return n >= 0 && n < TYPE_NAMES.length ? TYPE_NAMES[n] : Integer.toString(n);
    }

    public static String getErrorAsString(int n) {
        return n >= 0 && n < ERROR_NAMES.length ? ERROR_NAMES[n] : Integer.toString(n);
    }

    public AdminContent() {
    }

    public AdminContent(int n) {
        this(n, 0, null);
    }

    public AdminContent(int n, int n2) {
        this(n, n2, null);
    }

    public AdminContent(int n, int n2, String string) {
        this.type = n;
        this.error = n2;
        this.errorReason = string;
    }

    public int getType() {
        return this.type;
    }

    public boolean isError() {
        return this.error != 0;
    }

    public int getError() {
        return this.error;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public void setError(int n) {
        this.setError(n, null);
    }

    public void setError(int n, String string) {
        if (this.isLocked()) {
            throw new IllegalStateException("locked");
        }
        this.error = n;
        this.errorReason = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[').append(AdminContent.getTypeAsString(this.type));
        if (this.isError()) {
            stringBuffer.append(',').append(AdminContent.getErrorAsString(this.error));
            if (this.errorReason != null) {
                stringBuffer.append(',').append(this.errorReason);
            }
        }
        stringBuffer.append(',');
        return this.params(stringBuffer).append(']').toString();
    }

    public String getTransportName() {
        return "adminContent";
    }

    public void read(TransportReader transportReader) throws ParseException {
        if (this.isLocked()) {
            throw new IllegalStateException("locked");
        }
        this.type = transportReader.getAttributeAsInt("type");
        this.error = transportReader.getAttributeAsInt("error", 0);
        if (this.error != 0) {
            this.errorReason = transportReader.getAttribute("reason", null);
        }
        super.read(transportReader);
    }

    public void write(TransportWriter transportWriter) {
        transportWriter.attr("type", this.type);
        if (this.error != 0) {
            transportWriter.attr("error", this.error);
            if (this.errorReason != null) {
                transportWriter.attr("reason", this.errorReason);
            }
        }
        super.write(transportWriter);
    }
}

