/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class BOMBundle
implements Transportable,
Serializable {
    private static final long serialVersionUID = 1765235852671812474L;
    private static final int PRODUCTION_ID = 0;
    private static final int CYCLES = 1;
    private static final int BASE_PRICE = 2;
    private static final int INDEX = 3;
    private static final int PARTS = 4;
    private int[] data;
    private String[] productNames;
    private int count;
    private int[] componentData;
    private int componentLength;
    private String[] segmentName;
    private int[][] segmentProducts;
    private int segmentCount;
    private boolean isLocked = false;

    public BOMBundle() {
        this(16);
    }

    public BOMBundle(int n) {
        this.data = new int[n * 4];
        this.productNames = new String[n];
        this.componentData = new int[n * 2];
    }

    public void addBOM(int n, int n2, int[] nArray) {
        this.addBOM(n, n2, nArray, null, null, 0);
    }

    public void addBOM(int n, int n2, int[] nArray, int[] nArray2) {
        this.addBOM(n, n2, nArray, nArray2, null, 0);
    }

    public synchronized void addBOM(int n, int n2, int[] nArray, int[] nArray2, String string, int n3) {
        int n4;
        int n5;
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n6 = this.count * 4;
        if (n6 == this.data.length) {
            this.data = ArrayUtils.setSize(this.data, n6 + 200);
            this.productNames = (String[])ArrayUtils.setSize(this.productNames, this.count + 50);
        }
        this.data[n6 + 0] = n;
        this.data[n6 + 1] = n2;
        this.data[n6 + 2] = n3;
        this.data[n6 + 3] = this.componentLength;
        int n7 = nArray != null ? nArray.length : 0;
        int n8 = n5 = nArray2 != null ? nArray2.length : 0;
        if (this.componentLength + n7 + n5 + 2 >= this.componentData.length) {
            this.componentData = ArrayUtils.setSize(this.componentData, this.componentLength + n7 + n5 + 2 + 20);
        }
        n6 = this.componentLength;
        this.componentData[n6++] = n7;
        for (n4 = 0; n4 < n7; ++n4) {
            this.componentData[n6++] = nArray[n4];
        }
        this.componentData[n6++] = n5;
        for (n4 = 0; n4 < n5; ++n4) {
            this.componentData[n6++] = nArray2[n4];
        }
        this.productNames[this.count] = string;
        this.componentLength = n6;
        ++this.count;
    }

    public int getIndexFor(int n) {
        int n2 = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[n2 + 0] == n) {
                return i;
            }
            n2 += 4;
        }
        return -1;
    }

    public int getProductID(int n) {
        return this.get(n, 0);
    }

    public int getAssemblyCyclesRequired(int n) {
        return this.get(n, 1);
    }

    public int getProductBasePrice(int n) {
        return this.get(n, 2);
    }

    public String getProductName(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        String string = this.productNames[n];
        if (string == null) {
            int[] nArray = this.getComponents(n);
            if (nArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("PC ").append(n + 1).append(" [");
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(nArray[i]);
                }
                string = stringBuffer.append(']').toString();
            } else {
                string = "PC " + (n + 1);
            }
            this.productNames[n] = string;
        }
        return string;
    }

    public synchronized void setProductName(int n, String string) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        this.productNames[n] = string;
    }

    public int[] getComponentsForProductID(int n) {
        int n2 = this.getIndexFor(n);
        return n2 >= 0 ? this.getComponents(n2) : null;
    }

    public int[] getComponents(int n) {
        int n2 = this.getComponentIndex(n);
        int n3 = this.componentData[n2];
        if (n3 > 0) {
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = this.componentData[n2 + i + 1];
            }
            return nArray;
        }
        return null;
    }

    public int[] getSubstitutesForProductID(int n) {
        int n2 = this.getIndexFor(n);
        return n2 >= 0 ? this.getSubstitutes(n2) : null;
    }

    public int[] getSubstitutes(int n) {
        int n2;
        int n3 = this.getComponentIndex(n);
        n3 += this.componentData[n3] + 1;
        if ((n2 = this.componentData[n3++]) > 0) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.componentData[n3 + i];
            }
            return nArray;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    private int getComponentIndex(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 4 + 3];
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 4 + n2];
    }

    public synchronized void addSegment(String string, int[] nArray) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        if (this.segmentName == null) {
            this.segmentName = new String[3];
            this.segmentProducts = new int[3][];
        } else if (this.segmentCount == this.segmentName.length) {
            this.segmentName = (String[])ArrayUtils.setSize(this.segmentName, this.segmentCount + 5);
            this.segmentProducts = (int[][])ArrayUtils.setSize((Object[])this.segmentProducts, this.segmentCount + 5);
        }
        this.segmentName[this.segmentCount] = string;
        this.segmentProducts[this.segmentCount] = nArray == null ? new int[]{} : (int[])nArray.clone();
        ++this.segmentCount;
    }

    public String getSegmentName(int n) {
        if (n < 0 || n >= this.segmentCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.segmentCount);
        }
        return this.segmentName[n];
    }

    public int[] getSegmentProducts(int n) {
        if (n < 0 || n >= this.segmentCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.segmentCount);
        }
        return (int[])this.segmentProducts[n].clone();
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        BOMBundle bOMBundle = (BOMBundle)object;
        if (this.count != bOMBundle.count || this.componentLength != bOMBundle.componentLength || this.segmentCount != bOMBundle.segmentCount || this.isLocked != bOMBundle.isLocked) {
            return false;
        }
        if (this.segmentCount > 0) {
            int n = this.segmentCount;
            for (int i = 0; i < n; ++i) {
                int[] nArray = this.segmentProducts[i];
                int[] nArray2 = bOMBundle.segmentProducts[i];
                if (this.segmentName[i].equals(bOMBundle.segmentName[i]) && (nArray == nArray2 || this.equals(nArray, nArray2, nArray.length))) continue;
                return false;
            }
        }
        return this.equals(this.data, bOMBundle.data, this.count) && this.equals(this.componentData, bOMBundle.componentData, this.componentLength);
    }

    private boolean equals(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTransportName()).append('[');
        int n2 = this.size();
        for (n = 0; n < n2; ++n) {
            int[] nArray;
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.getProductName(n)).append('(').append(this.getProductID(n)).append(")={");
            int[] nArray2 = this.getComponents(n);
            if (nArray2 != null) {
                this.toString(stringBuffer, nArray2);
            }
            if ((nArray = this.getSubstitutes(n)) != null) {
                stringBuffer.append('|');
                this.toString(stringBuffer, nArray);
            }
            stringBuffer.append('}');
        }
        stringBuffer.append(']');
        if (this.segmentCount > 0) {
            stringBuffer.append('[');
            n2 = this.segmentCount;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.segmentName[n]).append("=[");
                this.toString(stringBuffer, this.segmentProducts[n]);
                stringBuffer.append(']');
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
    }

    public String getTransportName() {
        return "bomBundle";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl;
        boolean bl2 = bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        while (transportReader.nextNode(false)) {
            if (transportReader.isNode("product")) {
                int n = transportReader.getAttributeAsInt("id");
                int n2 = transportReader.getAttributeAsInt("cycles");
                int n3 = transportReader.getAttributeAsInt("basePrice", 0);
                String string = transportReader.getAttribute("name", null);
                transportReader.enterNode();
                int[] nArray = this.readSubs(transportReader, "component", "id");
                int[] nArray2 = this.readSubs(transportReader, "substitute", "id");
                this.addBOM(n, n2, nArray, nArray2, string, n3);
                transportReader.exitNode();
                continue;
            }
            if (!transportReader.isNode("segment")) continue;
            String string = transportReader.getAttribute("name");
            transportReader.enterNode();
            int[] nArray = this.readSubs(transportReader, "product", "id");
            this.addSegment(string, nArray);
            transportReader.exitNode();
        }
        if (bl) {
            this.lock();
        }
    }

    private int[] readSubs(TransportReader transportReader, String string, String string2) throws ParseException {
        if (!transportReader.hasMoreNodes()) {
            return null;
        }
        int[] nArray = new int[10];
        int n = 0;
        while (transportReader.nextNode(string, false)) {
            if (n == nArray.length) {
                nArray = ArrayUtils.setSize(nArray, n + 10);
            }
            nArray[n++] = transportReader.getAttributeAsInt(string2);
        }
        if (n < nArray.length) {
            if (n == 0) {
                return null;
            }
            nArray = ArrayUtils.setSize(nArray, n);
        }
        return nArray;
    }

    public void write(TransportWriter transportWriter) {
        int n;
        int n2;
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.count) {
            int n5;
            n2 = this.data[n4 + 3];
            n = this.componentData[n2++];
            int n6 = n2 + n;
            int n7 = this.componentData[n6++];
            int n8 = this.data[n4 + 2];
            String string = this.productNames[n3];
            transportWriter.node("product").attr("id", this.data[n4 + 0]).attr("cycles", this.data[n4 + 1]);
            if (n8 != 0) {
                transportWriter.attr("basePrice", n8);
            }
            if (string != null) {
                transportWriter.attr("name", string);
            }
            int n9 = n2 + n;
            for (n5 = n2; n5 < n9; ++n5) {
                transportWriter.node("component").attr("id", this.componentData[n5]).endNode("component");
            }
            n9 = n6 + n7;
            for (n5 = n6; n5 < n9; ++n5) {
                transportWriter.node("substitute").attr("id", this.componentData[n5]).endNode("substitute");
            }
            transportWriter.endNode("product");
            ++n3;
            n4 += 4;
        }
        n4 = this.segmentCount;
        for (n3 = 0; n3 < n4; ++n3) {
            transportWriter.node("segment").attr("name", this.segmentName[n3]);
            n = this.segmentProducts[n3].length;
            for (n2 = 0; n2 < n; ++n2) {
                transportWriter.node("product").attr("id", this.segmentProducts[n3][n2]).endNode("product");
            }
            transportWriter.endNode("segment");
        }
    }
}

