/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class BankStatus
implements Transportable,
Serializable {
    private static final long serialVersionUID = -9089664535771907257L;
    private static final int ORDER_ID = 0;
    private static final int AMOUNT = 1;
    private static final int PARTS = 2;
    private int[] penalties;
    private String[] penaltyReceivers;
    private int penaltyCount;
    private int[] deniedDeliveries;
    private String[] deniers;
    private int deniedCount;
    private long account = 0L;
    private long totalPenalty;

    public long getAccountStatus() {
        return this.account;
    }

    public void setAccountStatus(long l) {
        this.account = l;
    }

    public void addPenalty(String string, int n, int n2) {
        int n3;
        if (this.penaltyReceivers == null) {
            this.penaltyReceivers = new String[10];
            this.penalties = new int[20];
        } else if (this.penaltyCount == this.penaltyReceivers.length) {
            n3 = this.penaltyCount + 50;
            this.penaltyReceivers = (String[])ArrayUtils.setSize(this.penaltyReceivers, n3);
            this.penalties = ArrayUtils.setSize(this.penalties, n3 * 2);
        }
        n3 = this.penaltyCount * 2;
        this.penalties[n3 + 0] = n;
        this.penalties[n3 + 1] = n2;
        this.penaltyReceivers[this.penaltyCount++] = string;
        this.totalPenalty += (long)n2;
    }

    public int getPenaltyCount() {
        return this.penaltyCount;
    }

    public String getPenaltyReceiver(int n) {
        if (n < 0 || n >= this.penaltyCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.penaltyCount);
        }
        return this.penaltyReceivers[n];
    }

    public int getPenaltyOrderID(int n) {
        return this.get(n, 0);
    }

    public int getPenaltyAmount(int n) {
        return this.get(n, 1);
    }

    public long getTotalPenaltyAmount() {
        return this.totalPenalty;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.penaltyCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.penaltyCount);
        }
        return this.penalties[n * 2 + n2];
    }

    public void addDeniedDelivery(String string, int n) {
        if (this.deniedDeliveries == null) {
            this.deniedDeliveries = new int[10];
            this.deniers = new String[10];
        } else if (this.deniedCount == this.deniedDeliveries.length) {
            this.deniedDeliveries = ArrayUtils.setSize(this.deniedDeliveries, this.deniedCount + 10);
            this.deniers = (String[])ArrayUtils.setSize(this.deniers, this.deniedCount + 10);
        }
        this.deniers[this.deniedCount] = string;
        this.deniedDeliveries[this.deniedCount++] = n;
    }

    public int getDeniedCount() {
        return this.deniedCount;
    }

    public int getDeniedOrderID(int n) {
        if (n < 0 || n >= this.deniedCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.deniedCount);
        }
        return this.deniedDeliveries[n];
    }

    public String getDenier(int n) {
        if (n < 0 || n >= this.deniedCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.deniedCount);
        }
        return this.deniers[n];
    }

    public void clear() {
        this.penaltyCount = 0;
        this.account = 0L;
        this.totalPenalty = 0L;
        int n = this.deniedCount;
        this.deniedCount = 0;
        while (--n >= 0) {
            this.deniers[n] = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTransportName()).append('[').append(this.account).append(',').append(this.penaltyCount).append(',').append(this.deniedCount).append(']');
        return stringBuffer.toString();
    }

    public String getTransportName() {
        return "bankStatus";
    }

    public void read(TransportReader transportReader) throws ParseException {
        String string = null;
        String string2 = null;
        this.account = transportReader.getAttributeAsLong("account", 0L);
        while (transportReader.nextNode(false)) {
            if (transportReader.isNode("penalty")) {
                string = string == null ? transportReader.getAttribute("receiver") : transportReader.getAttribute("receiver", string);
                this.addPenalty(string, transportReader.getAttributeAsInt("orderID"), transportReader.getAttributeAsInt("amount"));
                continue;
            }
            if (!transportReader.isNode("deniedDelivery")) continue;
            string2 = string2 == null ? transportReader.getAttribute("denier") : transportReader.getAttribute("denier", string2);
            this.addDeniedDelivery(string2, transportReader.getAttributeAsInt("orderID"));
        }
    }

    public void write(TransportWriter transportWriter) {
        if (this.account != 0L) {
            transportWriter.attr("account", this.account);
        }
        String string = null;
        int n = 0;
        int n2 = 0;
        while (n < this.penaltyCount) {
            transportWriter.node("penalty");
            if (!this.penaltyReceivers[n].equals(string)) {
                string = this.penaltyReceivers[n];
                transportWriter.attr("receiver", string);
            }
            transportWriter.attr("orderID", this.penalties[n2 + 0]).attr("amount", this.penalties[n2 + 1]).endNode("penalty");
            ++n;
            n2 += 2;
        }
        String string2 = null;
        for (n2 = 0; n2 < this.deniedCount; ++n2) {
            transportWriter.node("deniedDelivery");
            if (!this.deniers[n2].equals(string2)) {
                string2 = this.deniers[n2];
                transportWriter.attr("denier", string2);
            }
            transportWriter.attr("orderID", this.deniedDeliveries[n2]).endNode("deniedDelivery");
        }
    }
}

