/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class ComponentCatalog
implements Transportable,
Serializable {
    private static final long serialVersionUID = -8955489326061882427L;
    private static final int PRODUCT_ID = 0;
    private static final int BASE_PRICE = 1;
    private static final int PARTS = 2;
    private boolean isLocked = false;
    private int[] data;
    private String[] productNames;
    private String[][] suppliers;
    private int count;
    private String[] supplierList;
    private int supplierCount;

    public ComponentCatalog() {
        this(10);
    }

    public ComponentCatalog(int n) {
        this.data = new int[n * 2];
        this.productNames = new String[n];
        this.suppliers = new String[n][];
        this.supplierList = new String[10];
    }

    public synchronized void addSupplier(String string, int[] nArray) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        if (nArray != null) {
            int n = ArrayUtils.indexOf(this.supplierList, 0, this.supplierCount, string);
            if (n < 0) {
                if (this.supplierCount == this.supplierList.length) {
                    this.supplierList = (String[])ArrayUtils.setSize(this.supplierList, this.supplierCount + 10);
                }
                this.supplierList[this.supplierCount++] = string;
            } else {
                string = this.supplierList[n];
            }
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.getIndexFor(nArray[i]);
                if (n3 < 0) {
                    this.ensureCapacity(this.count);
                    this.data[this.count * 2] = nArray[i];
                    this.productNames[this.count] = Integer.toString(nArray[i]);
                    n3 = this.count++;
                }
                this.suppliers[n3] = (String[])ArrayUtils.add(String.class, this.suppliers[n3], string);
            }
        }
    }

    private void ensureCapacity(int n) {
        if (this.productNames.length <= n) {
            int n2 = n + 10;
            this.data = ArrayUtils.setSize(this.data, n2 * 2);
            this.productNames = (String[])ArrayUtils.setSize(this.productNames, n2);
            this.suppliers = (String[][])ArrayUtils.setSize((Object[])this.suppliers, n2);
        }
    }

    public int getIndexFor(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.count * 2;
        while (n2 < n4) {
            if (this.data[n2 + 0] == n) {
                return n3;
            }
            n2 += 2;
            ++n3;
        }
        return -1;
    }

    public int getProductID(int n) {
        return this.get(n, 0);
    }

    public int getProductBasePrice(int n) {
        return this.get(n, 1);
    }

    public void setProductBasePrice(int n, int n2) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        this.data[n * 2 + 1] = n2;
    }

    public String getProductName(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.productNames[n];
    }

    public synchronized void setProductName(int n, String string) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        this.productNames[n] = string;
    }

    public String[] getSuppliers(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.suppliers[n];
    }

    public String[] getSuppliersForProduct(int n) {
        int n2 = this.getIndexFor(n);
        if (n2 >= 0) {
            return this.suppliers[n2];
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 2 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[');
        int n = 0;
        int n2 = 0;
        while (n < this.count) {
            String[] stringArray = this.suppliers[n];
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('[').append(this.data[n2 + 0]).append('=').append(this.productNames[n]).append(',').append(this.data[n2 + 1]);
            if (stringArray != null) {
                int n3 = stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    stringBuffer.append(',').append(stringArray[i]);
                }
            }
            stringBuffer.append(']');
            ++n;
            n2 += 2;
        }
        return stringBuffer.append(']').toString();
    }

    public String getTransportName() {
        return "componentCatalog";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl;
        boolean bl2 = bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        while (transportReader.nextNode("supplier", false)) {
            String string = transportReader.getAttribute("address");
            transportReader.enterNode();
            int[] nArray = this.readSubs(transportReader, "product", "id");
            this.addSupplier(string, nArray);
            transportReader.exitNode();
        }
        while (transportReader.nextNode("product", false)) {
            int n = transportReader.getAttributeAsInt("id");
            int n2 = this.getIndexFor(n);
            if (n2 < 0) continue;
            String string = transportReader.getAttribute("name");
            int n3 = transportReader.getAttributeAsInt("basePrice", 0);
            this.setProductName(n2, string);
            if (n3 == 0) continue;
            this.setProductBasePrice(n2, n3);
        }
        if (bl) {
            this.lock();
        }
    }

    private int[] readSubs(TransportReader transportReader, String string, String string2) throws ParseException {
        if (!transportReader.hasMoreNodes()) {
            return null;
        }
        int[] nArray = new int[10];
        int n = 0;
        while (transportReader.nextNode(string, false)) {
            if (n == nArray.length) {
                nArray = ArrayUtils.setSize(nArray, n + 10);
            }
            nArray[n++] = transportReader.getAttributeAsInt(string2);
        }
        if (n < nArray.length) {
            if (n == 0) {
                return null;
            }
            nArray = ArrayUtils.setSize(nArray, n);
        }
        return nArray;
    }

    public void write(TransportWriter transportWriter) {
        int n;
        int n2;
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        for (n2 = 0; n2 < this.supplierCount; ++n2) {
            String string = this.supplierList[n2];
            transportWriter.node("supplier").attr("address", string);
            int n3 = 0;
            n = 0;
            while (n3 < this.count) {
                String[] stringArray = this.suppliers[n3];
                if (stringArray != null) {
                    int n4 = stringArray.length;
                    for (int i = 0; i < n4; ++i) {
                        if (string != stringArray[i]) continue;
                        transportWriter.node("product").attr("id", this.data[n + 0]).endNode("product");
                        break;
                    }
                }
                ++n3;
                n += 2;
            }
            transportWriter.endNode("supplier");
        }
        n2 = 0;
        int n5 = 0;
        while (n2 < this.count) {
            String string = this.productNames[n2];
            if (string != null) {
                n = this.data[n5 + 1];
                transportWriter.node("product").attr("id", this.data[n5 + 0]).attr("name", string);
                if (n != 0) {
                    transportWriter.attr("basePrice", n);
                }
                transportWriter.endNode("product");
            }
            ++n2;
            n5 += 2;
        }
    }
}

