/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class DeliveryNotice
implements Transportable,
Serializable {
    private static final long serialVersionUID = 599522166454448370L;
    private static final int ORDER_ID = 0;
    private static final int PRODUCT_ID = 1;
    private static final int QUANTITY = 2;
    private static final int PARTS = 3;
    private String customer;
    private String supplier;
    private int[] data;
    private int count;
    private boolean isLocked = false;
    private long totalQuantity = 0L;

    public DeliveryNotice(String string, String string2) {
        this(string, string2, 5);
    }

    public DeliveryNotice(String string, String string2, int n) {
        if (string == null) {
            throw new NullPointerException("supplier");
        }
        if (string2 == null) {
            throw new NullPointerException("customer");
        }
        this.customer = string2;
        this.supplier = string;
        this.data = new int[n * 3];
    }

    public DeliveryNotice() {
        this.data = new int[15];
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public synchronized void addDelivery(int n, int n2, int n3) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n4 = this.count * 3;
        if (n4 == this.data.length) {
            this.data = ArrayUtils.setSize(this.data, n4 + 150);
        }
        this.data[n4 + 0] = n;
        this.data[n4 + 1] = n2;
        this.data[n4 + 2] = n3;
        ++this.count;
        this.totalQuantity += (long)n3;
    }

    public int getOrderID(int n) {
        return this.get(n, 0);
    }

    public int getProductID(int n) {
        return this.get(n, 1);
    }

    public int getQuantity(int n) {
        return this.get(n, 2);
    }

    public int getTotalQuantity() {
        return Integer.MAX_VALUE <= this.totalQuantity ? Integer.MAX_VALUE : (int)this.totalQuantity;
    }

    public int size() {
        return this.count;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 3 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[').append(this.supplier).append(',').append(this.customer);
        for (int i = 0; i < this.count; ++i) {
            int n = i * 3;
            stringBuffer.append(',').append('[').append(this.data[n + 0]).append(',').append(this.data[n + 1]).append(',').append(this.data[n + 2]).append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getTransportName() {
        return "deliveryNotice";
    }

    public void read(TransportReader transportReader) throws ParseException {
        if (this.customer != null) {
            throw new IllegalStateException("already initialized");
        }
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        boolean bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        this.customer = transportReader.getAttribute("customer");
        this.supplier = transportReader.getAttribute("supplier");
        while (transportReader.nextNode("delivery", false)) {
            int n = transportReader.getAttributeAsInt("order");
            int n2 = transportReader.getAttributeAsInt("product");
            int n3 = transportReader.getAttributeAsInt("quantity");
            this.addDelivery(n, n2, n3);
        }
        this.isLocked = bl;
    }

    public void write(TransportWriter transportWriter) {
        transportWriter.attr("customer", this.customer).attr("supplier", this.supplier);
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        int n = 0;
        int n2 = 0;
        while (n < this.count) {
            transportWriter.node("delivery").attr("order", this.data[n2 + 0]).attr("product", this.data[n2 + 1]).attr("quantity", this.data[n2 + 2]).endNode("delivery");
            ++n;
            n2 += 3;
        }
    }
}

