/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class DeliverySchedule
implements Transportable,
Serializable {
    private static final long serialVersionUID = -1890418217734990962L;
    private static final int PRODUCT_ID = 0;
    private static final int ORDER_ID = 1;
    private static final int QUANTITY = 2;
    private static final int PARTS = 3;
    private int[] data;
    private String[] deliveryReceiver;
    private int count = 0;
    private long totalQuantity = 0L;

    public DeliverySchedule() {
        this(5);
    }

    public DeliverySchedule(int n) {
        this.data = new int[n * 3];
        this.deliveryReceiver = new String[n];
    }

    public synchronized void addDelivery(int n, int n2, int n3, String string) {
        int n4 = this.count * 3;
        if (n4 == this.data.length) {
            this.data = ArrayUtils.setSize(this.data, n4 + 60);
            this.deliveryReceiver = (String[])ArrayUtils.setSize(this.deliveryReceiver, this.count + 20);
        }
        this.data[n4 + 0] = n;
        this.data[n4 + 1] = n3;
        this.data[n4 + 2] = n2;
        this.deliveryReceiver[this.count] = string;
        ++this.count;
        this.totalQuantity += (long)n2;
    }

    public int getOrderID(int n) {
        return this.get(n, 1);
    }

    public String getCustomer(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.deliveryReceiver[n];
    }

    public int getProductID(int n) {
        return this.get(n, 0);
    }

    public int getQuantity(int n) {
        return this.get(n, 2);
    }

    public int getTotalQuantity() {
        return Integer.MAX_VALUE <= this.totalQuantity ? Integer.MAX_VALUE : (int)this.totalQuantity;
    }

    public int size() {
        return this.count;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 3 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[').append(this.data[i * 3]);
            for (int j = 1; j < 3; ++j) {
                stringBuffer.append(',').append(this.data[i * 3 + j]);
            }
            stringBuffer.append(',').append(this.deliveryReceiver[i]).append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getTransportName() {
        return "deliverySchedule";
    }

    public void read(TransportReader transportReader) throws ParseException {
        while (transportReader.nextNode("delivery", false)) {
            int n = transportReader.getAttributeAsInt("order");
            int n2 = transportReader.getAttributeAsInt("product");
            int n3 = transportReader.getAttributeAsInt("quantity");
            String string = transportReader.getAttribute("customer");
            this.addDelivery(n2, n3, n, string);
        }
    }

    public void write(TransportWriter transportWriter) {
        int n = 0;
        int n2 = 0;
        while (n < this.count) {
            transportWriter.node("delivery").attr("order", this.data[n2 + 1]).attr("product", this.data[n2 + 0]).attr("quantity", this.data[n2 + 2]).attr("customer", this.deliveryReceiver[n]).endNode("delivery");
            ++n;
            n2 += 3;
        }
    }
}

