/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class InventoryStatus
implements Transportable,
Serializable {
    private static final long serialVersionUID = 1075202107462872293L;
    private static final int PRODUCT_ID = 0;
    private static final int QUANTITY = 1;
    private static final int PARTS = 2;
    private int[] inventory;
    private int count;
    private boolean isLocked = false;

    public InventoryStatus() {
    }

    public InventoryStatus(InventoryStatus inventoryStatus) {
        if (inventoryStatus != null && inventoryStatus.count > 0) {
            this.count = inventoryStatus.count;
            int n = this.count * 2;
            this.inventory = new int[n];
            System.arraycopy(inventoryStatus.inventory, 0, this.inventory, 0, n);
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    public int getProductCount() {
        return this.count;
    }

    public int getProductID(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.inventory[n * 2 + 0];
    }

    public int getQuantity(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.inventory[n * 2 + 1];
    }

    public int getInventoryQuantity(int n) {
        int n2 = ArrayUtils.keyValuesIndexOf(this.inventory, 2, 0, this.count * 2, n);
        if (n2 >= 0) {
            return this.inventory[n2 - 0 + 1];
        }
        return 0;
    }

    public void addInventory(int n, int n2) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n3 = ArrayUtils.keyValuesIndexOf(this.inventory, 2, 0, this.count * 2, n);
        if (n3 >= 0) {
            int n4 = n3 - 0 + 1;
            this.inventory[n4] = this.inventory[n4] + n2;
        } else {
            n3 = this.count * 2;
            if (this.inventory == null) {
                this.inventory = new int[10];
            } else if (n3 == this.inventory.length) {
                this.inventory = ArrayUtils.setSize(this.inventory, n3 + 10);
            }
            this.inventory[n3 + 0] = n;
            this.inventory[n3 + 1] = n2;
            ++this.count;
        }
    }

    public void removeInventory(int n, int n2) {
        this.addInventory(n, -n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[');
        int n = this.getProductCount() * 2;
        for (int i = 0; i < n; i += 2) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.inventory[i + 0]).append('=').append(this.inventory[i + 1]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String getTransportName() {
        return "inventoryStatus";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl;
        boolean bl2 = bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        while (transportReader.nextNode("inventory", false)) {
            int n = transportReader.getAttributeAsInt("product");
            int n2 = transportReader.getAttributeAsInt("quantity");
            this.addInventory(n, n2);
        }
        if (bl) {
            this.lock();
        }
    }

    public void write(TransportWriter transportWriter) {
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        int n = this.count * 2;
        for (int i = 0; i < n; i += 2) {
            int n2 = this.inventory[i + 1];
            if (n2 == 0) continue;
            transportWriter.node("inventory").attr("product", this.inventory[i + 0]).attr("quantity", this.inventory[i + 1]).endNode("inventory");
        }
    }
}

