/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class MarketReport
implements Transportable,
Serializable {
    private static final long serialVersionUID = 5878853164404337169L;
    private static final int SUPPLY_PRODUCT_ID = 0;
    private static final int SUPPLY_ORDERED = 1;
    private static final int SUPPLY_PRODUCED = 2;
    private static final int SUPPLY_DELIVERED = 3;
    private static final int SUPPLY_PARTS = 4;
    private static final String[] supplyNames = new String[]{"product", "ordered", "produced", "delivered"};
    private static final int DEMAND_PRODUCT_ID = 0;
    private static final int DEMAND_REQUESTED = 1;
    private static final int DEMAND_ORDERED = 2;
    private static final int DEMAND_PARTS = 3;
    private static final String[] demandNames = new String[]{"product", "requested", "ordered"};
    private SupplierData[] supplierData;
    private int supplierCount;
    private int startDate;
    private int endDate;
    private int[] supplyData;
    private long[] supplyPrice;
    private int supplyCount;
    private int[] demandData;
    private long[] demandPrice;
    private int demandCount;
    private boolean isLocked = false;

    public MarketReport() {
        this(0, 0, 10, 16);
    }

    public MarketReport(int n, int n2) {
        this(n, n2, 10, 16);
    }

    public MarketReport(int n, int n2, int n3, int n4) {
        this.startDate = n;
        this.endDate = n2;
        this.supplyData = new int[n3 * 4];
        this.supplyPrice = new long[n3];
        this.demandData = new int[n4 * 3];
        this.demandPrice = new long[n4];
        this.supplierData = new SupplierData[16];
    }

    public int getStartDate() {
        return this.startDate;
    }

    public int getEndDate() {
        return this.endDate;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    public void addSupplierCapacity(String string, int n, int n2) {
        SupplierData supplierData;
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n3 = this.getSupplierIndexFor(string, n);
        if (n3 < 0) {
            if (this.supplierCount == this.supplierData.length) {
                this.supplierData = (SupplierData[])ArrayUtils.setSize(this.supplierData, this.supplierCount + 5);
            }
            supplierData = new SupplierData(string, n);
            this.supplierData[this.supplierCount++] = supplierData;
        } else {
            supplierData = this.supplierData[n3];
        }
        supplierData.addCapacity(n2);
    }

    public String getSupplierAddress(int n) {
        SupplierData supplierData = this.getSupplierData(n);
        return supplierData.supplier;
    }

    public int getSupplierProductID(int n) {
        SupplierData supplierData = this.getSupplierData(n);
        return supplierData.productID;
    }

    public int getAverageSupplierCapacity(int n) {
        SupplierData supplierData = this.getSupplierData(n);
        return supplierData.getAverageCapacity();
    }

    public int getSupplierIndexFor(String string, int n) {
        for (int i = 0; i < this.supplierCount; ++i) {
            if (this.supplierData[i].productID != n || !this.supplierData[i].supplier.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getSupplierCount() {
        return this.supplierCount;
    }

    private SupplierData getSupplierData(int n) {
        if (n < 0 || n >= this.supplierCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.supplierCount);
        }
        return this.supplierData[n];
    }

    public void addSupplyProduced(int n, int n2) {
        int n3 = this.addSupply(n) * 4;
        int n4 = n3 + 2;
        this.supplyData[n4] = this.supplyData[n4] + n2;
    }

    public void addSupplyOrdered(int n, int n2, int n3) {
        int n4 = this.addSupply(n);
        int n5 = n4 * 4;
        int n6 = n5 + 1;
        this.supplyData[n6] = this.supplyData[n6] + n2;
        int n7 = n4;
        this.supplyPrice[n7] = this.supplyPrice[n7] + (long)(n2 * n3);
    }

    public void addSupplyDelivered(int n, int n2) {
        int n3 = this.addSupply(n) * 4;
        int n4 = n3 + 3;
        this.supplyData[n4] = this.supplyData[n4] + n2;
    }

    public void addSupplyForProduct(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.addSupply(n);
        int n7 = n6 * 4;
        int n8 = n7 + 1;
        this.supplyData[n8] = this.supplyData[n8] + n2;
        int n9 = n7 + 2;
        this.supplyData[n9] = this.supplyData[n9] + n3;
        int n10 = n7 + 3;
        this.supplyData[n10] = this.supplyData[n10] + n4;
        int n11 = n6;
        this.supplyPrice[n11] = this.supplyPrice[n11] + (long)(n2 * n5);
    }

    private int addSupply(int n) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n2 = this.getSupplyIndexFor(n);
        if (n2 < 0) {
            n2 = this.supplyCount;
            int n3 = this.supplyCount * 4;
            if (n3 == this.supplyData.length) {
                this.supplyData = ArrayUtils.setSize(this.supplyData, n3 + 40);
                this.supplyPrice = ArrayUtils.setSize(this.supplyPrice, n2 + 10);
            }
            this.supplyData[n3 + 0] = n;
            ++this.supplyCount;
        }
        return n2;
    }

    public int getSupplyProductID(int n) {
        return this.getSupply(n, 0);
    }

    public int getSupplyOrdered(int n) {
        return this.getSupply(n, 1);
    }

    public int getSupplyProduced(int n) {
        return this.getSupply(n, 2);
    }

    public int getSupplyDelivered(int n) {
        return this.getSupply(n, 3);
    }

    public int getAverageSupplyPrice(int n) {
        int n2 = this.getSupplyOrdered(n);
        return n2 > 0 ? (int)(this.supplyPrice[n] / (long)n2) : 0;
    }

    public int getSupplyIndexFor(int n) {
        int n2 = 0;
        for (int i = 0; i < this.supplyCount; ++i) {
            if (this.supplyData[n2 + 0] == n) {
                return i;
            }
            n2 += 4;
        }
        return -1;
    }

    public int getSupplyCount() {
        return this.supplyCount;
    }

    private int getSupply(int n, int n2) {
        if (n < 0 || n >= this.supplyCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.supplyCount);
        }
        return this.supplyData[n * 4 + n2];
    }

    public void addDemandForProduct(int n, int n2, int n3) {
        this.addDemandForProduct(n, 0, n2, n3);
    }

    public void addDemandForProduct(int n, int n2, int n3, int n4) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n5 = this.getDemandIndexFor(n);
        int n6 = n5 * 3;
        if (n5 < 0) {
            n5 = this.demandCount;
            n6 = n5 * 3;
            if (n6 == this.demandData.length) {
                this.demandData = ArrayUtils.setSize(this.demandData, n6 + 30);
                this.demandPrice = ArrayUtils.setSize(this.demandPrice, n5 + 10);
            }
            this.demandData[n6 + 0] = n;
            ++this.demandCount;
        }
        int n7 = n6 + 1;
        this.demandData[n7] = this.demandData[n7] + n2;
        int n8 = n6 + 2;
        this.demandData[n8] = this.demandData[n8] + n3;
        int n9 = n5;
        this.demandPrice[n9] = this.demandPrice[n9] + (long)(n3 * n4);
    }

    public int getDemandProductID(int n) {
        return this.getDemand(n, 0);
    }

    public int getProductsRequested(int n) {
        return this.getDemand(n, 1);
    }

    public int getProductsOrdered(int n) {
        return this.getDemand(n, 2);
    }

    public int getAverageProductPrice(int n) {
        int n2 = this.getProductsOrdered(n);
        return n2 > 0 ? (int)(this.demandPrice[n] / (long)n2) : 0;
    }

    public int getDemandIndexFor(int n) {
        int n2 = 0;
        for (int i = 0; i < this.demandCount; ++i) {
            if (this.demandData[n2 + 0] == n) {
                return i;
            }
            n2 += 3;
        }
        return -1;
    }

    public int getDemandCount() {
        return this.demandCount;
    }

    private int getDemand(int n, int n2) {
        if (n < 0 || n >= this.demandCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.demandCount);
        }
        return this.demandData[n * 3 + n2];
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTransportName()).append('[');
        if (this.startDate != 0 || this.endDate != 0) {
            stringBuffer.append(this.startDate).append(',').append(this.endDate).append(',');
        }
        stringBuffer.append("demand=[");
        int n3 = 0;
        int n4 = this.demandCount * 3;
        for (n2 = 0; n2 < n4; n2 += 3) {
            stringBuffer.append('[');
            for (n = 0; n < 3; ++n) {
                stringBuffer.append(this.demandData[n2 + n]).append(',');
            }
            stringBuffer.append(this.getAverageProductPrice(n3));
            stringBuffer.append(']');
            ++n3;
        }
        stringBuffer.append(",supply=[");
        n3 = 0;
        n4 = this.supplyCount * 4;
        for (n2 = 0; n2 < n4; n2 += 4) {
            stringBuffer.append('[');
            for (n = 0; n < 4; ++n) {
                stringBuffer.append(this.supplyData[n2 + n]).append(',');
            }
            stringBuffer.append(this.getAverageSupplyPrice(n3));
            stringBuffer.append(']');
            ++n3;
        }
        stringBuffer.append("],supplier=[");
        for (n3 = 0; n3 < this.supplierCount; ++n3) {
            SupplierData supplierData = this.supplierData[n3];
            stringBuffer.append('[').append(supplierData.supplier).append(',').append(supplierData.productID).append(',').append(supplierData.getAverageCapacity()).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String getTransportName() {
        return "marketReport";
    }

    public void read(TransportReader transportReader) throws ParseException {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        boolean bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        this.startDate = transportReader.getAttributeAsInt("startDate", 0);
        this.endDate = transportReader.getAttributeAsInt("endDate", 0);
        while (transportReader.nextNode(false)) {
            int n;
            int n2;
            int n3;
            if (transportReader.isNode("supplyInfo")) {
                int n4 = transportReader.getAttributeAsInt(supplyNames[0]);
                n3 = transportReader.getAttributeAsInt(supplyNames[1], 0);
                n2 = transportReader.getAttributeAsInt(supplyNames[2], 0);
                n = transportReader.getAttributeAsInt(supplyNames[3]);
                int n5 = transportReader.getAttributeAsInt("price", 0);
                this.addSupplyForProduct(n4, n3, n2, n, n5);
                continue;
            }
            if (transportReader.isNode("demandInfo")) {
                int n6 = transportReader.getAttributeAsInt(demandNames[0]);
                n3 = transportReader.getAttributeAsInt(demandNames[1], 0);
                n2 = transportReader.getAttributeAsInt(demandNames[2]);
                n = transportReader.getAttributeAsInt("price", 0);
                this.addDemandForProduct(n6, n3, n2, n);
                continue;
            }
            if (!transportReader.isNode("supplierInfo")) continue;
            String string = transportReader.getAttribute("supplier");
            n3 = transportReader.getAttributeAsInt("product");
            n2 = transportReader.getAttributeAsInt("capacity");
            this.addSupplierCapacity(string, n3, n2);
        }
        if (bl) {
            this.lock();
        }
    }

    public void write(TransportWriter transportWriter) {
        int n;
        int n2;
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        if (this.startDate != 0) {
            transportWriter.attr("startDate", this.startDate);
        }
        if (this.endDate != 0) {
            transportWriter.attr("endDate", this.endDate);
        }
        int n3 = 0;
        int n4 = this.supplyCount * 4;
        for (n2 = 0; n2 < n4; n2 += 4) {
            n = this.supplyData[n2 + 1];
            long l = this.supplyPrice[n3];
            transportWriter.node("supplyInfo");
            for (int i = 0; i < 4; ++i) {
                transportWriter.attr(supplyNames[i], this.supplyData[n2 + i]);
            }
            if (n > 0 && l > 0L) {
                transportWriter.attr("price", (int)(l / (long)n));
            }
            transportWriter.endNode("supplyInfo");
            ++n3;
        }
        n3 = 0;
        n4 = this.demandCount * 3;
        for (n2 = 0; n2 < n4; n2 += 3) {
            n = this.demandData[n2 + 1];
            int n5 = this.demandData[n2 + 2];
            long l = this.demandPrice[n3];
            transportWriter.node("demandInfo").attr(demandNames[0], this.demandData[n2 + 0]).attr(demandNames[1], n).attr(demandNames[2], n5);
            if (n5 > 0 && l > 0L) {
                transportWriter.attr("price", (int)(l / (long)n5));
            }
            transportWriter.endNode("demandInfo");
            ++n3;
        }
        for (n3 = 0; n3 < this.supplierCount; ++n3) {
            SupplierData supplierData = this.supplierData[n3];
            transportWriter.node("supplierInfo").attr("supplier", supplierData.supplier).attr("product", supplierData.productID).attr("capacity", supplierData.getAverageCapacity()).endNode("supplierInfo");
        }
    }

    private static class SupplierData
    implements Serializable {
        public final String supplier;
        public final int productID;
        private int totalCapacity;
        private int capacityCount;

        public SupplierData(String string, int n) {
            this.supplier = string;
            this.productID = n;
        }

        public void addCapacity(int n) {
            this.totalCapacity += n;
            ++this.capacityCount;
        }

        public int getAverageCapacity() {
            return this.capacityCount > 0 ? this.totalCapacity / this.capacityCount : 0;
        }
    }
}

