/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.props.RFQBundle;

public class OfferBundle
implements Transportable,
Serializable {
    private static final long serialVersionUID = -5172339880543668863L;
    private static final int OFFER_ID = 0;
    private static final int RFQ_ID = 1;
    private static final int QUANTITY = 2;
    private static final int UNIT_PRICE = 3;
    private static final int DUEDATE = 4;
    private static final int PARTS = 5;
    private int validDate;
    private int[] data;
    private int count;
    private boolean isLocked = false;

    public OfferBundle() {
        this(0, 5);
    }

    public OfferBundle(int n) {
        this(n, 5);
    }

    public OfferBundle(int n, int n2) {
        this.validDate = n;
        this.data = new int[n2 * 5];
    }

    public int getValidDate() {
        return this.validDate;
    }

    public void setValidDate(int n) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        this.validDate = n;
    }

    public void addOffer(int n, RFQBundle rFQBundle, int n2, int n3) {
        this.addOffer(n, rFQBundle, n2, n3, rFQBundle.getDueDate(n2), rFQBundle.getQuantity(n2));
    }

    public void addOffer(int n, RFQBundle rFQBundle, int n2, int n3, int n4, int n5) {
        this.add(n, rFQBundle.getRFQID(n2), n3, n4, n5);
    }

    public void addOffer(int n, int n2, int n3, int n4, int n5) {
        this.add(n, n2, n3, n4, n5);
    }

    private synchronized void add(int n, int n2, int n3, int n4, int n5) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n6 = this.count * 5;
        if (n6 == this.data.length) {
            this.data = ArrayUtils.setSize(this.data, n6 + 250);
        }
        this.data[n6 + 1] = n2;
        this.data[n6 + 0] = n;
        this.data[n6 + 2] = n5;
        this.data[n6 + 3] = n3;
        this.data[n6 + 4] = n4;
        ++this.count;
    }

    public int getIndexFor(int n) {
        int n2 = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[n2 + 0] == n) {
                return i;
            }
            n2 += 5;
        }
        return -1;
    }

    public int getOfferID(int n) {
        return this.get(n, 0);
    }

    public int getRFQID(int n) {
        return this.get(n, 1);
    }

    public int getQuantity(int n) {
        return this.get(n, 2);
    }

    public int getUnitPrice(int n) {
        return this.get(n, 3);
    }

    public int getDueDate(int n) {
        return this.get(n, 4);
    }

    public int size() {
        return this.count;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 5 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[').append(this.validDate).append(',');
        int n = this.count * 5;
        for (int i = 0; i < n; i += 5) {
            stringBuffer.append('[').append(this.data[i]);
            for (int j = 1; j < 5; ++j) {
                stringBuffer.append(',').append(this.data[i + j]);
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getTransportName() {
        return "offerBundle";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        this.setValidDate(transportReader.getAttributeAsInt("validDate", 0));
        while (transportReader.nextNode("offer", false)) {
            this.add(transportReader.getAttributeAsInt("id"), transportReader.getAttributeAsInt("rfq"), transportReader.getAttributeAsInt("unitprice"), transportReader.getAttributeAsInt("duedate"), transportReader.getAttributeAsInt("quantity"));
        }
        if (bl) {
            this.lock();
        }
    }

    public void write(TransportWriter transportWriter) {
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        if (this.validDate != 0) {
            transportWriter.attr("validDate", this.validDate);
        }
        int n = this.count * 5;
        for (int i = 0; i < n; i += 5) {
            transportWriter.node("offer").attr("id", this.data[i + 0]).attr("rfq", this.data[i + 1]).attr("unitprice", this.data[i + 3]).attr("duedate", this.data[i + 4]).attr("quantity", this.data[i + 2]).endNode("offer");
        }
    }
}

