/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.props.OfferBundle;

public class OrderBundle
implements Transportable,
Serializable {
    private static final long serialVersionUID = 1361992356868562281L;
    private static final int ORDER_ID = 0;
    private static final int OFFER_ID = 1;
    private static final int PARTS = 2;
    private int[] data;
    private int count;
    private boolean isLocked = false;

    public OrderBundle() {
        this(5);
    }

    public OrderBundle(int n) {
        this.data = new int[n * 2];
    }

    public void addOrder(int n, OfferBundle offerBundle, int n2) {
        this.addOrder(n, offerBundle.getOfferID(n2));
    }

    public synchronized void addOrder(int n, int n2) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n3 = this.count * 2;
        if (n3 == this.data.length) {
            this.data = ArrayUtils.setSize(this.data, n3 + 100);
        }
        this.data[n3 + 0] = n;
        this.data[n3 + 1] = n2;
        ++this.count;
    }

    public int getOrderID(int n) {
        return this.get(n, 0);
    }

    public int getOfferID(int n) {
        return this.get(n, 1);
    }

    public int size() {
        return this.count;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 2 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[');
        int n = this.count * 2;
        for (int i = 0; i < n; i += 2) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('[').append(this.data[i + 0]).append(',').append(this.data[i + 1]).append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getTransportName() {
        return "orderBundle";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl;
        boolean bl2 = bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        while (transportReader.nextNode("order", false)) {
            this.addOrder(transportReader.getAttributeAsInt("id"), transportReader.getAttributeAsInt("offer"));
        }
        if (bl) {
            this.lock();
        }
    }

    public void write(TransportWriter transportWriter) {
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        int n = 0;
        int n2 = 0;
        while (n < this.count) {
            transportWriter.node("order").attr("id", this.data[n2 + 0]).attr("offer", this.data[n2 + 1]).endNode("order");
            ++n;
            n2 += 2;
        }
    }
}

