/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class PriceReport
implements Transportable,
Serializable {
    private static final long serialVersionUID = 553988878211682440L;
    private static final int PRODUCT_ID = 0;
    private static final int LOWEST_PRICE = 1;
    private static final int HIGHEST_PRICE = 2;
    private static final int PARTS = 3;
    private static final String[] names = new String[]{"product", "lowestPrice", "highestPrice"};
    private int[] data;
    private int count;
    private boolean isLocked = false;

    public PriceReport() {
        this(16);
    }

    public PriceReport(int n) {
        this.data = new int[n * 3];
    }

    public synchronized void addPriceInfo(int n, int n2, int n3) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n4 = this.count * 3;
        if (n4 == this.data.length) {
            this.data = ArrayUtils.setSize(this.data, n4 + 30);
        }
        this.data[n4 + 0] = n;
        this.data[n4 + 1] = n2;
        this.data[n4 + 2] = n3;
        ++this.count;
    }

    public synchronized void setPriceForProduct(int n, int n2) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n3 = this.getIndexFor(n);
        if (n3 < 0) {
            this.addPriceInfo(n, n2, n2);
        } else {
            if (n2 < this.data[(n3 *= 3) + 1]) {
                this.data[n3 + 1] = n2;
            }
            if (n2 > this.data[n3 + 2]) {
                this.data[n3 + 2] = n2;
            }
        }
    }

    public int getIndexFor(int n) {
        int n2 = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.data[n2 + 0] == n) {
                return i;
            }
            n2 += 3;
        }
        return -1;
    }

    public int getProductID(int n) {
        return this.get(n, 0);
    }

    public int getLowestPrice(int n) {
        return this.get(n, 1);
    }

    public int getHighestPrice(int n) {
        return this.get(n, 2);
    }

    public int size() {
        return this.count;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 3 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTransportName()).append('[');
        int n = this.count * 3;
        for (int i = 0; i < n; i += 3) {
            stringBuffer.append('[').append(this.data[i]);
            for (int j = 1; j < 3; ++j) {
                stringBuffer.append(',').append(this.data[i + j]);
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String getTransportName() {
        return "priceReport";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl;
        boolean bl2 = bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        while (transportReader.nextNode("priceInfo", false)) {
            this.addPriceInfo(transportReader.getAttributeAsInt(names[0]), transportReader.getAttributeAsInt(names[1]), transportReader.getAttributeAsInt(names[2]));
        }
        if (bl) {
            this.lock();
        }
    }

    public void write(TransportWriter transportWriter) {
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        int n = this.count * 3;
        for (int i = 0; i < n; i += 3) {
            transportWriter.node("priceInfo");
            for (int j = 0; j < 3; ++j) {
                transportWriter.attr(names[j], this.data[i + j]);
            }
            transportWriter.endNode("priceInfo");
        }
    }
}

