/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class ProductionSchedule
implements Transportable,
Serializable {
    private static final long serialVersionUID = -400899896032305684L;
    private static final int PRODUCT_ID = 0;
    private static final int QUANTITY = 1;
    private static final int PARTS = 2;
    private int[] data;
    private int count = 0;

    public ProductionSchedule() {
        this(5);
    }

    public ProductionSchedule(int n) {
        this.data = new int[n * 2];
    }

    public synchronized void addProduction(int n, int n2) {
        int n3 = this.count * 2;
        if (n3 == this.data.length) {
            this.data = ArrayUtils.setSize(this.data, n3 + 40);
        }
        this.data[n3 + 0] = n;
        this.data[n3 + 1] = n2;
        ++this.count;
    }

    public int getProductID(int n) {
        return this.get(n, 0);
    }

    public int getQuantity(int n) {
        return this.get(n, 1);
    }

    public int size() {
        return this.count;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.count);
        }
        return this.data[n * 2 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTransportName()).append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('[').append(this.getProductID(i)).append(',').append(this.getQuantity(i)).append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getTransportName() {
        return "productionSchedule";
    }

    public void read(TransportReader transportReader) throws ParseException {
        while (transportReader.nextNode("produce", false)) {
            this.addProduction(transportReader.getAttributeAsInt("product"), transportReader.getAttributeAsInt("quantity"));
        }
    }

    public void write(TransportWriter transportWriter) {
        int n = 0;
        int n2 = 0;
        while (n < this.count) {
            transportWriter.node("produce").attr("product", this.data[n2 + 0]).attr("quantity", this.data[n2 + 1]).endNode("produce");
            ++n;
            n2 += 2;
        }
    }
}

