/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public class RFQBundle
implements Transportable,
Serializable {
    private static final long serialVersionUID = 746403139800839531L;
    private static final int RFQ_ID = 0;
    private static final int PRODUCT_ID = 1;
    private static final int QUANTITY = 2;
    private static final int DUEDATE = 3;
    private static final int PENALTY = 4;
    private static final int RESERVE_PRICE = 5;
    private static final int PARTS = 6;
    private static final String[] names = new String[]{"id", "product", "quantity", "duedate", "penalty", "reservePricePerUnit"};
    private int validDate;
    private int[] rfqData;
    private int rfqCount;
    private int startID = -1;
    private boolean isLocked = false;
    private long totalQuantity = 0L;

    public RFQBundle() {
        this(0, 5);
    }

    public RFQBundle(int n) {
        this(n, 5);
    }

    public RFQBundle(int n, int n2) {
        this.validDate = n;
        this.rfqData = new int[n2 * 6];
    }

    public int getValidDate() {
        return this.validDate;
    }

    public void setValidDate(int n) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        this.validDate = n;
    }

    public void addRFQ(int n, int n2, int n3, int n4) {
        this.addRFQ(n, n2, n3, 0, n4, 0);
    }

    public void addRFQ(int n, int n2, int n3, int n4, int n5) {
        this.addRFQ(n, n2, n3, 0, n4, n5);
    }

    public synchronized void addRFQ(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n7 = this.rfqCount * 6;
        if (n7 == this.rfqData.length) {
            this.rfqData = ArrayUtils.setSize(this.rfqData, n7 + 300);
        }
        this.rfqData[n7 + 0] = n;
        this.rfqData[n7 + 1] = n2;
        this.rfqData[n7 + 2] = n3;
        this.rfqData[n7 + 3] = n5;
        this.rfqData[n7 + 4] = n6;
        this.rfqData[n7 + 5] = n4;
        ++this.rfqCount;
        if (this.startID < 0) {
            this.startID = n;
        }
        this.totalQuantity += n3 < 0 ? (long)(-n3) : (long)n3;
    }

    public int getIndexFor(int n) {
        if (n < this.startID + this.rfqCount && n >= this.startID && this.rfqData[(n - this.startID) * 6 + 0] == n) {
            return n - this.startID;
        }
        int n2 = 0;
        for (int i = 0; i < this.rfqCount; ++i) {
            if (this.rfqData[n2 + 0] == n) {
                return i;
            }
            n2 += 6;
        }
        return -1;
    }

    public int getRFQID(int n) {
        return this.get(n, 0);
    }

    public int getProductID(int n) {
        return this.get(n, 1);
    }

    public int getQuantity(int n) {
        return this.get(n, 2);
    }

    public int getTotalQuantity() {
        return Integer.MAX_VALUE < this.totalQuantity ? Integer.MAX_VALUE : (int)this.totalQuantity;
    }

    public int getDueDate(int n) {
        return this.get(n, 3);
    }

    public int getPenalty(int n) {
        return this.get(n, 4);
    }

    public int getReservePricePerUnit(int n) {
        return this.get(n, 5);
    }

    public int size() {
        return this.rfqCount;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    private int get(int n, int n2) {
        if (n < 0 || n >= this.rfqCount) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.rfqCount);
        }
        return this.rfqData[n * 6 + n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTransportName()).append('[');
        if (this.validDate != 0) {
            stringBuffer.append(this.validDate).append(',');
        }
        int n = this.rfqCount * 6;
        for (int i = 0; i < n; i += 6) {
            stringBuffer.append('[').append(this.rfqData[i]);
            for (int j = 1; j < 6; ++j) {
                stringBuffer.append(',').append(this.rfqData[i + j]);
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String getTransportName() {
        return "rfqBundle";
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        this.setValidDate(transportReader.getAttributeAsInt("validDate", 0));
        while (transportReader.nextNode("rfq", false)) {
            int n = transportReader.getAttributeAsInt(names[2]);
            int n2 = transportReader.getAttributeAsInt(names[5], 0);
            if (n2 == 0 && n > 0) {
                n2 = transportReader.getAttributeAsInt("reservePrice", 0) / n;
            }
            this.addRFQ(transportReader.getAttributeAsInt(names[0]), transportReader.getAttributeAsInt(names[1]), n, n2, transportReader.getAttributeAsInt(names[3]), transportReader.getAttributeAsInt(names[4], 0));
        }
        this.isLocked = bl;
    }

    public void write(TransportWriter transportWriter) {
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        if (this.validDate != 0) {
            transportWriter.attr("validDate", this.validDate);
        }
        int n = this.rfqCount * 6;
        for (int i = 0; i < n; i += 6) {
            transportWriter.node("rfq");
            for (int j = 0; j < 6; ++j) {
                transportWriter.attr(names[j], this.rfqData[i + j]);
            }
            transportWriter.endNode("rfq");
        }
    }
}

