/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import com.botbox.util.ArrayUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.logging.Logger;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.isl.transport.Transportable;

public abstract class SimpleContent
implements Transportable,
Serializable {
    private static final long serialVersionUID = 3025394464668122965L;
    private static final Logger log = Logger.getLogger(SimpleContent.class.getName());
    private static final int NAME = 0;
    private static final int VALUE = 1;
    private static final int PARTS = 2;
    private Object[] attributePairs;
    private int attributeCount;
    private boolean isLocked = false;

    protected SimpleContent() {
    }

    public String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public String getAttribute(String string, String string2) {
        Object object = this.get(string);
        return object == null ? string2 : object.toString();
    }

    public int getAttributeAsInt(String string, int n) {
        Object object = this.get(string);
        if (object != null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            try {
                if (object instanceof Long) {
                    return (int)((Long)object).longValue();
                }
                return Integer.parseInt(object.toString());
            }
            catch (Exception exception) {
                log.warning("attribute '" + string + "' has a non-integer value '" + object + '\'');
            }
        }
        return n;
    }

    public long getAttributeAsLong(String string, long l) {
        Object object = this.get(string);
        if (object != null) {
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof Integer) {
                return ((Integer)object).intValue();
            }
            try {
                return Long.parseLong(object.toString());
            }
            catch (Exception exception) {
                log.warning("attribute '" + string + "' has a non-long value '" + object + '\'');
            }
        }
        return l;
    }

    public float getAttributeAsFloat(String string, float f) {
        Object object = this.get(string);
        if (object != null) {
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
            try {
                if (object instanceof Integer) {
                    return ((Integer)object).intValue();
                }
                return Float.parseFloat(object.toString());
            }
            catch (Exception exception) {
                log.warning("attribute '" + string + "' has a non-float value '" + object + '\'');
            }
        }
        return f;
    }

    private Object get(String string) {
        int n = ArrayUtils.keyValuesIndexOf(this.attributePairs, 2, 0, this.attributeCount * 2, string);
        return n >= 0 ? this.attributePairs[n + 1] : null;
    }

    public void setAttribute(String string, String string2) {
        if (string2 == null) {
            this.removeAttribute(string);
        } else {
            this.set(string, string2);
        }
    }

    public void setAttribute(String string, int n) {
        this.set(string, new Integer(n));
    }

    public void setAttribute(String string, long l) {
        this.set(string, new Long(l));
    }

    public void setAttribute(String string, float f) {
        this.set(string, new Float(f));
    }

    private void set(String string, Object object) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n = ArrayUtils.keyValuesIndexOf(this.attributePairs, 2, 0, this.attributeCount * 2, string);
        if (n >= 0) {
            this.attributePairs[n + 1] = object;
        } else {
            n = this.attributeCount * 2;
            if (this.attributePairs == null) {
                this.attributePairs = new Object[8];
            } else if (n == this.attributePairs.length) {
                this.attributePairs = ArrayUtils.setSize(this.attributePairs, n + 20);
            }
            this.attributePairs[n + 0] = string;
            this.attributePairs[n + 1] = object;
            ++this.attributeCount;
        }
    }

    public void removeAttribute(String string) {
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        int n = ArrayUtils.keyValuesIndexOf(this.attributePairs, 2, 0, this.attributeCount * 2, string);
        if (n >= 0) {
            --this.attributeCount;
            int n2 = this.attributeCount * 2;
            this.attributePairs[n + 0] = this.attributePairs[n2 + 0];
            this.attributePairs[n + 1] = this.attributePairs[n2 + 1];
            this.attributePairs[n2 + 0] = null;
            this.attributePairs[n2 + 1] = null;
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        this.isLocked = true;
    }

    protected StringBuffer params(StringBuffer stringBuffer) {
        stringBuffer.append('[');
        if (this.attributeCount > 0) {
            stringBuffer.append(this.attributePairs[0]).append('=').append(this.attributePairs[1]);
            int n = this.attributeCount * 2;
            for (int i = 2; i < n; i += 2) {
                stringBuffer.append(',').append(this.attributePairs[i + 0]).append('=').append(this.attributePairs[i + 1]);
            }
        }
        return stringBuffer.append(']');
    }

    public void read(TransportReader transportReader) throws ParseException {
        boolean bl;
        if (this.isLocked) {
            throw new IllegalStateException("locked");
        }
        boolean bl2 = bl = transportReader.getAttributeAsInt("lock", 0) > 0;
        if (transportReader.nextNode("params", false)) {
            int n = transportReader.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = transportReader.getAttributeName(i);
                this.setAttribute(string, transportReader.getAttribute(i));
            }
        }
        this.isLocked = bl;
    }

    public void write(TransportWriter transportWriter) {
        if (this.isLocked) {
            transportWriter.attr("lock", 1);
        }
        if (this.attributeCount > 0) {
            transportWriter.node("params");
            int n = this.attributeCount * 2;
            for (int i = 0; i < n; i += 2) {
                String string = this.attributePairs[i + 0].toString();
                Object object = this.attributePairs[i + 1];
                if (object instanceof Integer) {
                    transportWriter.attr(string, (Integer)object);
                    continue;
                }
                if (object instanceof Long) {
                    transportWriter.attr(string, (Long)object);
                    continue;
                }
                if (object instanceof Float) {
                    transportWriter.attr(string, ((Float)object).floatValue());
                    continue;
                }
                transportWriter.attr(string, object.toString());
            }
            transportWriter.endNode("params");
        }
    }
}

