/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.props;

import java.text.ParseException;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.TransportWriter;
import se.sics.tasim.props.SimpleContent;

public class SimulationStatus
extends SimpleContent {
    private static final long serialVersionUID = 7937789505047945874L;
    private int simDate;
    private int consumedMillis;
    private boolean isSimulationEnded;

    public SimulationStatus() {
    }

    public SimulationStatus(int n, int n2) {
        this(n, n2, false);
    }

    public SimulationStatus(int n, int n2, boolean bl) {
        this.simDate = n;
        this.consumedMillis = n2;
        this.isSimulationEnded = bl;
    }

    public boolean isSimulationEnded() {
        return this.isSimulationEnded;
    }

    public int getCurrentDate() {
        return this.simDate;
    }

    public int getConsumedMillis() {
        return this.consumedMillis;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getTransportName()).append('[').append(this.simDate).append(',').append(this.consumedMillis).append(',').append(this.isSimulationEnded).append(',');
        return this.params(stringBuffer).append(']').toString();
    }

    public String getTransportName() {
        return "simulationStatus";
    }

    public void read(TransportReader transportReader) throws ParseException {
        if (this.isLocked()) {
            throw new IllegalStateException("locked");
        }
        this.simDate = transportReader.getAttributeAsInt("date");
        this.consumedMillis = transportReader.getAttributeAsInt("consumedMillis");
        this.isSimulationEnded = transportReader.getAttributeAsInt("isSimulationEnded", 0) > 0;
        super.read(transportReader);
    }

    public void write(TransportWriter transportWriter) {
        transportWriter.attr("date", this.simDate).attr("consumedMillis", this.consumedMillis);
        if (this.isSimulationEnded) {
            transportWriter.attr("isSimulationEnded", 1);
        }
        super.write(transportWriter);
    }
}

