/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.tac03.aw;

import com.botbox.util.ArrayUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.Serializable;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import se.sics.isl.gui.BarDiagram;
import se.sics.isl.gui.DotDiagram;
import se.sics.isl.gui.MessageModel;
import se.sics.isl.gui.MessageRenderer;
import se.sics.isl.transport.Transportable;
import se.sics.isl.util.FormatUtils;
import se.sics.tasim.aw.client.InfoViewer;
import se.sics.tasim.props.BOMBundle;
import se.sics.tasim.props.BankStatus;
import se.sics.tasim.props.ComponentCatalog;
import se.sics.tasim.props.DeliveryNotice;
import se.sics.tasim.props.DeliverySchedule;
import se.sics.tasim.props.FactoryStatus;
import se.sics.tasim.props.OfferBundle;
import se.sics.tasim.props.OrderBundle;
import se.sics.tasim.props.RFQBundle;
import se.sics.tasim.props.StartInfo;

public class ManufacturerInfo
extends InfoViewer {
    private static final Logger log = Logger.getLogger(ManufacturerInfo.class.getName());
    private JPanel mainPanel;
    private JList messageList;
    private MessageModel messageModel;
    private RFQBundle lastRFQsFromCustomer;
    private RFQBundle lastDaysRFQsFromCustomer;
    private OfferBundle lastOffersToCustomer;
    private TitledBorder accountBorder;
    private TitledBorder utilityBorder;
    private DotDiagram bankDiagram;
    private DotDiagram utilDiagram;
    private int[] bankAccount = new int[60];
    private int bankPos;
    private int[] utilization = new int[60];
    private int utilPos;
    private BarDiagram productDiagram;
    private int[] pcIDs;
    private int[] pcInventory;
    private BarDiagram componentDiagram;
    private int[] componentIDs;
    private int[] componentInventory;
    private String[] componentNames;
    private String[] pcNames;
    private ComponentCatalog catalog;
    private BOMBundle bomBundle;

    public void init(String string) {
        Serializable serializable;
        this.mainPanel = new JPanel(new GridLayout(3, 2));
        this.mainPanel.setBackground(Color.white);
        JLabel jLabel = new JLabel();
        URL uRL = ManufacturerInfo.class.getResource("/images/manufacturer.jpg");
        if (uRL != null) {
            serializable = new ImageIcon(uRL);
            jLabel.setIcon((Icon)((Object)serializable));
        }
        jLabel.setBorder(BorderFactory.createTitledBorder("Agent " + string));
        this.mainPanel.add(jLabel);
        this.messageModel = new MessageModel(50);
        this.messageList = new JList(this.messageModel);
        this.messageList.setCellRenderer(new MessageRenderer(this.messageModel));
        this.mainPanel.add(this.createScrollPane(this.messageList, "Latest Events", true));
        this.accountBorder = BorderFactory.createTitledBorder("Bank Account");
        serializable = new Dimension(200, 200);
        this.bankDiagram = new DotDiagram(1);
        this.bankDiagram.setBorder(this.accountBorder);
        this.bankDiagram.setPreferredSize((Dimension)serializable);
        this.bankDiagram.setDotColor(0, Color.blue);
        this.mainPanel.add(this.bankDiagram);
        this.utilityBorder = BorderFactory.createTitledBorder("Factory Utilization");
        this.utilDiagram = new DotDiagram(1);
        this.utilDiagram.setMinMax(0, 100);
        this.utilDiagram.setDotColor(0, Color.blue);
        this.utilDiagram.setBorder(this.utilityBorder);
        this.utilDiagram.setPreferredSize((Dimension)serializable);
        this.mainPanel.add(this.utilDiagram);
        this.bankDiagram.setData(0, this.bankAccount, this.bankPos, this.bankAccount.length);
        this.utilDiagram.setData(0, this.utilization, this.utilPos, this.utilization.length);
        this.productDiagram = new BarDiagram();
        this.productDiagram.setShowingValue(true);
        this.productDiagram.setBarColors(Color.blue, Color.red);
        this.productDiagram.setBorder(BorderFactory.createTitledBorder("Product Inventory"));
        this.productDiagram.setPreferredSize((Dimension)serializable);
        this.mainPanel.add(this.productDiagram);
        this.componentDiagram = new BarDiagram();
        this.componentDiagram.setShowingValue(true);
        this.componentDiagram.setValueColor(Color.black);
        this.componentDiagram.setBarColors(Color.yellow, Color.green);
        this.componentDiagram.setBorder(BorderFactory.createTitledBorder("Component Inventory"));
        this.componentDiagram.setPreferredSize((Dimension)serializable);
        this.mainPanel.add(this.componentDiagram);
    }

    private void checkInitialized() {
        BOMBundle bOMBundle = this.bomBundle;
        ComponentCatalog componentCatalog = this.catalog;
        if (this.pcIDs == null && bOMBundle != null && componentCatalog != null) {
            int n;
            int n2 = bOMBundle.size();
            this.pcIDs = new int[n2];
            this.pcInventory = new int[n2];
            this.pcNames = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.pcIDs[n] = bOMBundle.getProductID(n);
                this.pcNames[n] = bOMBundle.getProductName(n) + " [" + this.pcIDs[n] + "]: ";
            }
            this.productDiagram.setNames(this.pcNames);
            this.productDiagram.setToolTipVisible(true);
            n2 = componentCatalog.size();
            this.componentNames = new String[n2];
            this.componentIDs = new int[n2];
            this.componentInventory = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.componentIDs[n] = componentCatalog.getProductID(n);
                this.componentNames[n] = componentCatalog.getProductName(n) + " [" + this.componentIDs[n] + "]: ";
            }
            this.componentDiagram.setNames(this.componentNames);
            this.componentDiagram.setToolTipVisible(true);
        }
    }

    protected void addMessage(String string) {
        this.addMessage(string, 0);
    }

    protected void addMessage(String string, int n) {
        this.messageModel.addMessage(string, n);
        this.messageList.ensureIndexIsVisible(this.messageModel.getSize() - 1);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void messageSent(final String string, final Transportable transportable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ManufacturerInfo.this.handleMessageSent(string, transportable);
            }
        });
    }

    private void handleMessageSent(String string, Transportable transportable) {
        Class<?> clazz = transportable.getClass();
        if (clazz == OfferBundle.class) {
            OfferBundle offerBundle;
            this.lastOffersToCustomer = offerBundle = (OfferBundle)transportable;
            int n = offerBundle.size();
            int n2 = 0;
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                int n3 = offerBundle.getQuantity(i);
                n2 += n3;
                l += (long)(n3 * offerBundle.getUnitPrice(i));
            }
            this.addMessage("offered " + n2 + " PC" + (n2 > 1 ? "s" : "") + " for $" + FormatUtils.formatAmount(l));
        } else if (clazz == DeliverySchedule.class) {
            DeliverySchedule deliverySchedule = (DeliverySchedule)transportable;
            int n = deliverySchedule.getTotalQuantity();
            this.addMessage("requested delivery of " + n + " PC" + (n > 1 ? "s" : ""));
        }
    }

    public void messageReceived(final String string, final Transportable transportable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ManufacturerInfo.this.handleMessageReceived(string, transportable);
            }
        });
    }

    private void handleMessageReceived(String string, Transportable transportable) {
        Class<?> clazz = transportable.getClass();
        if (clazz == RFQBundle.class) {
            RFQBundle rFQBundle = (RFQBundle)transportable;
            this.lastDaysRFQsFromCustomer = this.lastRFQsFromCustomer;
            this.lastRFQsFromCustomer = rFQBundle;
            int n = rFQBundle.size();
            int n2 = rFQBundle.getTotalQuantity();
            this.addMessage(n2 + " PC" + (n2 > 1 ? "s" : "") + " requested in " + n + " RFQ" + (n > 1 ? "s" : ""));
        } else if (clazz == OrderBundle.class) {
            this.handleOrders(string, (OrderBundle)transportable);
        } else if (clazz == FactoryStatus.class) {
            this.handleInventory((FactoryStatus)transportable);
        } else if (clazz == BankStatus.class) {
            this.handleBankStatus(string, (BankStatus)transportable);
        } else if (clazz == DeliveryNotice.class) {
            DeliveryNotice deliveryNotice = (DeliveryNotice)transportable;
            int n = deliveryNotice.size();
            if (n < 4) {
                ComponentCatalog componentCatalog = this.catalog;
                for (int i = 0; i < n; ++i) {
                    int n3;
                    int n4 = deliveryNotice.getQuantity(i);
                    int n5 = deliveryNotice.getProductID(i);
                    if (componentCatalog != null && (n3 = componentCatalog.getIndexFor(n5)) >= 0) {
                        this.addMessage("" + n4 + ' ' + string + ' ' + componentCatalog.getProductName(n3) + " delivered");
                        continue;
                    }
                    this.addMessage("" + n4 + ' ' + string + " component" + (n4 > 1 ? "s" : "") + " delivered");
                }
            } else {
                int n6 = deliveryNotice.getTotalQuantity();
                this.addMessage("" + n6 + ' ' + string + " component" + (n6 > 1 ? "s" : "") + " delivered");
            }
        } else if (clazz == BOMBundle.class) {
            this.bomBundle = (BOMBundle)transportable;
            this.checkInitialized();
        } else if (clazz == ComponentCatalog.class) {
            this.catalog = (ComponentCatalog)transportable;
            this.checkInitialized();
        } else if (clazz == StartInfo.class) {
            int n;
            this.messageModel.clear();
            int n7 = this.bankAccount.length;
            for (n = 0; n < n7; ++n) {
                this.bankAccount[n] = 0;
            }
            this.bankPos = 0;
            n7 = this.utilization.length;
            for (n = 0; n < n7; ++n) {
                this.utilization[n] = 0;
            }
            this.utilPos = 0;
            this.pcInventory = null;
            this.pcIDs = null;
            this.pcNames = null;
            this.productDiagram.setNames(null);
            this.productDiagram.setToolTipVisible(false);
            this.productDiagram.setData(null);
            this.componentInventory = null;
            this.componentIDs = null;
            this.componentNames = null;
            this.componentDiagram.setNames(null);
            this.componentDiagram.setToolTipVisible(false);
            this.componentDiagram.setData(null);
        }
    }

    private void handleOrders(String string, OrderBundle orderBundle) {
        OfferBundle offerBundle = this.lastOffersToCustomer;
        int n = orderBundle.size();
        if (offerBundle == null) {
            this.addMessage("got " + n + " order" + (n > 1 ? "s" : "") + " (info missing)");
        } else {
            int n2 = 0;
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                int n3 = orderBundle.getOfferID(i);
                int n4 = offerBundle.getIndexFor(n3);
                if (n4 < 0) continue;
                int n5 = offerBundle.getQuantity(n4);
                n2 += n5;
                l += (long)(n5 * offerBundle.getUnitPrice(n4));
            }
            this.addMessage(n2 + " PC" + (n2 == 1 ? "" : "s") + " for $" + FormatUtils.formatAmount(l) + " ordered");
        }
    }

    private void handleBankStatus(String string, BankStatus bankStatus) {
        int n;
        long l = bankStatus.getAccountStatus();
        this.accountBorder.setTitle("Bank Account ($" + FormatUtils.formatAmount(l) + ')');
        this.bankAccount[this.bankPos] = l >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (l <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)l);
        this.bankPos = (this.bankPos + 1) % this.bankAccount.length;
        if (this.bankDiagram != null) {
            this.bankDiagram.setData(0, this.bankAccount, this.bankPos, this.bankAccount.length);
        }
        if ((n = bankStatus.getPenaltyCount()) > 0) {
            long l2 = bankStatus.getTotalPenaltyAmount();
            this.addMessage("penalty $" + FormatUtils.formatAmount(l2) + " for " + n + " late deliver" + (n == 1 ? "y" : "ies"), 1);
        }
    }

    private void handleInventory(FactoryStatus factoryStatus) {
        int n;
        if (this.pcIDs == null) {
            log.severe("could not handle inventory because missing " + (this.bomBundle == null ? "BOMBundle" : "ComponentCatalog"));
            return;
        }
        int n2 = this.pcInventory.length;
        for (n = 0; n < n2; ++n) {
            this.pcInventory[n] = 0;
        }
        n2 = this.componentInventory.length;
        for (n = 0; n < n2; ++n) {
            this.componentInventory[n] = 0;
        }
        n2 = factoryStatus.getProductCount();
        for (n = 0; n < n2; ++n) {
            int n3 = factoryStatus.getProductID(n);
            int n4 = ArrayUtils.indexOf(this.componentIDs, n3);
            if (n4 >= 0) {
                this.componentInventory[n4] = factoryStatus.getQuantity(n);
                continue;
            }
            n4 = ArrayUtils.indexOf(this.pcIDs, n3);
            if (n4 >= 0) {
                this.pcInventory[n4] = factoryStatus.getQuantity(n);
                continue;
            }
            log.severe("unknown product in InventoryStatus: " + n3);
        }
        this.productDiagram.setData(this.pcInventory);
        this.componentDiagram.setData(this.componentInventory);
        this.utilization[this.utilPos] = n = (int)(factoryStatus.getUtilization() * 100.0f);
        this.utilPos = (this.utilPos + 1) % this.utilization.length;
        this.utilityBorder.setTitle("Factory Utilization (" + n + "%)");
        this.utilDiagram.setData(0, this.utilization, this.utilPos, this.utilization.length);
    }

    protected JScrollPane createScrollPane(JComponent jComponent) {
        return this.createScrollPane(jComponent, null, false);
    }

    protected JScrollPane createScrollPane(JComponent jComponent, String string) {
        return this.createScrollPane(jComponent, string, false);
    }

    protected JScrollPane createScrollPane(JComponent jComponent, String string, boolean bl) {
        JScrollPane jScrollPane = new JScrollPane(jComponent, 20, bl ? 30 : 31);
        Color color = jComponent.getBackground();
        if (color == null) {
            color = Color.white;
        }
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        if (string != null) {
            jScrollPane.setBorder(BorderFactory.createTitledBorder(string));
        }
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setPreferredSize(new Dimension(10, jScrollBar.getHeight()));
        if (bl) {
            jScrollBar = jScrollPane.getHorizontalScrollBar();
            jScrollBar.setPreferredSize(new Dimension(jScrollBar.getWidth(), 10));
        }
        return jScrollPane;
    }
}

