/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.tac03.aw;

import se.sics.tasim.props.OfferBundle;
import se.sics.tasim.props.RFQBundle;

public class Order {
    private static final int DELIVERED = 1;
    private static final int CANCELED = 2;
    private String otherAgent;
    private int orderID = -1;
    private int offerID;
    private int rfqID;
    private int productID;
    private int quantity;
    private int dueDate;
    private int penalty;
    private int unitPrice;
    private int flags = 0;
    private int activeFlag = 0;

    public Order(String string, int n, RFQBundle rFQBundle, int n2, int n3) {
        this.otherAgent = string;
        this.offerID = n;
        this.rfqID = rFQBundle.getRFQID(n2);
        this.productID = rFQBundle.getProductID(n2);
        this.quantity = rFQBundle.getQuantity(n2);
        this.dueDate = rFQBundle.getDueDate(n2);
        this.penalty = rFQBundle.getPenalty(n2);
        this.unitPrice = n3;
    }

    public Order(String string, int n, OfferBundle offerBundle, int n2, int n3) {
        this.otherAgent = string;
        this.orderID = n;
        this.rfqID = offerBundle.getRFQID(n2);
        this.productID = n3;
        this.penalty = 0;
        this.offerID = offerBundle.getOfferID(n2);
        this.quantity = offerBundle.getQuantity(n2);
        this.dueDate = offerBundle.getDueDate(n2);
        this.unitPrice = offerBundle.getUnitPrice(n2);
    }

    public Order(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.otherAgent = string;
        this.orderID = n;
        this.rfqID = -1;
        this.offerID = -1;
        this.productID = n2;
        this.quantity = n3;
        this.unitPrice = n4;
        this.dueDate = n5;
        this.penalty = n6;
    }

    boolean isOrdered() {
        return this.orderID >= 0;
    }

    void setOrdered(int n) {
        if (this.orderID >= 0) {
            throw new IllegalStateException("already ordered");
        }
        this.orderID = n;
    }

    public boolean isActive() {
        return this.activeFlag == 0;
    }

    public boolean isDelivered() {
        return (this.activeFlag & 1) != 0;
    }

    public void setDelivered() {
        this.activeFlag |= 1;
    }

    public boolean isCanceled() {
        return (this.activeFlag & 2) != 0;
    }

    public void setCanceled() {
        this.activeFlag |= 2;
    }

    public String getOtherAgent() {
        return this.otherAgent;
    }

    public int getOrderID() {
        return this.orderID;
    }

    public int getOfferID() {
        return this.offerID;
    }

    public int getRFQID() {
        return this.rfqID;
    }

    public int getProductID() {
        return this.productID;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getDueDate() {
        return this.dueDate;
    }

    public int getPenalty() {
        return this.penalty;
    }

    public int getUnitPrice() {
        return this.unitPrice;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }
}

