/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.tac03.aw;

import com.botbox.util.ArrayUtils;
import se.sics.tasim.props.OfferBundle;
import se.sics.tasim.tac03.aw.Order;

public class OrderStore {
    private int nextOrderID;
    private Order[] orderList = new Order[512];
    private int orderCount = 0;
    private int activeStartIndex = 0;

    public OrderStore() {
        this(1);
    }

    public OrderStore(int n) {
        this.nextOrderID = n;
    }

    public synchronized Order getOrder(int n) {
        int n2;
        if (n >= this.nextOrderID) {
            return null;
        }
        for (n2 = this.activeStartIndex; n2 < this.orderCount; ++n2) {
            if (this.orderList[n2].getOrderID() != n) continue;
            return this.orderList[n2];
        }
        for (n2 = 0; n2 < this.activeStartIndex; ++n2) {
            if (this.orderList[n2].getOrderID() != n) continue;
            return this.orderList[n2];
        }
        return null;
    }

    public synchronized Order[] getActiveOrders() {
        while (this.activeStartIndex < this.orderCount && !this.orderList[this.activeStartIndex].isActive()) {
            ++this.activeStartIndex;
        }
        if (this.activeStartIndex == this.orderCount) {
            return null;
        }
        int n = 0;
        Object[] objectArray = new Order[this.orderCount - this.activeStartIndex];
        for (int i = this.activeStartIndex; i < this.orderCount; ++i) {
            Order order = this.orderList[i];
            if (!order.isActive()) continue;
            objectArray[n++] = order;
        }
        if (n < objectArray.length) {
            objectArray = (Order[])ArrayUtils.setSize(objectArray, n);
        }
        return objectArray;
    }

    synchronized void addOrder(Order order) {
        Order order2;
        int n = order.getDueDate();
        int n2 = this.orderCount;
        int n3 = order.getOrderID();
        if (n3 >= this.nextOrderID) {
            this.nextOrderID = n3 + 1;
        }
        if (this.orderCount == this.orderList.length) {
            this.orderList = (Order[])ArrayUtils.setSize(this.orderList, this.orderCount + 256);
        }
        while (n2 > this.activeStartIndex && (order2 = this.orderList[n2 - 1]).getDueDate() > n) {
            this.orderList[n2] = order2;
            --n2;
        }
        this.orderList[n2] = order;
        ++this.orderCount;
    }

    synchronized Order createOrder(String string, OfferBundle offerBundle, int n, int n2) {
        int n3 = this.nextOrderID++;
        Order order = new Order(string, n3, offerBundle, n, n2);
        this.addOrder(order);
        return order;
    }
}

