/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.tac03.aw;

public class RFQStore {
    private static final int PRODUCT = 0;
    private static final int QUANTITY = 1;
    private static final int DUE_DATE = 2;
    private static final int SUBMIT_DATE = 3;
    private static final int PARTS = 4;
    private int[] data = new int[400];
    private String[] supplierAddresses = new String[100];
    private int startID;
    private int count = 0;

    public RFQStore() {
        this(1);
    }

    public RFQStore(int n) {
        this.startID = n;
    }

    public boolean hasRFQ(int n) {
        return n >= this.startID && n < this.startID + this.count;
    }

    public String getSupplier(int n) {
        if (n < this.startID || n >= this.startID + this.count) {
            throw new IllegalArgumentException("RFQ " + n + " not found");
        }
        return this.supplierAddresses[n - this.startID];
    }

    public int getProductID(int n) {
        return this.get(n, 0);
    }

    public int getQuantity(int n) {
        return this.get(n, 1);
    }

    public int getDueDate(int n) {
        return this.get(n, 2);
    }

    private int get(int n, int n2) {
        if (n < this.startID || n >= this.startID + this.count) {
            throw new IllegalArgumentException("RFQ " + n + " not found");
        }
        return this.data[(n - this.startID) * 4 + n2];
    }

    public int getFirstID() {
        return this.count > 0 ? this.startID : -1;
    }

    public int getLastID() {
        return this.count > 0 ? this.startID + this.count : -1;
    }

    synchronized int addRFQ(String string, int n, int n2, int n3, int n4) {
        if (this.count == this.supplierAddresses.length) {
            String[] stringArray = new String[this.count + 100];
            int[] nArray = new int[(this.count + 100) * 4];
            System.arraycopy(this.supplierAddresses, 0, stringArray, 0, this.count);
            System.arraycopy(this.data, 0, nArray, 0, this.count * 4);
            this.supplierAddresses = stringArray;
            this.data = nArray;
        }
        int n5 = this.count++;
        int n6 = n5 * 4;
        this.supplierAddresses[n5] = string;
        this.data[n6 + 0] = n;
        this.data[n6 + 1] = n2;
        this.data[n6 + 2] = n3;
        this.data[n6 + 3] = n4;
        return n5 + this.startID;
    }
}

