/*
 * Decompiled with CFR 0.152.
 */
package se.sics.tasim.tac03.aw;

import com.botbox.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.aw.Agent;
import se.sics.tasim.aw.Message;
import se.sics.tasim.props.ActiveOrders;
import se.sics.tasim.props.BOMBundle;
import se.sics.tasim.props.BankStatus;
import se.sics.tasim.props.ComponentCatalog;
import se.sics.tasim.props.DeliveryNotice;
import se.sics.tasim.props.DeliverySchedule;
import se.sics.tasim.props.FactoryStatus;
import se.sics.tasim.props.InventoryStatus;
import se.sics.tasim.props.MarketReport;
import se.sics.tasim.props.OfferBundle;
import se.sics.tasim.props.OrderBundle;
import se.sics.tasim.props.PriceReport;
import se.sics.tasim.props.ProductionSchedule;
import se.sics.tasim.props.RFQBundle;
import se.sics.tasim.props.SimulationStatus;
import se.sics.tasim.props.StartInfo;
import se.sics.tasim.tac03.aw.Order;
import se.sics.tasim.tac03.aw.OrderStore;
import se.sics.tasim.tac03.aw.RFQStore;

public abstract class SCMAgent
extends Agent {
    private static final Logger log = Logger.getLogger(SCMAgent.class.getName());
    private Object lock = new Object();
    private boolean isValidating = true;
    private StartInfo startInfo;
    private BOMBundle bomBundle;
    private ComponentCatalog catalog;
    private String factoryAddress;
    private int factoryCapacity;
    private int daysBeforeVoid;
    private boolean isInitialized;
    private int currentDate = 0;
    private boolean isAwaitingNewDay = false;
    private InventoryStatus currentInventory;
    private BankStatus currentBankStatus;
    private String customerAddress;
    private RFQBundle currentCustomerRFQs;
    private ArrayList customerOffers = new ArrayList();
    private OfferBundle customerOfferBundle;
    private OrderStore customerOrders = new OrderStore();
    private Hashtable supplierRFQTable = new Hashtable();
    private RFQStore supplierRFQs = new RFQStore(1);
    private Hashtable supplierOrderTable = new Hashtable();
    private OrderStore supplierOrders = new OrderStore(1);
    private ProductionSchedule productionSchedule;
    private DeliverySchedule deliverySchedule;
    private InventoryStatus nextDayInventory = new InventoryStatus();
    private ProductionSchedule lastDayProduction;
    private ArrayList supplierDeliveries = new ArrayList();
    private int freeFactoryCapacity = 0;

    protected final void simulationSetup() {
    }

    protected final void simulationFinished() {
        this.isInitialized = false;
        this.simulationEnded();
    }

    private void checkInitialized() {
        if (!this.isInitialized && this.bomBundle != null && this.catalog != null && this.startInfo != null && this.factoryAddress != null) {
            this.isInitialized = true;
            this.simulationStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceived(Message message) {
        Transportable transportable = message.getContent();
        if (this.isAwaitingNewDay) {
            this.isAwaitingNewDay = false;
            ++this.currentDate;
        }
        if (!this.isInitialized) {
            if (transportable instanceof ComponentCatalog) {
                this.catalog = (ComponentCatalog)transportable;
            } else if (transportable instanceof BOMBundle) {
                this.bomBundle = (BOMBundle)transportable;
            } else if (transportable instanceof StartInfo) {
                this.startInfo = (StartInfo)transportable;
                this.daysBeforeVoid = this.startInfo.getAttributeAsInt("customer.daysBeforeVoid", this.daysBeforeVoid);
                this.factoryAddress = this.startInfo.getAttribute("factory.address");
                this.factoryCapacity = this.startInfo.getAttributeAsInt("factory.capacity", 2000);
            } else if (transportable instanceof ActiveOrders) {
                Order order;
                int n;
                int n2;
                ActiveOrders activeOrders = (ActiveOrders)transportable;
                if (activeOrders.getCurrentDate() > this.currentDate) {
                    this.currentDate = activeOrders.getCurrentDate();
                }
                int n3 = 0;
                int n4 = 0;
                int n5 = activeOrders.getCustomerOrderCount();
                for (n2 = 0; n2 < n5; ++n2) {
                    n = activeOrders.getCustomerOrderID(n2);
                    if (this.customerOrders.getOrder(n) != null) continue;
                    order = new Order(activeOrders.getCustomerAddress(n2), n, activeOrders.getCustomerProductID(n2), activeOrders.getCustomerQuantity(n2), activeOrders.getCustomerUnitPrice(n2), activeOrders.getCustomerDueDate(n2), activeOrders.getCustomerPenalty(n2));
                    this.customerOrders.addOrder(order);
                    ++n3;
                }
                n5 = activeOrders.getSupplierOrderCount();
                for (n2 = 0; n2 < n5; ++n2) {
                    n = activeOrders.getSupplierOrderID(n2);
                    if (this.supplierOrders.getOrder(n) != null) continue;
                    order = new Order(activeOrders.getSupplierAddress(n2), n, activeOrders.getSupplierProductID(n2), activeOrders.getSupplierQuantity(n2), activeOrders.getSupplierUnitPrice(n2), activeOrders.getSupplierDueDate(n2), activeOrders.getSupplierPenalty(n2));
                    this.supplierOrders.addOrder(order);
                    ++n4;
                }
                if (n3 > 0 || n4 > 0) {
                    log.warning("restored " + n3 + " active customer orders and " + n4 + " supplier orders");
                }
            } else {
                log.warning("ignoring message '" + transportable.getTransportName() + "' when awaiting initialization");
            }
            this.checkInitialized();
        } else if (transportable instanceof OfferBundle) {
            OfferBundle offerBundle = (OfferBundle)transportable;
            this.handleSupplierOffers(message.getSender(), offerBundle);
        } else if (transportable instanceof RFQBundle) {
            RFQBundle rFQBundle = (RFQBundle)transportable;
            this.customerAddress = message.getSender();
            this.customerOfferBundle = null;
            this.currentCustomerRFQs = rFQBundle;
            this.handleCustomerRFQs(rFQBundle);
        } else if (transportable instanceof OrderBundle) {
            OrderBundle orderBundle = (OrderBundle)transportable;
            Order[] orderArray = this.addCustomerOrders(orderBundle);
            if (orderArray != null) {
                this.handleCustomerOrders(orderArray);
            }
        } else if (transportable instanceof DeliveryNotice) {
            DeliveryNotice deliveryNotice = (DeliveryNotice)transportable;
            Object object = this.lock;
            synchronized (object) {
                int n = deliveryNotice.size();
                for (int i = 0; i < n; ++i) {
                    Order order = this.supplierOrders.getOrder(deliveryNotice.getOrderID(i));
                    if (order != null) {
                        order.setDelivered();
                        continue;
                    }
                    log.warning("received delivery of unknown order " + deliveryNotice.getOrderID(i));
                }
                this.supplierDeliveries.add(deliveryNotice);
            }
            this.handleSupplierDelivery(deliveryNotice);
        } else if (transportable instanceof FactoryStatus) {
            FactoryStatus factoryStatus = (FactoryStatus)transportable;
            this.currentInventory = factoryStatus;
            this.handleFactoryStatus(factoryStatus);
        } else if (transportable instanceof BankStatus) {
            BankStatus bankStatus;
            this.currentBankStatus = bankStatus = (BankStatus)transportable;
            this.handleBankStatus(bankStatus);
        } else if (transportable instanceof SimulationStatus) {
            SimulationStatus simulationStatus = (SimulationStatus)transportable;
            this.currentDate = simulationStatus.getCurrentDate();
            Object object = this.lock;
            synchronized (object) {
                int n;
                int n6;
                this.nextDayInventory = new InventoryStatus(this.currentInventory);
                if (this.supplierDeliveries.size() > 0) {
                    n6 = this.supplierDeliveries.size();
                    for (n = 0; n < n6; ++n) {
                        DeliveryNotice deliveryNotice = (DeliveryNotice)this.supplierDeliveries.get(n);
                        int n7 = deliveryNotice.size();
                        for (int i = 0; i < n7; ++i) {
                            this.nextDayInventory.addInventory(deliveryNotice.getProductID(i), deliveryNotice.getQuantity(i));
                        }
                    }
                    this.supplierDeliveries.clear();
                }
                if (this.lastDayProduction != null) {
                    n6 = this.lastDayProduction.size();
                    for (n = 0; n < n6; ++n) {
                        this.nextDayInventory.addInventory(this.lastDayProduction.getProductID(n), this.lastDayProduction.getQuantity(n));
                    }
                    this.lastDayProduction = null;
                }
                this.freeFactoryCapacity = this.factoryCapacity;
            }
            this.isAwaitingNewDay = true;
            this.handleSimulationStatus(simulationStatus);
        } else if (transportable instanceof PriceReport) {
            this.handlePriceReport((PriceReport)transportable);
        } else if (transportable instanceof MarketReport) {
            this.handleMarketReport((MarketReport)transportable);
        } else {
            log.warning("ignoring unhandled message '" + transportable.getTransportName() + '\'');
        }
    }

    protected StartInfo getStartInfo() {
        return this.startInfo;
    }

    protected BOMBundle getBOMBundle() {
        return this.bomBundle;
    }

    protected ComponentCatalog getComponentCatalog() {
        return this.catalog;
    }

    protected String getFactoryAddress() {
        return this.factoryAddress;
    }

    protected int getFactoryCapacity() {
        return this.factoryCapacity;
    }

    protected int getDaysBeforeVoid() {
        return this.daysBeforeVoid;
    }

    protected int getCurrentDate() {
        return this.currentDate;
    }

    protected BankStatus getCurrentBankStatus() {
        return this.currentBankStatus;
    }

    protected InventoryStatus getCurrentInventory() {
        return this.currentInventory;
    }

    protected InventoryStatus getInventoryForNextDay() {
        return this.nextDayInventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reserveInventoryForNextDay(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.nextDayInventory.getInventoryQuantity(n);
            if (n2 < 0) {
                throw new IllegalArgumentException("can not add to inventory");
            }
            if (n2 > n3) {
                throw new IllegalArgumentException("can not reserve more than exists in inventory: " + n2 + '>' + n3);
            }
            this.nextDayInventory.addInventory(n, -n2);
        }
    }

    protected int getFreeFactoryCapacityForNextDay() {
        return this.freeFactoryCapacity;
    }

    protected RFQBundle getCustomerRFQs() {
        return this.currentCustomerRFQs;
    }

    protected OrderStore getCustomerOrders() {
        return this.customerOrders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addCustomerOffer(RFQBundle rFQBundle, int n, int n2) {
        if (this.customerAddress == null) {
            throw new IllegalStateException("no customer RFQ received");
        }
        Object object = this.lock;
        synchronized (object) {
            OfferBundle offerBundle = this.customerOfferBundle;
            if (offerBundle == null) {
                offerBundle = this.customerOfferBundle = new OfferBundle();
            }
            int n3 = this.customerOffers.size();
            Order order = new Order(this.customerAddress, n3, rFQBundle, n, n2);
            this.customerOffers.add(order);
            offerBundle.addOffer(n3, rFQBundle, n, n2);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCustomerOffers() {
        OfferBundle offerBundle;
        Object object = this.lock;
        synchronized (object) {
            offerBundle = this.customerOfferBundle;
            this.customerOfferBundle = null;
        }
        if (offerBundle != null && offerBundle.size() > 0) {
            this.sendMessage(this.customerAddress, offerBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Order[] addCustomerOrders(OrderBundle orderBundle) {
        Object object = this.lock;
        synchronized (object) {
            Object[] objectArray = new Order[orderBundle.size()];
            int n = 0;
            int n2 = orderBundle.size();
            for (int i = 0; i < n2; ++i) {
                Order order;
                int n3 = orderBundle.getOrderID(i);
                int n4 = orderBundle.getOfferID(i);
                if (n4 >= this.customerOffers.size() || (order = (Order)this.customerOffers.get(n4)).isOrdered()) {
                    log.severe("illegal customer order " + n3 + " for offer " + n4);
                    continue;
                }
                order.setOrdered(n3);
                this.customerOrders.addOrder(order);
                objectArray[n++] = order;
            }
            if (n < objectArray.length) {
                objectArray = (Order[])ArrayUtils.setSize(objectArray, n);
            }
            return objectArray;
        }
    }

    protected RFQStore getSupplierRFQs() {
        return this.supplierRFQs;
    }

    protected OrderStore getSupplierOrders() {
        return this.supplierOrders;
    }

    protected int addSupplierRFQ(String string, int n, int n2, int n3) {
        return this.addSupplierRFQ(string, n, n2, 0, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addSupplierRFQ(String string, int n, int n2, int n3, int n4) {
        Object object = this.lock;
        synchronized (object) {
            int n5 = this.supplierRFQs.addRFQ(string, n, n2, n4, this.currentDate);
            RFQBundle rFQBundle = (RFQBundle)this.supplierRFQTable.get(string);
            if (rFQBundle == null) {
                rFQBundle = new RFQBundle();
                this.supplierRFQTable.put(string, rFQBundle);
            }
            rFQBundle.addRFQ(n5, n, n2, n3, n4, 0);
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSupplierRFQs() {
        if (this.supplierRFQTable.size() > 0) {
            Hashtable hashtable = this.supplierRFQTable;
            synchronized (hashtable) {
                Enumeration enumeration = this.supplierRFQTable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    RFQBundle rFQBundle = (RFQBundle)this.supplierRFQTable.get(string);
                    this.sendMessage(string, rFQBundle);
                }
                this.supplierRFQTable.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Order addSupplierOrder(String string, OfferBundle offerBundle, int n) {
        Object object = this.lock;
        synchronized (object) {
            int n2 = offerBundle.getRFQID(n);
            int n3 = this.supplierRFQs.getProductID(n2);
            Order order = this.supplierOrders.createOrder(string, offerBundle, n, n3);
            int n4 = order.getOrderID();
            OrderBundle orderBundle = (OrderBundle)this.supplierOrderTable.get(string);
            if (orderBundle == null) {
                orderBundle = new OrderBundle();
                this.supplierOrderTable.put(string, orderBundle);
            }
            orderBundle.addOrder(n4, offerBundle.getOfferID(n));
            return order;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSupplierOrders() {
        if (this.supplierOrderTable.size() > 0) {
            Hashtable hashtable = this.supplierOrderTable;
            synchronized (hashtable) {
                Enumeration enumeration = this.supplierOrderTable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    OrderBundle orderBundle = (OrderBundle)this.supplierOrderTable.get(string);
                    this.sendMessage(string, orderBundle);
                }
                this.supplierOrderTable.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addDeliveryRequest(Order order) {
        Object object = this.lock;
        synchronized (object) {
            int n = order.getProductID();
            int n2 = order.getQuantity();
            if (this.nextDayInventory.getInventoryQuantity(n) < n2) {
                return false;
            }
            DeliverySchedule deliverySchedule = this.deliverySchedule;
            if (deliverySchedule == null) {
                deliverySchedule = this.deliverySchedule = new DeliverySchedule();
            }
            deliverySchedule.addDelivery(n, n2, order.getOrderID(), order.getOtherAgent());
            this.nextDayInventory.addInventory(n, -n2);
            order.setDelivered();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addProductionRequest(int n, int n2) {
        int n3 = this.bomBundle.getIndexFor(n);
        if (n3 < 0) {
            throw new IllegalArgumentException("product " + n + " was not found in the BOM");
        }
        int n4 = this.bomBundle.getAssemblyCyclesRequired(n3);
        if (n4 <= 0) {
            throw new IllegalArgumentException("no assembly cycle specification for product " + n + " was found in the BOM");
        }
        int[] nArray = this.bomBundle.getComponents(n3);
        if (nArray == null) {
            throw new IllegalArgumentException("no components for product " + n + " was found in the BOM");
        }
        Object object = this.lock;
        synchronized (object) {
            if (n2 * n4 > this.freeFactoryCapacity) {
                return false;
            }
            if (!this.hasAvailableComponents(nArray, n2, this.nextDayInventory)) {
                return false;
            }
            this.freeFactoryCapacity -= n2 * n4;
            int n5 = nArray.length;
            for (int i = 0; i < n5; ++i) {
                this.nextDayInventory.addInventory(nArray[i], -n2);
            }
            ProductionSchedule productionSchedule = this.productionSchedule;
            if (productionSchedule == null) {
                productionSchedule = this.productionSchedule = new ProductionSchedule();
            }
            productionSchedule.addProduction(n, n2);
            return true;
        }
    }

    private boolean hasAvailableComponents(int[] nArray, int n, InventoryStatus inventoryStatus) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (inventoryStatus.getInventoryQuantity(nArray[i]) >= n) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFactorySchedules() {
        DeliverySchedule deliverySchedule;
        ProductionSchedule productionSchedule;
        Object object = this.lock;
        synchronized (object) {
            productionSchedule = this.productionSchedule;
            if (productionSchedule != null) {
                if (this.lastDayProduction != null) {
                    throw new IllegalStateException("schedules for next day already sent to factory");
                }
                this.lastDayProduction = productionSchedule;
                this.productionSchedule = null;
            }
            deliverySchedule = this.deliverySchedule;
            this.deliverySchedule = null;
        }
        if (productionSchedule != null) {
            this.sendMessage(this.factoryAddress, productionSchedule);
        }
        if (deliverySchedule != null) {
            this.sendMessage(this.factoryAddress, deliverySchedule);
        }
    }

    protected void sendAll() {
        this.sendSupplierRFQs();
        this.sendSupplierOrders();
        this.sendFactorySchedules();
        this.sendCustomerOffers();
    }

    protected abstract void simulationStarted();

    protected abstract void simulationEnded();

    protected abstract void handleCustomerRFQs(RFQBundle var1);

    protected abstract void handleCustomerOrders(Order[] var1);

    protected abstract void handleSupplierOffers(String var1, OfferBundle var2);

    protected void handleSupplierDelivery(DeliveryNotice deliveryNotice) {
    }

    protected void handleFactoryStatus(FactoryStatus factoryStatus) {
    }

    protected void handleBankStatus(BankStatus bankStatus) {
    }

    protected void handlePriceReport(PriceReport priceReport) {
    }

    protected void handleMarketReport(MarketReport marketReport) {
    }

    protected abstract void handleSimulationStatus(SimulationStatus var1);
}

