import java.util.*;

/**
 * Stores information about the agent, including information shared between
 * the supply and demand managers.
 */
public class AgentInfo{

	/**stores parameters read in from the config file*/
	public Hashtable agentParameters = new Hashtable(); 
	
	private int lastID = 0; //unique ID for orders, offers, and RFQs
	private int date;
	
	/** all of the information about components is stored here*/
	public ComponentInfo components; 
	/** all of the information about computers is stored here*/
	public ComputerInfo computers; 
	/** all the market reports that have been received*/
	public Vector marketReports = new Vector(); 
		
	//Information to be shared between managers.
	//Stored here due to the fact that the ComponentInfo and ComputerInfo objects
	//shouldn't be updated during the day, while this information might be.
	
	/** computers in inventory available for use tomorrow*/
	public int tomorrowsRemainingComputers[]; 
	/** components in inventory available for use tomorrow*/
	public int tomorrowsRemainingComponents[]; //today's inventory minus amount used
	/** deliveries resulting from today's accepted offers */
	public int[][] newComponentDeliveries; 
	/**projected number of components to be used each day in the future */
	public double[][] projectedComponentUse = new double[10][220]; 
	
	private synchronized int generateNextID() {
		return lastID++;
	}

	/**
	 * Generates a unique ID for an RFQ, offer, or order. 
	 * @return ID
	 */
	public int getNextID() {
		return generateNextID();
	}

	/**
	 * Generates a summary of the day's events.
	 * 
	 * @return summary string
	 */
	public String getDailySummary(){
		return components.getDailySummary(date) + computers.getDailySummary(date);
	}

	/**
	 * Processes the messages received at the beginning of each day.
	 * 
	 * @param dayInfo  messages received today
	 * @param settings  the game settings
	 */
	public void morningUpdate(DailyInfo dayInfo, GameSettings settings){
		date = dayInfo.date;
		
		//check if the components and computers objects have been created
		if (components == null)
			components = new ComponentInfo(settings);
		if (computers == null)	
			computers = new ComputerInfo(settings);
						
		date = dayInfo.date;
		components.morningUpdate(dayInfo);
		computers.morningUpdate(dayInfo);
		tomorrowsRemainingComponents = components.getTomorrowsInventoryCopy();
		tomorrowsRemainingComputers = computers.getTomorrowsInventoryCopy();		
		
		if (dayInfo.marketReport != null){
			marketReports.add(dayInfo.marketReport);
		}
	}

	/**
	 * Processes the messages (agent actions) sent out at the end of each day.
	 * @param actions the messages sent by the agent
	 */
	public void eveningUpdate(DailyActions actions){
		components.eveningUpdate(date, actions);
		computers.eveningUpdate(date, actions);
	}		
}
