import se.sics.tasim.props.*;
import java.io.*;

import javax.xml.parsers.*; 
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.dom.*;
import org.w3c.dom.*;

/**Stores the game parameters sent at the beginning of a game.
 */
public class GameSettings{
	public BOMBundle bom;
	public ComponentCatalog catalog;
	public String factoryName = "";
	public double debtInterestRate;
	public double depositInterestRate;
	public double storageCost;
	public int factoryCapacity;
	public int daysBeforeVoid;
	public int numberOfDays;
	public int secondsPerDay;
	public int simulationID;
	public String agentName;

	
	/**
	 * Summarizes the game parameters.
	 * 
	 *  @return  summary string
	 */
	public String toString(){
		StringBuffer buf = new StringBuffer();
		buf.append("\n---------------------\n");
		buf.append("Game settings:\n");
		buf.append("---------------------\n");
		buf.append("\tfactory address: " + factoryName + "\n");
		buf.append("\tfactory capacity: " + factoryCapacity + "\n");
		buf.append("\tdebt interest rate: " + debtInterestRate + "\n");
		buf.append("\tdeposit interest rate: " + depositInterestRate + "\n");
		buf.append("\tstorage cost: " + storageCost + "\n");
		buf.append("\tdays before orders are void: " + daysBeforeVoid + "\n");
		buf.append("\tnumber of days: " + numberOfDays + "\n");
		buf.append("\tseconds per day: " + secondsPerDay + "\n\n");
		

		if (bom != null){
			buf.append("---------------------\n");
			buf.append("Bill of materials:\n");
			buf.append("---------------------\n");
			for(int i = 0, n = bom.size(); i < n; i++){
				buf.append("\tProduct " + bom.getProductID(i) + " requires parts ");
		 		int[] partlist =bom.getComponents(i);
				for(int j = 0; j < partlist.length; j++){
					if (j != 0)
						buf.append(", ");
					buf.append(partlist[j]);
				}
				buf.append(" and takes " + bom.getAssemblyCyclesRequired(i)
					+ " cycles to assemble.\n");
			}
		}
		
		if (catalog != null){
			buf.append("---------------------\n");
			buf.append("Catalog (Part; ID; Base Price; Suppliers):\n");
			buf.append("---------------------\n");
			for(int i = 0, n = catalog.size(); i < n; i++){
				buf.append("\t" + catalog.getProductName(i) + "; " + catalog.getProductID(i)
					+ catalog.getProductBasePrice(i) + "; ");
				String[] s = catalog.getSuppliers(i);
				for(int j = 0; j < s.length; j++){
					if (j != 0)
						buf.append(", ");
					buf.append(s[j]);
				}
				buf.append("\n");	
			}
		}
		
		return buf.toString();
	}

	public void writeToXMLFile(String fileName){
		Document document;
		try {
			//create a new document
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.newDocument();

			Element root = document.createElement("gameSettings"); 
			document.appendChild(root);
			root.setAttribute("factoryAddress", factoryName);
			root.setAttribute("factoryCapacity", "" + factoryCapacity);
			root.setAttribute("depositInterestRate", "" + depositInterestRate);
			root.setAttribute("debtInterestRate", "" + debtInterestRate);
			root.setAttribute("storageCost", "" + storageCost);
			root.setAttribute("daysBeforeOrdersAreVoid", "" + daysBeforeVoid);
			root.setAttribute("numberOfDays", "" + numberOfDays);
			root.setAttribute("secondsPerDay", "" + secondsPerDay);			
			
			if (bom != null){
				Element eltBOM = document.createElement("billOfMaterials");
				root.appendChild(eltBOM);					
				for(int i = 0, n = bom.size(); i < n; i++){
					Element eltProduct = document.createElement("product");
					eltProduct.setAttribute("id", "" + bom.getProductID(i));
					eltBOM.appendChild(eltProduct);
					eltProduct.setAttribute("assemblyCycles", "" + bom.getAssemblyCyclesRequired(i));
					int[] partlist = bom.getComponents(i);
					for(int j = 0; j < partlist.length; j++){
						Element eltPart = document.createElement("part");
						eltProduct.appendChild(eltPart);
						eltPart.setAttribute("id", "" + partlist[j]);
					}
				}
			}

			if (catalog != null){
				Element eltCatalog = document.createElement("catalog");
				root.appendChild(eltCatalog);					
			 	for(int i = 0, n = catalog.size(); i < n; i++){
					Element eltPart = document.createElement("part");
					eltCatalog.appendChild(eltPart);
					eltPart.setAttribute("name", catalog.getProductName(i));
					eltPart.setAttribute("id", "" + catalog.getProductID(i));
					eltPart.setAttribute("basePrice", "" + catalog.getProductBasePrice(i));
					String[] s = catalog.getSuppliers(i);
					for(int j = 0; j < s.length; j++){
						Element eltSupplier = document.createElement("supplier");
						eltPart.appendChild(eltSupplier);
						eltSupplier.setAttribute("name", s[j]);
					}
				}
			}

			File file = new File(fileName);
			Result result = new StreamResult(file);
			// Write the DOM document to the file
			DOMSource source = new DOMSource(document.getDocumentElement());
			Transformer xformer = TransformerFactory.newInstance().newTransformer();
			xformer.transform(source, result);
		} catch (Exception ex) { ex.printStackTrace(); }
	}
	
	public void readFromXMLFile(String fileName){
		bom = new BOMBundle();
		catalog = new ComponentCatalog();
		
		try {
			Document document;
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.parse(new File(fileName));
			
			Element root = document.getDocumentElement();
			factoryName = root.getAttribute("factoryAddress");
			factoryCapacity = Integer.parseInt(root.getAttribute("factoryCapacity"));
			debtInterestRate = Float.parseFloat(root.getAttribute("debtInterestRate"));
			depositInterestRate = Float.parseFloat(root.getAttribute("depositInterestRate"));
			storageCost = Float.parseFloat(root.getAttribute("storageCost"));
			daysBeforeVoid = Integer.parseInt(root.getAttribute("daysBeforeOrdersAreVoid"));
			numberOfDays = Integer.parseInt(root.getAttribute("numberOfDays"));
			secondsPerDay = Integer.parseInt(root.getAttribute("secondsPerDay"));			
			
			NodeList nodes = root.getChildNodes();
			for (int n = 0; n < nodes.getLength(); n++) {
				Element e = (Element) nodes.item(n);
				if (e.getTagName() == "billOfMaterials"){
					NodeList products = e.getChildNodes();
					for(int i = 0; i < products.getLength(); i++){
						Element eltProduct = (Element) products.item(i);
						int id = Integer.parseInt(eltProduct.getAttribute("id"));
						int cycles = Integer.parseInt(eltProduct.getAttribute("assemblyCycles"));
						NodeList parts = eltProduct.getChildNodes();
						int[] partlist = new int[parts.getLength()];
						for(int j = 0; j < parts.getLength(); j++){
							partlist[j] = Integer.parseInt(((Element) parts.item(j)).getAttribute("id"));
						}
						bom.addBOM(id, cycles, partlist);
					}						
				}
				
				//note: this isn't very clean, but it's the best that can be done with the 
				//methods for setting ComponentCatalog attributes
				else if (e.getTagName() == "catalog"){
					NodeList parts = e.getChildNodes();
					for(int i = 0; i < parts.getLength(); i++){
						Element eltPart = (Element) parts.item(i);
						String partName = eltPart.getAttribute("name");
						int price = Integer.parseInt(eltPart.getAttribute("basePrice"));
						int[] partList = new int[1];
						partList[0] = Integer.parseInt(eltPart.getAttribute("id"));
						NodeList suppliers = eltPart.getChildNodes();
						for(int j = 0; j < suppliers.getLength(); j++){
							String supplierName = ((Element) suppliers.item(j)).getAttribute("name");
							catalog.addSupplier(supplierName, partList);
						}
						catalog.setProductName(i, partName);
				 		catalog.setProductBasePrice(i, price);
					}
				}							
			}
 		} catch (Exception ex) { ex.printStackTrace(); }
	}
}
