/**Stores an offer from a supplier or manufacturer.  If it is from
 * a supplier, there may be two alternatives: relaxed quantity and relaxed due
 * date.  If there is no alternative offer, the alternative reference is null.
 */


public class OfferInfo {
	public int productID, offerID, quantity, price, dueDate;
	public String name; //the supplier/customer name
	public OfferInfo alternative; 	//the alternative offer (if any) 
	public RFQInfo rfq; //the rfq that this offer is in response to
	public int index; //the index of the component/computer in the arrays used in the ComputerInfo/ComponentInfo class
	public boolean ordered = false;
	
	public OfferInfo(){};
	
	/**
	 * 
	 * @param offerID  ID number
	 * @param quantity  quantity offeres
	 * @param dueDate  delivery date
	 * @param price  price per unit
	 * @param rfq  RFQInfo object for the corresponding RFQ
	 * @param index  product index (not ID)
	 */
	public OfferInfo(int offerID, int quantity, int dueDate, int price, RFQInfo rfq, int index){
		this.productID = rfq.productID;
		this.offerID = offerID;
		this.quantity = quantity;
		this.price = price;
		if (dueDate > 219)
			dueDate = 219;
		this.dueDate = dueDate;
		this.rfq = rfq;
		this.name = rfq.name;
		this.index = index;
		this.alternative = null; 
	}
}
