/**
 * Stores a single RFQ, either for a manufacturer or a supplier.
 */

public class RFQInfo{
	public int rfqID, quantity, productID, dueDate, reservePrice, penalty;
	public String name; //who sent/received the RFQ 
	public int receivedDate; //when the RFQ was received - not usually needed
	
	public RFQInfo(){};
	
	/**
	 * 
	 * @param rfqID  the ID number
	 * @param productID  the product requested
	 * @param quantity  quantity requested
	 * @param dueDate  date due
	 * @param reservePrice  reserve price per unit
	 * @param penalty  penalty per day late
	 * @param name  recipient of the RFQ
	 */
	public RFQInfo(int rfqID, int productID, int quantity, int dueDate,	int reservePrice, 
			int penalty, String name){
		this.rfqID = rfqID;
		this.quantity = quantity;
		this.productID = productID;
		this.dueDate = dueDate;
		this.reservePrice = reservePrice;
		this.penalty = penalty;
		this.name = name;
	}
	
}
