/*
 * Decompiled with CFR 0.152.
 */
package aim4.config;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javafx.util.Pair;

public final class Constants {
    public static final NumberFormat ZERO_DEC = new DecimalFormat("#");
    public static final NumberFormat ONE_DEC = new DecimalFormat("#.0");
    public static final NumberFormat TWO_DEC = new DecimalFormat("#.00");
    public static final NumberFormat TEN_DEC = new DecimalFormat("#.0000000000");
    public static final int numOfSecondPerHour = 3600;
    public static final NumberFormat LEADING_ZEROES = new DecimalFormat("00000000");
    public static final int INTEGER_SIZE = 32;
    public static final int DOUBLE_SIZE = 64;
    public static final int BOOLEAN_SIZE = 1;
    public static final int ENUM_SIZE = 8;
    public static final int BITS_PER_BYTE = 8;
    public static final int BYTES_PER_KB = 1024;
    public static final int BITS_PER_KB = 8192;
    public static final int BYTES_PER_MB = 0x100000;
    public static final double DOUBLE_EQUAL_PRECISION = 1.0E-10;
    public static final double DOUBLE_EQUAL_WEAK_PRECISION = 1.0E-6;
    private static final Map<Pair<Double, Double>, Double> MAP_VELOCITY_TO_EDGE_TILE_TIME_BUFFER = Constants.mapVelocityToEdgeTileTimeBuffer();
    private static final Map<Pair<Double, Double>, Double> MAP_VELOCITY_TO_MINIMUM_FOLLOWING_DISTANCES = Constants.mapVelocityToMinimumFollowingDistances();

    private static final Map<Pair<Double, Double>, Double> mapVelocityToEdgeTileTimeBuffer() {
        HashMap<Pair<Double, Double>, Double> mapVelocityToEdgeTileTimeBuffer = new HashMap<Pair<Double, Double>, Double>();
        mapVelocityToEdgeTileTimeBuffer.put(new Pair((Object)0.0, (Object)15.0), 0.3);
        mapVelocityToEdgeTileTimeBuffer.put(new Pair((Object)15.0, (Object)30.0), 0.5);
        mapVelocityToEdgeTileTimeBuffer.put(new Pair((Object)30.0, (Object)45.0), 0.7);
        mapVelocityToEdgeTileTimeBuffer.put(new Pair((Object)45.0, (Object)55.0), 0.9);
        mapVelocityToEdgeTileTimeBuffer.put(new Pair((Object)55.0, (Object)65.0), 1.1);
        mapVelocityToEdgeTileTimeBuffer.put(new Pair((Object)65.0, (Object)75.0), 1.3);
        mapVelocityToEdgeTileTimeBuffer.put(new Pair((Object)75.0, (Object)80.0), 1.5);
        return mapVelocityToEdgeTileTimeBuffer;
    }

    public static double getEdgeTileTimeBufferBasedOnVelocity(double velocity) throws Exception {
        for (Pair<Double, Double> velocityRanges : MAP_VELOCITY_TO_EDGE_TILE_TIME_BUFFER.keySet()) {
            if (!((Double)velocityRanges.getKey() <= velocity) || !(velocity <= (Double)velocityRanges.getValue())) continue;
            return MAP_VELOCITY_TO_EDGE_TILE_TIME_BUFFER.get(velocityRanges);
        }
        throw new RuntimeException(String.format("No edge tile time buffer size value could be found for the given velocity of %f.", velocity));
    }

    private static Map<Pair<Double, Double>, Double> mapVelocityToMinimumFollowingDistances() {
        HashMap<Pair<Double, Double>, Double> mapVelocityToMinimumFollowingDistances = new HashMap<Pair<Double, Double>, Double>();
        mapVelocityToMinimumFollowingDistances.put(new Pair((Object)0.0, (Object)15.0), 0.5);
        mapVelocityToMinimumFollowingDistances.put(new Pair((Object)15.0, (Object)30.0), 0.6);
        mapVelocityToMinimumFollowingDistances.put(new Pair((Object)30.0, (Object)45.0), 0.9);
        mapVelocityToMinimumFollowingDistances.put(new Pair((Object)45.0, (Object)55.0), 1.1);
        mapVelocityToMinimumFollowingDistances.put(new Pair((Object)55.0, (Object)65.0), 1.2);
        mapVelocityToMinimumFollowingDistances.put(new Pair((Object)65.0, (Object)75.0), 1.3);
        mapVelocityToMinimumFollowingDistances.put(new Pair((Object)75.0, (Object)80.0), 1.5);
        return mapVelocityToMinimumFollowingDistances;
    }

    public static double getMinimumFollowingDistanceBasedOnVelocity(double velocity) throws Exception {
        for (Pair<Double, Double> velocityRanges : MAP_VELOCITY_TO_MINIMUM_FOLLOWING_DISTANCES.keySet()) {
            if (!((Double)velocityRanges.getKey() <= velocity) || !(velocity <= (Double)velocityRanges.getValue())) continue;
            return MAP_VELOCITY_TO_MINIMUM_FOLLOWING_DISTANCES.get(velocityRanges);
        }
        throw new RuntimeException(String.format("No value for minimum following distances could be found for the given velocity of %f.", velocity));
    }

    public static enum LightStatus {
        GREEN,
        YELLOW,
        RED;

    }

    public static enum TurnDirection {
        LEFT,
        RIGHT,
        STRAIGHT,
        U_TURN;

    }

    public static enum CardinalDirection {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

