/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver;

import aim4.config.Debug;
import aim4.config.DebugPoint;
import aim4.driver.DriverSimView;
import aim4.im.IntersectionManager;
import aim4.map.Road;
import aim4.map.SpawnPoint;
import aim4.map.lane.Lane;
import aim4.util.GeomMath;
import aim4.vehicle.AutoVehicleDriverView;
import aim4.vehicle.VehicleDriverView;
import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Driver
implements DriverSimView {
    private static final double MAX_INTERVAL_DISPLAY_DIST = 40.0;
    protected Lane currentLane;
    protected Set<Lane> currentlyOccupiedLanes;
    private SpawnPoint spawnPoint;
    private Road destination;

    @Override
    public void act() {
        AutoVehicleDriverView autoVehicle;
        if (Debug.isTargetVIN(this.getVehicle().getVIN()) && this.getVehicle() instanceof AutoVehicleDriverView && (autoVehicle = (AutoVehicleDriverView)this.getVehicle()).getIntervalometer().read() < 40.0) {
            Debug.addShortTermDebugPoint(new DebugPoint(GeomMath.polarAdd(autoVehicle.gaugePosition(), autoVehicle.getIntervalometer().read(), autoVehicle.gaugeHeading()), autoVehicle.gaugePosition(), "follow", Color.BLUE.brighter()));
        }
    }

    @Override
    public abstract VehicleDriverView getVehicle();

    @Override
    public SpawnPoint getSpawnPoint() {
        if (this.spawnPoint == null) {
            throw new RuntimeException("Driver is without origin!");
        }
        return this.spawnPoint;
    }

    @Override
    public void setSpawnPoint(SpawnPoint spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public Road getDestination() {
        if (this.destination == null) {
            throw new RuntimeException("Driver is without destination!");
        }
        return this.destination;
    }

    @Override
    public void setDestination(Road destination) {
        this.destination = destination;
    }

    @Override
    public Lane getCurrentLane() {
        return this.currentLane;
    }

    @Override
    public void setCurrentLane(Lane lane) {
        this.currentLane = lane;
        this.currentlyOccupiedLanes = new HashSet<Lane>(1);
        this.currentlyOccupiedLanes.add(lane);
    }

    @Override
    public Set<Lane> getCurrentlyOccupiedLanes() {
        return Collections.unmodifiableSet(this.currentlyOccupiedLanes);
    }

    public void addCurrentlyOccupiedLane(Lane lane) {
        this.currentlyOccupiedLanes.add(lane);
    }

    protected IntersectionManager nextIntersectionManager() {
        return this.getCurrentLane().getLaneIM().nextIntersectionManager(this.getVehicle().gaugePosition());
    }

    protected double distanceToNextIntersection() {
        return this.getCurrentLane().getLaneIM().distanceToNextIntersection(this.getVehicle().gaugePosition());
    }

    protected double distanceFromPrevIntersection() {
        double d = this.getCurrentLane().getLaneIM().distanceFromPrevIntersection(this.getVehicle().gaugePosition());
        return Math.max(0.0, d - this.getVehicle().getSpec().getLength());
    }
}

