/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver.coordinator;

import aim4.driver.coordinator.ArrivalEstimationException;
import aim4.driver.coordinator.ArrivalEstimationResult;
import aim4.util.Util;
import aim4.vehicle.AccelSchedule;

public class VelocityFirstArrivalEstimation {
    private static final boolean isDebugging = true;

    public static ArrivalEstimationResult estimate(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel) throws ArrivalEstimationException {
        assert (0.0 <= v1);
        assert (0.0 < accel && decel < 0.0);
        assert (Util.isDoubleEqualOrLess(v1, vTop));
        assert (vEndMax <= vTop);
        ArrivalEstimationResult result = null;
        if (dTotal > 0.0) {
            result = vEndMax < vTop ? (v1 < vTop ? (v1 > vEndMax ? VelocityFirstArrivalEstimation.estimateForCase6(time1, v1, dTotal, vTop, vEndMax, accel, decel) : (v1 < vEndMax ? VelocityFirstArrivalEstimation.estimateForCase5(time1, v1, dTotal, vTop, vEndMax, accel, decel) : VelocityFirstArrivalEstimation.estimateForCase4(time1, v1, dTotal, vTop, vEndMax, accel, decel))) : VelocityFirstArrivalEstimation.estimateForCase3(time1, v1, dTotal, vTop, vEndMax, accel, decel)) : (v1 < vTop ? VelocityFirstArrivalEstimation.estimateForCase2(time1, v1, dTotal, vTop, vEndMax, accel, decel) : VelocityFirstArrivalEstimation.estimateForCase1(time1, v1, dTotal, vTop, vEndMax, accel, decel));
        } else {
            if (v1 <= vEndMax) {
                AccelSchedule ap = new AccelSchedule();
                ap.add(time1, 0.0);
                return new ArrivalEstimationResult(time1, v1, ap);
            }
            throw new ArrivalEstimationException("Arrival estimation failed: distance is zero and the current velocity is larger than the maximum final velocity");
        }
        assert (VelocityFirstArrivalEstimation.isResultValid(time1, v1, dTotal, vTop, vEndMax, accel, decel, result));
        return result;
    }

    private static ArrivalEstimationResult estimateForCase1(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel) throws ArrivalEstimationException {
        double tTotal = dTotal / vEndMax;
        AccelSchedule ap = new AccelSchedule();
        ap.add(time1, 0.0);
        ap.add(time1 + tTotal, 0.0);
        return new ArrivalEstimationResult(time1 + tTotal, vEndMax, ap);
    }

    private static ArrivalEstimationResult estimateForCase2(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel) throws ArrivalEstimationException {
        double t1 = (vTop - v1) / accel;
        double d1 = t1 * (vTop + v1) / 2.0;
        if (d1 < dTotal) {
            double d2 = dTotal - d1;
            double t2 = d2 / vTop;
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1, 0.0);
            ap.add(time1 + t1 + t2, 0.0);
            return new ArrivalEstimationResult(time1 + t1 + t2, vEndMax, ap);
        }
        if (Util.isDoubleEqual(d1, dTotal)) {
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1, 0.0);
            return new ArrivalEstimationResult(time1 + t1, vEndMax, ap);
        }
        return VelocityFirstArrivalEstimation.estimateMaxVEndForCase2AndCase5(time1, v1, dTotal, vTop, vEndMax, accel);
    }

    private static ArrivalEstimationResult estimateForCase3(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel) throws ArrivalEstimationException {
        double t2 = (vEndMax - vTop) / decel;
        double d2 = t2 * (vEndMax + vTop) / 2.0;
        if (d2 < dTotal) {
            double d1 = dTotal - d2;
            double t1 = d1 / vTop;
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, 0.0);
            ap.add(time1 + t1, decel);
            ap.add(time1 + t1 + t2, 0.0);
            return new ArrivalEstimationResult(time1 + t1 + t2, vEndMax, ap);
        }
        if (Util.isDoubleEqual(d2, dTotal)) {
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, 0.0);
            ap.add(time1 + t2, decel);
            return new ArrivalEstimationResult(time1 + t2, vEndMax, ap);
        }
        throw new ArrivalEstimationException("Arrival estimation failed: distance too small (Case 3)");
    }

    private static ArrivalEstimationResult estimateForCase4(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel) throws ArrivalEstimationException {
        double t1 = (vTop - v1) / accel;
        double d1 = t1 * (vTop + v1) / 2.0;
        double t3 = (vEndMax - vTop) / decel;
        double d3 = t3 * (vEndMax + vTop) / 2.0;
        if (d1 + d3 < dTotal) {
            double d2 = dTotal - d1 - d3;
            double t2 = d2 / vTop;
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1, 0.0);
            ap.add(time1 + t1 + t2, decel);
            ap.add(time1 + t1 + t2 + t3, 0.0);
            return new ArrivalEstimationResult(time1 + t1 + t2 + t3, vEndMax, ap);
        }
        double delta = (accel * vEndMax * vEndMax - decel * v1 * v1 - 2.0 * accel * decel * dTotal) / (accel - decel);
        assert (delta >= 0.0);
        double v2 = Math.sqrt(delta);
        assert (v2 < vTop);
        assert (v1 <= v2);
        double t1x = (v2 - v1) / accel;
        double d1x = t1x * (v2 + v1) / 2.0;
        double t3x = (vEndMax - v2) / decel;
        double d3x = t3x * (vEndMax + v2) / 2.0;
        assert (d1x >= 0.0 && d3x >= 0.0);
        AccelSchedule ap = new AccelSchedule();
        ap.add(time1, accel);
        ap.add(time1 + t1x, decel);
        ap.add(time1 + t1x + t3x, 0.0);
        return new ArrivalEstimationResult(time1 + t1x + t3x, vEndMax, ap);
    }

    private static ArrivalEstimationResult estimateForCase5(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel) throws ArrivalEstimationException {
        double t1 = (vTop - v1) / accel;
        double d1 = t1 * (vTop + v1) / 2.0;
        double t3 = (vEndMax - vTop) / decel;
        double d3 = t3 * (vEndMax + vTop) / 2.0;
        if (d1 + d3 < dTotal) {
            double d2 = dTotal - d1 - d3;
            double t2 = d2 / vTop;
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1, 0.0);
            ap.add(time1 + t1 + t2, decel);
            ap.add(time1 + t1 + t2 + t3, 0.0);
            return new ArrivalEstimationResult(time1 + t1 + t2 + t3, vEndMax, ap);
        }
        double delta = (accel * vEndMax * vEndMax - decel * v1 * v1 - 2.0 * accel * decel * dTotal) / (accel - decel);
        assert (delta >= 0.0);
        double v2 = Math.sqrt(delta);
        assert (v2 < vTop);
        assert (v1 < v2);
        double t1x = (v2 - v1) / accel;
        double d1x = t1x * (v2 + v1) / 2.0;
        assert (d1x > 0.0);
        if (vEndMax < v2) {
            double t3x = (vEndMax - v2) / decel;
            double d3x = t3x * (vEndMax + v2) / 2.0;
            assert (d3x > 0.0);
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1x, decel);
            ap.add(time1 + t1x + t3x, 0.0);
            return new ArrivalEstimationResult(time1 + t1x + t3x, vEndMax, ap);
        }
        if (Util.isDoubleEqual(vEndMax, v2)) {
            assert (Util.isDoubleEqual(d1x, dTotal));
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1x, 0.0);
            return new ArrivalEstimationResult(time1 + t1x, vEndMax, ap);
        }
        return VelocityFirstArrivalEstimation.estimateMaxVEndForCase2AndCase5(time1, v1, dTotal, vTop, vEndMax, accel);
    }

    private static ArrivalEstimationResult estimateForCase6(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel) throws ArrivalEstimationException {
        double t1 = (vTop - v1) / accel;
        double d1 = t1 * (vTop + v1) / 2.0;
        double t3 = (vEndMax - vTop) / decel;
        double d3 = t3 * (vEndMax + vTop) / 2.0;
        if (d1 + d3 < dTotal) {
            double d2 = dTotal - d1 - d3;
            double t2 = d2 / vTop;
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1, 0.0);
            ap.add(time1 + t1 + t2, decel);
            ap.add(time1 + t1 + t2 + t3, 0.0);
            return new ArrivalEstimationResult(time1 + t1 + t2 + t3, vEndMax, ap);
        }
        double delta = (accel * vEndMax * vEndMax - decel * v1 * v1 - 2.0 * accel * decel * dTotal) / (accel - decel);
        assert (delta >= 0.0);
        double v2 = Math.sqrt(delta);
        assert (v2 < vTop);
        assert (vEndMax < v2);
        double t3x = (vEndMax - v2) / decel;
        double d3x = t3x * (vEndMax + v2) / 2.0;
        assert (d3x > 0.0);
        if (v1 < v2) {
            double t1x = (v2 - v1) / accel;
            double d1x = t1x * (v2 + v1) / 2.0;
            assert (d1x > 0.0);
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, accel);
            ap.add(time1 + t1x, decel);
            ap.add(time1 + t1x + t3x, 0.0);
            return new ArrivalEstimationResult(time1 + t1x + t3x, vEndMax, ap);
        }
        if (Util.isDoubleEqual(v1, v2)) {
            assert (Util.isDoubleEqual(d3x, dTotal, 1.0E-6));
            AccelSchedule ap = new AccelSchedule();
            ap.add(time1, decel);
            ap.add(time1 + t3x, 0.0);
            return new ArrivalEstimationResult(time1 + t3x, vEndMax, ap);
        }
        throw new ArrivalEstimationException("Arrival estimation failed: distance too small (Case 6d)");
    }

    private static ArrivalEstimationResult estimateMaxVEndForCase2AndCase5(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel) {
        double vEnd = Math.sqrt(2.0 * accel * dTotal + v1 * v1);
        assert (vEnd < vEndMax);
        double t1x = (vEnd - v1) / accel;
        AccelSchedule ap = new AccelSchedule();
        ap.add(time1, accel);
        ap.add(time1 + t1x, 0.0);
        return new ArrivalEstimationResult(time1 + t1x, vEnd, ap);
    }

    private static boolean isResultValid(double time1, double v1, double dTotal, double vTop, double vEndMax, double accel, double decel, ArrivalEstimationResult result) {
        assert (result != null);
        AccelSchedule as = result.getAccelSchedule();
        double vEnd = as.calcFinalVelocity(v1);
        if (Util.isDoubleNotEqual(vEnd, result.getArrivalVelocity(), 1.0E-6)) {
            System.err.printf("Error in VelocityFirstArrivalEstimation.isResultValid(): vEnd != arrival velocity\n", new Object[0]);
            System.err.printf("%.9f != %.9f\n", vEnd, result.getArrivalVelocity());
            return false;
        }
        if (Util.isDoubleNotEqual(vEnd, vEndMax, 1.0E-6) && vEnd > vEndMax) {
            System.err.printf("Error in VelocityFirstArrivalEstimation.isResultValid(): vEnd > vEndMax\n", new Object[0]);
            System.err.printf("vEnd = %.9f\n", vEnd);
            System.err.printf("vEndMax = %.9f\n", vEndMax);
            return false;
        }
        if (!as.checkVelocityUpperLimit(v1, vTop)) {
            System.err.printf("Error in VelocityFirstArrivalEstimation.isResultValid(): velocity exceeds upper limit\n", new Object[0]);
            return false;
        }
        double d = as.calcTotalDistance(time1, v1, result.getArrivalTime());
        if (Util.isDoubleNotEqual(d, dTotal, 1.0E-6)) {
            System.err.printf("d      = %.10f\n", d);
            System.err.printf("dTotal = %.10f\n", dTotal);
            System.err.printf("Error in VelocityFirstArrivalEstimation.isResultValid(): d != dTotal\n", new Object[0]);
            return false;
        }
        return true;
    }
}

