/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver.pilot;

import aim4.config.Debug;
import aim4.config.DebugPoint;
import aim4.driver.Driver;
import aim4.driver.DriverUtil;
import aim4.vehicle.VehicleDriverView;
import java.awt.Color;
import java.awt.geom.Point2D;

public abstract class BasicPilot {
    public abstract VehicleDriverView getVehicle();

    public abstract Driver getDriver();

    public void followCurrentLane() {
        this.followCurrentLane(0.4);
    }

    public void followNewLane() {
        double leadDist = DriverUtil.getLeadDistance(this.getVehicle());
        Point2D aimPoint = this.getDriver().getCurrentLane().getLeadPoint(this.getVehicle().gaugePosition(), leadDist);
        if (Debug.isTargetVIN(this.getVehicle().getVIN())) {
            Debug.addShortTermDebugPoint(new DebugPoint(aimPoint, this.getVehicle().gaugePointBetweenFrontWheels(), "shift", Color.GREEN.brighter()));
        }
        this.getVehicle().turnTowardPoint(aimPoint);
    }

    private void followCurrentLane(double leadTime) {
        Point2D aimPoint;
        double remaining;
        Driver driver = this.getVehicle().getDriver();
        double leadDist = leadTime * this.getVehicle().gaugeVelocity() + 0.2;
        if (leadDist > (remaining = driver.getCurrentLane().remainingDistanceAlongLane(this.getVehicle().gaugePosition())) && driver.getCurrentLane().hasNextLane()) {
            if (remaining <= 0.0) {
                driver.setCurrentLane(driver.getCurrentLane().getNextLane());
                this.followCurrentLane(leadTime);
                return;
            }
            aimPoint = driver.getCurrentLane().getNextLane().getLeadPoint(driver.getCurrentLane().getNextLane().getStartPoint(), leadDist - remaining);
            if (Debug.isTargetVIN(this.getVehicle().getVIN())) {
                Debug.addShortTermDebugPoint(new DebugPoint(aimPoint, this.getVehicle().gaugePointBetweenFrontWheels(), "next lane", Color.RED));
            }
        } else {
            aimPoint = driver.getCurrentLane().getLeadPoint(this.getVehicle().gaugePosition(), leadDist);
            if (Debug.isTargetVIN(this.getVehicle().getVIN())) {
                Debug.addShortTermDebugPoint(new DebugPoint(aimPoint, this.getVehicle().gaugePointBetweenFrontWheels(), "lane", Color.PINK.brighter()));
            }
        }
        this.getVehicle().turnTowardPoint(aimPoint);
    }

    protected void cruise() {
        this.getVehicle().setTargetVelocityWithMaxAccel(DriverUtil.calculateMaxFeasibleVelocity(this.getVehicle()));
    }
}

