/*
 * Decompiled with CFR 0.152.
 */
package aim4.driver.pilot;

import aim4.config.Debug;
import aim4.driver.AutoDriver;
import aim4.driver.DriverUtil;
import aim4.driver.coordinator.V2ICoordinator;
import aim4.driver.pilot.BasicPilot;
import aim4.vehicle.AutoVehicleDriverView;
import aim4.vehicle.VehicleUtil;
import java.util.Iterator;
import java.util.Queue;

public class V2IPilot
extends BasicPilot {
    public static double MINIMUM_FOLLOWING_DISTANCE;
    public static double DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION;
    public static final double TRAVERSING_LANE_CHANGE_LEAD_TIME = 1.5;
    private double stopDistanceBeforeIntersection;
    private AutoVehicleDriverView vehicle;
    private AutoDriver driver;

    public V2IPilot(AutoVehicleDriverView vehicle, AutoDriver driver) {
        this.vehicle = vehicle;
        this.driver = driver;
        this.stopDistanceBeforeIntersection = DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION;
    }

    @Override
    public AutoVehicleDriverView getVehicle() {
        return this.vehicle;
    }

    @Override
    public AutoDriver getDriver() {
        return this.driver;
    }

    public void takeSteeringActionForTraversing(V2ICoordinator.ReservationParameter rp) {
        double traversingLaneChangeDistance;
        double distToLane;
        if (this.driver.getCurrentLane() != rp.getDepartureLane() && Debug.currentMap.getRoad(this.driver.getCurrentLane()) != Debug.currentMap.getRoad(rp.getDepartureLane()) && (distToLane = rp.getDepartureLane().nearestDistance(this.vehicle.gaugePosition())) < (traversingLaneChangeDistance = 1.5 * this.vehicle.gaugeVelocity())) {
            this.driver.setCurrentLane(rp.getDepartureLane());
        }
        this.followCurrentLane();
    }

    public void followAccelerationProfile(V2ICoordinator.ReservationParameter rp) {
        Queue<double[]> accelProf = rp.getAccelerationProfile();
        if (accelProf == null || accelProf.isEmpty()) {
            this.vehicle.setTargetVelocityWithMaxAccel(this.calculateIntersectionVelocity(rp));
        } else {
            double[] currentDirective = accelProf.element();
            if (currentDirective[1] > 0.02) {
                this.vehicle.setAccelWithMaxTargetVelocity(currentDirective[0]);
                currentDirective[1] = currentDirective[1] - 0.02;
            } else if (currentDirective[1] < 0.02) {
                double totalAccel = 0.0;
                double remainingWeight = 0.02;
                Iterator iter = accelProf.iterator();
                while (iter.hasNext()) {
                    currentDirective = (double[])iter.next();
                    if (currentDirective[1] > remainingWeight) {
                        totalAccel += remainingWeight * currentDirective[0];
                        currentDirective[1] = currentDirective[1] - remainingWeight;
                        remainingWeight = 0.0;
                        break;
                    }
                    if (currentDirective[1] < remainingWeight) {
                        totalAccel += currentDirective[1] * currentDirective[0];
                        remainingWeight -= currentDirective[1];
                        iter.remove();
                        continue;
                    }
                    totalAccel += currentDirective[1] * currentDirective[0];
                    remainingWeight = 0.0;
                    iter.remove();
                    break;
                }
                if (remainingWeight > 0.0) {
                    totalAccel += remainingWeight * currentDirective[0];
                }
                this.vehicle.setAccelWithMaxTargetVelocity(totalAccel / 0.02);
            } else {
                accelProf.remove();
                this.vehicle.setAccelWithMaxTargetVelocity(currentDirective[0]);
            }
        }
    }

    private double calculateIntersectionVelocity(V2ICoordinator.ReservationParameter rp) {
        return VehicleUtil.maxTurnVelocity(this.vehicle.getSpec(), rp.getArrivalLane(), rp.getDepartureLane(), this.driver.getCurrentIM());
    }

    public void simpleThrottleAction() {
        this.cruise();
        this.dontHitVehicleInFront();
        this.dontEnterIntersection();
    }

    private void dontHitVehicleInFront() {
        double stoppingDistance = VehicleUtil.calcDistanceToStop(this.vehicle.gaugeVelocity(), this.vehicle.getSpec().getMaxDeceleration());
        double followingDistance = stoppingDistance + MINIMUM_FOLLOWING_DISTANCE;
        if (VehicleUtil.distanceToCarInFront(this.vehicle) < followingDistance) {
            this.vehicle.slowToStop();
        }
    }

    private void dontEnterIntersection() {
        double stoppingDistance = this.distIfStopNextTimeStep();
        double minDistanceToIntersection = stoppingDistance + DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION;
        if (this.vehicle.getDriver().distanceToNextIntersection() < minDistanceToIntersection) {
            this.vehicle.slowToStop();
        }
    }

    private double distIfStopNextTimeStep() {
        double distIfAccel = VehicleUtil.calcDistanceIfAccel(this.vehicle.gaugeVelocity(), this.vehicle.getSpec().getMaxAcceleration(), DriverUtil.calculateMaxFeasibleVelocity(this.vehicle), 0.02);
        double distToStop = VehicleUtil.calcDistanceToStop(this.speedNextTimeStepIfAccel(), this.vehicle.getSpec().getMaxDeceleration());
        return distIfAccel + distToStop;
    }

    private double speedNextTimeStepIfAccel() {
        return Math.min(DriverUtil.calculateMaxFeasibleVelocity(this.vehicle), this.vehicle.gaugeVelocity() + this.vehicle.getSpec().getMaxAcceleration() * 0.02);
    }

    static {
        DEFAULT_STOP_DISTANCE_BEFORE_INTERSECTION = 1.0;
    }
}

