/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui;

import aim4.gui.parampanel.AutoDriverOnlyParamPanel;
import aim4.gui.parampanel.TrafficSignalParamPanel;
import aim4.sim.setup.ApproxNPhasesTrafficSignalSimSetup;
import aim4.sim.setup.ApproxStopSignSimSetup;
import aim4.sim.setup.AutoDriverOnlySimSetup;
import aim4.sim.setup.BasicSimSetup;
import aim4.sim.setup.SimSetup;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SimSetupPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 1L;
    static final String AUTO_DRIVER_ONLY_SETUP_PANEL = "AIM Protocol";
    static final String TRAFFIC_SIGNAL_SETUP_PANEL = "Traffic Signals";
    static final String STOP_SIGN_SETUP_PANEL = "Stop Signs";
    private JComboBox comboBox;
    private JPanel cards;
    private CardLayout cardLayout;
    private AutoDriverOnlyParamPanel autoDriverOnlySetupPanel;
    private TrafficSignalParamPanel trafficSignalSetupPanel;
    private BasicSimSetup simSetup;

    public SimSetupPanel(BasicSimSetup initSimSetup) {
        this.simSetup = initSimSetup;
        JPanel comboBoxPane = new JPanel();
        comboBoxPane.setBackground(Color.WHITE);
        String[] comboBoxItems = new String[]{AUTO_DRIVER_ONLY_SETUP_PANEL, TRAFFIC_SIGNAL_SETUP_PANEL, STOP_SIGN_SETUP_PANEL};
        this.comboBox = new JComboBox<String>(comboBoxItems);
        this.comboBox.setEditable(false);
        this.comboBox.addItemListener(this);
        comboBoxPane.add(this.comboBox);
        this.cardLayout = new CardLayout();
        this.cards = new JPanel(this.cardLayout);
        this.autoDriverOnlySetupPanel = new AutoDriverOnlyParamPanel(this.simSetup);
        this.addParamPanel(this.autoDriverOnlySetupPanel, AUTO_DRIVER_ONLY_SETUP_PANEL);
        this.trafficSignalSetupPanel = new TrafficSignalParamPanel();
        this.cards.add((Component)this.trafficSignalSetupPanel, TRAFFIC_SIGNAL_SETUP_PANEL);
        this.cards.add((Component)new JPanel(), STOP_SIGN_SETUP_PANEL);
        this.setLayout(new BorderLayout());
        this.add((Component)comboBoxPane, "First");
        this.add((Component)this.cards, "Center");
    }

    private void addParamPanel(JPanel paramPanel, String paramLabel) {
        JScrollPane scrollPane = new JScrollPane(paramPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.cards.add((Component)scrollPane, paramLabel);
    }

    public SimSetup getSimSetup() {
        if (this.comboBox.getSelectedIndex() == 0) {
            AutoDriverOnlySimSetup simSetup2 = new AutoDriverOnlySimSetup(this.simSetup);
            simSetup2.setTrafficLevel(this.autoDriverOnlySetupPanel.getTrafficRate());
            simSetup2.setSpeedLimit(this.autoDriverOnlySetupPanel.getSpeedLimit());
            simSetup2.setStopDistBeforeIntersection(this.autoDriverOnlySetupPanel.getStopDistToIntersection());
            simSetup2.setNumOfColumns(this.autoDriverOnlySetupPanel.getNumOfColumns());
            simSetup2.setNumOfRows(this.autoDriverOnlySetupPanel.getNumOfRows());
            simSetup2.setLanesPerRoad(this.autoDriverOnlySetupPanel.getLanesPerRoad());
            return simSetup2;
        }
        if (this.comboBox.getSelectedIndex() == 1) {
            ApproxNPhasesTrafficSignalSimSetup simSetup2 = new ApproxNPhasesTrafficSignalSimSetup(this.simSetup, "/SignalPhases/AIM4Phases.csv");
            simSetup2.setTrafficVolume("/SignalPhases/AIM4Volumes.csv");
            simSetup2.setLanesPerRoad(this.trafficSignalSetupPanel.getLanesPerRoad());
            simSetup2.setStopDistBeforeIntersection(1.0);
            return simSetup2;
        }
        if (this.comboBox.getSelectedIndex() == 2) {
            ApproxStopSignSimSetup simSetup2 = new ApproxStopSignSimSetup(this.simSetup);
            simSetup2.setTrafficLevel(this.autoDriverOnlySetupPanel.getTrafficRate());
            simSetup2.setStopDistBeforeIntersection(this.autoDriverOnlySetupPanel.getStopDistToIntersection());
            return simSetup2;
        }
        throw new RuntimeException("SimSetupPane::getSimSetup(): not implemented yet");
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.cardLayout.show(this.cards, (String)evt.getItem());
    }
}

