/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui;

import aim4.config.Constants;
import aim4.config.Debug;
import aim4.gui.Canvas;
import aim4.gui.SimSetupPanel;
import aim4.gui.StatusPanelContainer;
import aim4.gui.ViewerDebugView;
import aim4.gui.frame.VehicleInfoFrame;
import aim4.im.IntersectionManager;
import aim4.map.Road;
import aim4.map.lane.Lane;
import aim4.sim.AutoDriverOnlySimulator;
import aim4.sim.Simulator;
import aim4.sim.UdpListener;
import aim4.sim.setup.BasicSimSetup;
import aim4.sim.setup.SimFactory;
import aim4.sim.setup.SimSetup;
import aim4.util.Util;
import aim4.vehicle.VehicleSimView;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Viewer
extends JFrame
implements ActionListener,
KeyListener,
MouseListener,
ItemListener,
ViewerDebugView {
    private static final long serialVersionUID = 1L;
    public static final boolean IS_SHOW_SIMULATION_TIME = true;
    public static final boolean IS_SHOW_VIN_BY_DEFAULT = false;
    public static final boolean IS_SHOW_IM_DEBUG_SHAPES_BY_DEFAULT = false;
    public static final double DEFAULT_SIM_SPEED = 15.0;
    public static final double DEFAULT_TARGET_FRAME_RATE = 20.0;
    public static final double TURBO_SIM_SPEED = 15.0;
    private static final String TITLEBAR_STRING = "AIM Viewer";
    private static final int PREF_MAX_CANVAS_WIDTH = 650;
    private static final int PREF_MAX_CANVAS_HEIGHT = 650;
    private static final int DEFAULT_BUTTON_WIDTH = 100;
    private static final int DEFAULT_STATUS_PANE_HEIGHT = 200;
    private static final int SIM_SETUP_PANE_GAP = 50;
    private BasicSimSetup initSimSetup;
    private Simulator sim;
    private SimThread simThread;
    private UdpListener udpListener;
    private double targetSimSpeed;
    private double targetFrameRate;
    private long nextFrameTime;
    boolean recording;
    String imageDir;
    int imageCounter;
    private JPanel mainPanel;
    private CardLayout canvasCardLayout;
    private Canvas canvas;
    private SimSetupPanel simSetupPanel;
    private StatusPanelContainer statusPanel;
    private JButton startButton;
    private JButton stepButton;
    private VehicleInfoFrame vehicleInfoFrame;
    private JMenuItem startMenuItem;
    private JMenuItem stepMenuItem;
    private JMenuItem resetMenuItem;
    private JMenuItem dumpDataMenuItem;
    private JMenuItem startRecordingMenuItem;
    private JMenuItem stopRecordingMenuItem;
    private JMenuItem startUdpListenerMenuItem;
    private JMenuItem stopUdpListenerMenuItem;
    private JCheckBoxMenuItem showSimulationTimeMenuItem;
    private JCheckBoxMenuItem showVinMenuItem;
    private JCheckBoxMenuItem showIMShapesMenuItem;
    private JMenuItem clearDebugPointsMenuItem;

    public Viewer(BasicSimSetup initSimSetup) {
        this(initSimSetup, false);
    }

    public Viewer(final BasicSimSetup initSimSetup, final boolean isRunNow) {
        super(TITLEBAR_STRING);
        this.initSimSetup = initSimSetup;
        this.sim = null;
        this.udpListener = null;
        this.simThread = null;
        this.targetSimSpeed = 15.0;
        this.targetFrameRate = Math.min(20.0, 50.0);
        this.nextFrameTime = 0L;
        this.recording = false;
        this.imageDir = null;
        this.imageCounter = 0;
        Debug.viewer = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Viewer.this.createAndShowGUI(initSimSetup, isRunNow);
            }
        });
    }

    private void createAndShowGUI(BasicSimSetup initSimSetup, boolean isRunNow) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", TITLEBAR_STRING);
        this.setDefaultCloseOperation(3);
        this.createMenuBar();
        this.createComponents();
        this.setComponentsLayout();
        this.pack();
        this.setVisible(true);
        this.initGUIsetting();
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.addKeyListener(this);
        if (isRunNow) {
            this.startButtonHandler(initSimSetup);
            this.canvas.requestFocusInWindow();
        }
    }

    private void createMenuBar() {
        JMenu menu;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        if (!System.getProperty("os.name").equals("Mac OS X")) {
            menu = new JMenu("File");
            menuBar.add(menu);
            JMenuItem menuItem = new JMenuItem("Quit AIM");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        menu = new JMenu("Simulator");
        menuBar.add(menu);
        this.startMenuItem = new JMenuItem("Start");
        this.startMenuItem.addActionListener(this);
        menu.add(this.startMenuItem);
        this.stepMenuItem = new JMenuItem("Step");
        this.stepMenuItem.addActionListener(this);
        menu.add(this.stepMenuItem);
        this.resetMenuItem = new JMenuItem("Reset");
        this.resetMenuItem.addActionListener(this);
        menu.add(this.resetMenuItem);
        menu = new JMenu("Data");
        menuBar.add(menu);
        this.dumpDataMenuItem = new JMenuItem("Dump Data Collection Lines' Data");
        this.dumpDataMenuItem.addActionListener(this);
        menu.add(this.dumpDataMenuItem);
        menu = new JMenu("Recording");
        menuBar.add(menu);
        this.startRecordingMenuItem = new JMenuItem("Start");
        this.startRecordingMenuItem.addActionListener(this);
        menu.add(this.startRecordingMenuItem);
        this.stopRecordingMenuItem = new JMenuItem("Stop");
        this.stopRecordingMenuItem.addActionListener(this);
        menu.add(this.stopRecordingMenuItem);
        menu = new JMenu("UDP");
        menuBar.add(menu);
        this.startUdpListenerMenuItem = new JMenuItem("Start Listening");
        this.startUdpListenerMenuItem.addActionListener(this);
        this.startUdpListenerMenuItem.setEnabled(false);
        menu.add(this.startUdpListenerMenuItem);
        this.stopUdpListenerMenuItem = new JMenuItem("Stop Listening");
        this.stopUdpListenerMenuItem.addActionListener(this);
        this.stopUdpListenerMenuItem.setEnabled(false);
        menu.add(this.stopUdpListenerMenuItem);
        menu = new JMenu("View");
        menuBar.add(menu);
        this.showSimulationTimeMenuItem = new JCheckBoxMenuItem("Show Simulation Time", true);
        this.showSimulationTimeMenuItem.addItemListener(this);
        menu.add(this.showSimulationTimeMenuItem);
        this.showVinMenuItem = new JCheckBoxMenuItem("Show VINs", false);
        this.showVinMenuItem.addItemListener(this);
        menu.add(this.showVinMenuItem);
        this.showIMShapesMenuItem = new JCheckBoxMenuItem("Show IM Shapes", false);
        this.showIMShapesMenuItem.addItemListener(this);
        menu.add(this.showIMShapesMenuItem);
        menu = new JMenu("Debug");
        menuBar.add(menu);
        this.clearDebugPointsMenuItem = new JMenuItem("Clear Debug Points");
        this.clearDebugPointsMenuItem.addActionListener(this);
        menu.add(this.clearDebugPointsMenuItem);
    }

    private void createComponents() {
        this.mainPanel = new JPanel();
        this.canvas = new Canvas(this);
        this.simSetupPanel = new SimSetupPanel(this.initSimSetup);
        this.statusPanel = new StatusPanelContainer(this);
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(this);
        this.stepButton = new JButton("Step");
        this.stepButton.setEnabled(false);
        this.stepButton.addActionListener(this);
    }

    private void setComponentsLayout() {
        this.canvasCardLayout = new CardLayout();
        this.mainPanel.setLayout(this.canvasCardLayout);
        this.mainPanel.setPreferredSize(new Dimension(650, 650));
        JPanel panel1 = new JPanel();
        panel1.setBackground(Canvas.GRASS_COLOR);
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.fill = 1;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        c1.insets = new Insets(50, 50, 50, 50);
        panel1.add((Component)this.simSetupPanel, c1);
        this.mainPanel.add((Component)panel1, "SIM_SETUP_PANEL");
        this.mainPanel.add((Component)this.canvas, "CANVAS");
        Container pane = this.getContentPane();
        GroupLayout layout = new GroupLayout(pane);
        pane.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startButton, 100, -1, 100).addComponent(this.stepButton, 100, -1, 100)).addComponent(this.statusPanel)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.mainPanel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(this.startButton).addComponent(this.stepButton)).addComponent(this.statusPanel, 200, -1, 200)));
    }

    public Simulator getSimulator() {
        return this.sim;
    }

    private void initGUIsetting() {
        this.resetButtonMenuItem();
        this.startRecordingMenuItem.setEnabled(true);
        this.stopRecordingMenuItem.setEnabled(false);
        this.startUdpListenerMenuItem.setEnabled(false);
        this.stopUdpListenerMenuItem.setEnabled(false);
        this.showSimulationTimeMenuItem.setSelected(true);
        this.showVinMenuItem.setSelected(false);
        this.showIMShapesMenuItem.setSelected(false);
    }

    private void setSimStartGUIsetting() {
        this.canvasCardLayout.show(this.mainPanel, "CANVAS");
        this.canvas.initWithGivenMap(this.sim.getMap());
        this.statusPanel.init();
        this.startButton.setText("Pause");
        this.stepButton.setEnabled(false);
        this.startMenuItem.setText("Pause");
        this.stepMenuItem.setEnabled(false);
        this.resetMenuItem.setEnabled(true);
        this.dumpDataMenuItem.setEnabled(true);
        this.startUdpListenerMenuItem.setEnabled(true);
        this.clearDebugPointsMenuItem.setEnabled(true);
    }

    private void setSimResetGUIsetting() {
        this.canvas.cleanUp();
        this.statusPanel.clear();
        this.resetButtonMenuItem();
    }

    private void resetButtonMenuItem() {
        this.canvasCardLayout.show(this.mainPanel, "SIM_SETUP_PANEL");
        this.startButton.setText("Start");
        this.stepButton.setEnabled(false);
        this.startMenuItem.setText("Start");
        this.stepMenuItem.setEnabled(false);
        this.resetMenuItem.setEnabled(false);
        this.dumpDataMenuItem.setEnabled(false);
        this.startUdpListenerMenuItem.setEnabled(false);
        this.clearDebugPointsMenuItem.setEnabled(false);
    }

    private void startButtonHandler() {
        this.startButtonHandler(this.simSetupPanel.getSimSetup());
    }

    private void startButtonHandler(SimSetup initSimSetup) {
        if (this.simThread == null) {
            this.startSimProcess(initSimSetup);
        } else if (!this.simThread.isPaused()) {
            this.pauseSimProcess();
        } else {
            this.resumeSimProcess();
        }
    }

    private void stepButtonHandler() {
        this.stepSimProcess();
    }

    private void startSimProcess(SimSetup initSimSetup) {
        assert (this.sim == null && this.udpListener == null);
        this.sim = SimFactory.makeSimulator(initSimSetup);
        this.createSimThread();
        this.setSimStartGUIsetting();
        this.nextFrameTime = System.currentTimeMillis();
        this.simThread.start();
    }

    private void pauseSimProcess() {
        assert (this.simThread != null && !this.simThread.isPaused());
        this.simThread.pause();
        this.startButton.setText("Resume");
        this.stepButton.setEnabled(true);
        this.startMenuItem.setText("Resume");
        this.stepMenuItem.setEnabled(true);
    }

    private void resumeSimProcess() {
        assert (this.simThread != null && this.simThread.isPaused());
        this.simThread.setSteppingMode(false);
        this.simThread.resume();
        this.nextFrameTime = System.currentTimeMillis();
        this.startButton.setText("Pause");
        this.stepButton.setEnabled(false);
        this.startMenuItem.setText("Pause");
        this.stepMenuItem.setEnabled(false);
    }

    private void stepSimProcess() {
        assert (this.simThread != null && this.simThread.isPaused());
        this.simThread.setSteppingMode(true);
        this.simThread.resume();
    }

    private void resetSimProcess() {
        assert (this.simThread != null);
        this.simThread.terminate();
        if (this.simThread.isPaused()) {
            this.simThread.setSteppingMode(false);
            this.simThread.resume();
        }
        this.simThread = null;
        this.sim = null;
        if (this.udpListener != null) {
            this.stopUdpListening();
        }
        this.setSimResetGUIsetting();
    }

    private void createSimThread() {
        if (0.0 < this.targetSimSpeed && this.targetSimSpeed < 15.0) {
            long timerDelay = (long)(20.0 / this.targetSimSpeed);
            this.simThread = new SimThread(false, timerDelay);
        } else {
            long timerDelay = this.targetFrameRate < 50.0 ? (long)(1000.0 / this.targetFrameRate) : 20L;
            this.simThread = new SimThread(true, timerDelay);
        }
    }

    public void setTargetSimSpeed(double simSpeed) {
        this.targetSimSpeed = simSpeed;
        if (this.simThread != null) {
            if (Util.isDoubleZero(simSpeed)) {
                long timerDelay = 200L;
                this.simThread.setTimeDelay(timerDelay);
                this.simThread.setTurboMode(false);
                if (!this.simThread.isPaused()) {
                    this.pauseSimProcess();
                }
            } else if (Util.isDoubleEqualOrGreater(simSpeed, 15.0)) {
                long timerDelay = this.targetFrameRate < 50.0 ? (long)(1000.0 / this.targetFrameRate) : 20L;
                this.simThread.setTimeDelay(timerDelay);
                this.simThread.setTurboMode(true);
                if (this.simThread.isPaused()) {
                    this.resumeSimProcess();
                }
            } else {
                long timerDelay = (long)(20.0 / simSpeed);
                this.simThread.setTimeDelay(timerDelay);
                this.simThread.setTurboMode(false);
                if (this.simThread.isPaused()) {
                    this.resumeSimProcess();
                }
            }
        }
        this.canvas.requestFocusInWindow();
    }

    public void setTargetFrameRate(double targetFrameRate) {
        this.targetFrameRate = Math.min(targetFrameRate, 50.0);
        if (this.simThread != null && this.simThread.isTurboMode()) {
            long timerDelay = 0.0 < targetFrameRate ? (long)(1000.0 / targetFrameRate) : 100L;
            this.simThread.setTimeDelay(timerDelay);
        }
    }

    private void runSimulationStep() {
        Debug.clearShortTermDebugPoints();
        Simulator.SimStepResult simStepResult = this.sim.step(0.02);
        if (simStepResult instanceof AutoDriverOnlySimulator.AutoDriverOnlySimStepResult) {
            AutoDriverOnlySimulator.AutoDriverOnlySimStepResult simStepResult2 = (AutoDriverOnlySimulator.AutoDriverOnlySimStepResult)simStepResult;
            for (int vin : simStepResult2.getCompletedVINs()) {
                Debug.removeVehicleColor(vin);
            }
        }
    }

    private boolean updateScreenForOneStepInFastRunningMode() {
        return 0.0 < this.targetFrameRate && this.targetFrameRate < 50.0;
    }

    private void updateScreenInTurboMode() {
        if (0.0 < this.targetFrameRate) {
            this.updateScreen();
            this.saveScreenShot();
        }
    }

    private void updateScreenInNormalMode() {
        if (this.targetFrameRate >= 50.0) {
            this.updateScreen();
            this.saveScreenShot();
        } else if (0.0 < this.targetFrameRate && System.currentTimeMillis() > this.nextFrameTime) {
            this.updateScreen();
            this.saveScreenShot();
            this.nextFrameTime = System.currentTimeMillis() + (long)(1000.0 / this.targetFrameRate);
        }
    }

    private void updateScreen() {
        this.canvas.update();
        this.statusPanel.update();
    }

    private void saveScreenShot() {
        if (this.recording && this.imageDir != null) {
            String outFileName = this.imageDir + "/" + Constants.LEADING_ZEROES.format(this.imageCounter++) + ".png";
            this.canvas.saveScreenShot(outFileName);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startMenuItem || e.getSource() == this.startButton) {
            this.startButtonHandler();
            this.canvas.requestFocusInWindow();
        } else if (e.getSource() == this.stepMenuItem || e.getSource() == this.stepButton) {
            this.stepButtonHandler();
            this.canvas.requestFocusInWindow();
        } else if (e.getSource() == this.resetMenuItem) {
            this.resetSimProcess();
        } else if (e.getSource() == this.dumpDataMenuItem) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showDialog(this, "Save");
            if (returnVal == 0) {
                boolean isDumpData = false;
                String outFileName = null;
                try {
                    outFileName = chooser.getSelectedFile().getCanonicalPath();
                    isDumpData = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (isDumpData) {
                    this.sim.getMap().printDataCollectionLinesData(outFileName);
                }
            }
        } else if (e.getSource() == this.startRecordingMenuItem) {
            if (!this.recording) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showDialog(this, "Choose Directory");
                if (returnVal == 0) {
                    try {
                        this.imageDir = chooser.getSelectedFile().getCanonicalPath();
                        this.recording = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.recording) {
                        this.startRecordingMenuItem.setEnabled(false);
                        this.stopRecordingMenuItem.setEnabled(true);
                    }
                }
            }
        } else if (e.getSource() == this.stopRecordingMenuItem) {
            if (this.recording) {
                this.recording = false;
                this.imageCounter = 0;
                this.startRecordingMenuItem.setEnabled(true);
                this.stopRecordingMenuItem.setEnabled(false);
            }
        } else if (e.getSource() == this.startUdpListenerMenuItem) {
            this.startUdpListening();
        } else if (e.getSource() == this.stopUdpListenerMenuItem) {
            this.stopUdpListening();
        } else if (e.getSource() == this.clearDebugPointsMenuItem) {
            Debug.clearLongTermDebugPoints();
        } else if ("Quit".equals(e.getActionCommand())) {
            System.exit(0);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.simThread != null) {
            switch (e.getKeyCode()) {
                case 10: {
                    this.startButtonHandler();
                    break;
                }
                case 32: {
                    if (this.simThread.isPaused()) {
                        this.stepButtonHandler();
                        break;
                    }
                    this.startButtonHandler();
                    break;
                }
                case 27: {
                    this.resetSimProcess();
                    break;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.sim != null) {
                Point2D leftClickPoint = this.canvas.getMapPosition(e.getX(), e.getY());
                for (VehicleSimView vehicle : this.sim.getActiveVehicles()) {
                    if (!vehicle.getShape().contains(leftClickPoint)) continue;
                    if (Debug.getTargetVIN() != vehicle.getVIN()) {
                        Debug.setTargetVIN(vehicle.getVIN());
                        if (this.vehicleInfoFrame == null) {
                            this.vehicleInfoFrame = new VehicleInfoFrame(this);
                        }
                        if (!this.vehicleInfoFrame.isVisible()) {
                            this.vehicleInfoFrame.setVisible(true);
                            this.requestFocusInWindow();
                            this.requestFocus();
                        }
                        this.vehicleInfoFrame.setVehicle(vehicle);
                    } else {
                        Debug.removeTargetVIN();
                        this.vehicleInfoFrame.setVehicle(null);
                    }
                    this.canvas.update();
                    return;
                }
                for (IntersectionManager im : this.sim.getMap().getIntersectionManagers()) {
                    if (!im.getIntersection().getArea().contains(leftClickPoint)) continue;
                    if (Debug.getTargetIMid() != im.getId()) {
                        Debug.setTargetIMid(im.getId());
                    } else {
                        Debug.removeTargetIMid();
                    }
                    this.canvas.cleanUp();
                    this.canvas.update();
                    return;
                }
                Debug.removeTargetVIN();
                if (this.vehicleInfoFrame != null) {
                    this.vehicleInfoFrame.setVehicle(null);
                }
                Debug.removeTargetIMid();
                this.canvas.cleanUp();
                this.canvas.update();
            }
        } else if (e.getButton() == 3 && this.sim != null) {
            Point2D rightClickPoint = this.canvas.getMapPosition(e.getX(), e.getY());
            System.err.printf("Right click at (%.0f, %.0f)\n", rightClickPoint.getX(), rightClickPoint.getY());
            for (Road r : this.sim.getMap().getRoads()) {
                for (Lane l : r.getLanes()) {
                    if (!l.getShape().contains(rightClickPoint)) continue;
                    System.err.printf("Right click on lane %d\n", l.getId());
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.showSimulationTimeMenuItem) {
            if (e.getStateChange() == 1) {
                this.canvas.setIsShowSimulationTime(true);
            } else {
                this.canvas.setIsShowSimulationTime(false);
            }
            this.canvas.update();
        } else if (source == this.showVinMenuItem) {
            if (e.getStateChange() == 1) {
                this.canvas.setIsShowVin(true);
            } else {
                this.canvas.setIsShowVin(false);
            }
            this.canvas.update();
        } else if (source == this.showIMShapesMenuItem) {
            if (e.getStateChange() == 1) {
                this.canvas.setIsShowIMDebugShapes(true);
            } else {
                this.canvas.setIsShowIMDebugShapes(false);
            }
            this.canvas.update();
        }
    }

    private void startUdpListening() {
        assert (this.startUdpListenerMenuItem.isEnabled());
        if (this.sim != null) {
            System.err.print("Starting UDP listener...\n");
            this.udpListener = new UdpListener(this.sim);
            this.udpListener.start();
            if (this.udpListener.hasStarted()) {
                this.startUdpListenerMenuItem.setEnabled(false);
                this.stopUdpListenerMenuItem.setEnabled(true);
            } else {
                System.err.printf("Failed to start UDP listener...\n", new Object[0]);
            }
        } else {
            System.err.printf("Must start the simulator before starting UdpListener.\n", new Object[0]);
        }
    }

    private void stopUdpListening() {
        assert (this.stopUdpListenerMenuItem.isEnabled());
        System.err.print("Stopping UDP listener...\n");
        this.udpListener.stop();
        if (!this.udpListener.hasStarted()) {
            this.startUdpListenerMenuItem.setEnabled(true);
            this.stopUdpListenerMenuItem.setEnabled(false);
        } else {
            System.err.printf("Failed to stop UDP listener...\n", new Object[0]);
        }
        this.udpListener = null;
    }

    @Override
    public void highlightVehicle(int vin) {
        this.canvas.highlightVehicle(vin);
    }

    public class SimThread
    implements Runnable {
        private volatile Thread blinker = null;
        private boolean isTurboMode;
        private long timeDelay;
        private boolean isSteppingMode;
        private boolean isStopped;

        public SimThread(boolean isTurboMode, long timeDelay) {
            this.isTurboMode = isTurboMode;
            this.timeDelay = timeDelay;
            this.isSteppingMode = false;
            this.isStopped = false;
        }

        public boolean isPaused() {
            return this.isStopped;
        }

        public boolean isTurboMode() {
            return this.isTurboMode;
        }

        public synchronized void setTurboMode(boolean isTurboMode) {
            this.isTurboMode = isTurboMode;
        }

        public synchronized void setSteppingMode(boolean isSteppingMode) {
            this.isSteppingMode = isSteppingMode;
        }

        public synchronized void setTimeDelay(long timeDelay) {
            this.timeDelay = timeDelay;
        }

        public synchronized void start() {
            assert (this.blinker == null);
            this.blinker = new Thread((Runnable)this, "AIM4 Simulator Thread");
            this.blinker.start();
        }

        public synchronized void terminate() {
            assert (this.blinker != null);
            this.blinker = null;
        }

        public void pause() {
            assert (!this.isStopped);
            this.isStopped = true;
        }

        public synchronized void resume() {
            assert (this.isStopped);
            this.isStopped = false;
        }

        @Override
        public void run() {
            Thread thisThread = Thread.currentThread();
            while (this.blinker == thisThread) {
                if (this.isStopped) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (this.isTurboMode) {
                    this.runTurboMode();
                } else {
                    this.runNormalMode();
                }
                Thread.yield();
            }
            System.err.printf("The simulation has terminated.\n", new Object[0]);
        }

        private synchronized void runTurboMode() {
            double nextFastRunningStepTime = System.currentTimeMillis() + this.timeDelay;
            while (!this.isStopped) {
                Viewer.this.runSimulationStep();
                if (Viewer.this.updateScreenForOneStepInFastRunningMode() && !this.isSteppingMode && !((double)System.currentTimeMillis() >= nextFastRunningStepTime)) continue;
            }
            Viewer.this.updateScreenInTurboMode();
            if (this.isSteppingMode) {
                this.isStopped = true;
            }
        }

        private synchronized void runNormalMode() {
            long nextInvokeTime = System.currentTimeMillis() + this.timeDelay;
            Viewer.this.runSimulationStep();
            Viewer.this.updateScreenInNormalMode();
            if (this.isSteppingMode) {
                this.isStopped = true;
            } else {
                long t = nextInvokeTime - System.currentTimeMillis();
                if (t > 0L) {
                    try {
                        Thread.sleep(t);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

