/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui.parampanel;

import aim4.gui.component.LabeledSlider;
import aim4.sim.setup.BasicSimSetup;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class AutoDriverOnlyParamPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    LabeledSlider trafficRateSlider;
    LabeledSlider speedLimitSlider;
    LabeledSlider stopDistToIntersectionSlider;
    LabeledSlider numOfColumnSlider;
    LabeledSlider numOfRowSlider;
    LabeledSlider lanesPerRoadSlider;

    public AutoDriverOnlyParamPanel(BasicSimSetup simSetup) {
        this.setLayout(new BoxLayout(this, 3));
        this.trafficRateSlider = new LabeledSlider(0.0, 2500.0, simSetup.getTrafficLevel() * 3600.0, 500.0, 100.0, "Traffic Level: %.0f vehicles/hour/lane", "%.0f");
        this.add(this.trafficRateSlider);
        this.speedLimitSlider = new LabeledSlider(0.0, 80.0, simSetup.getSpeedLimit(), 10.0, 5.0, "Speed Limit: %.0f meters/second", "%.0f");
        this.add(this.speedLimitSlider);
        this.stopDistToIntersectionSlider = new LabeledSlider(0.0, 50.0, simSetup.getStopDistBeforeIntersection(), 10.0, 1.0, "Stopping Distance Before Intersection: %.0f meters", "%.0f");
        this.add(this.stopDistToIntersectionSlider);
        this.numOfColumnSlider = new LabeledSlider(1.0, 5.0, simSetup.getColumns(), 1.0, 1.0, "Number of North-bound/South-bound Roads: %.0f", "%.0f");
        this.add(this.numOfColumnSlider);
        this.numOfRowSlider = new LabeledSlider(1.0, 5.0, simSetup.getColumns(), 1.0, 1.0, "Number of East-bound/West-bound Roads: %.0f", "%.0f");
        this.add(this.numOfRowSlider);
        this.lanesPerRoadSlider = new LabeledSlider(1.0, 8.0, simSetup.getLanesPerRoad(), 1.0, 1.0, "Number of Lanes per Road: %.0f", "%.0f");
        this.add(this.lanesPerRoadSlider);
    }

    public double getTrafficRate() {
        return this.trafficRateSlider.getValue() / 3600.0;
    }

    public double getSpeedLimit() {
        return this.speedLimitSlider.getValue();
    }

    public double getStopDistToIntersection() {
        double d = this.stopDistToIntersectionSlider.getValue();
        return d < 1.0 ? 1.0 : d;
    }

    public int getNumOfColumns() {
        return (int)this.numOfColumnSlider.getValue();
    }

    public int getNumOfRows() {
        return (int)this.numOfRowSlider.getValue();
    }

    public int getLanesPerRoad() {
        return (int)this.lanesPerRoadSlider.getValue();
    }
}

