/*
 * Decompiled with CFR 0.152.
 */
package aim4.gui.statuspanel;

import aim4.gui.StatusPanelInterface;
import aim4.gui.component.FormattedLabel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SystemPanel
extends JPanel
implements StatusPanelInterface {
    private static final long serialVersionUID = 1L;
    private final int MAX_MEMORY_DIGITS = (int)Math.log10(Runtime.getRuntime().maxMemory() / 0x100000L) + 1;
    private JLabel systemOSInfoLabel = new JLabel("Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
    private JLabel systemJavaInfoLabel = new JLabel("Java Version: " + System.getProperty("java.version"));
    private JLabel systemMaximumMemoryLabel = new JLabel("Maximum JVM Memory: " + Runtime.getRuntime().maxMemory() / 0x100000L + " MB");
    private FormattedLabel systemMemUsageLabel = new FormattedLabel("Memory Usage: ", "%" + this.MAX_MEMORY_DIGITS + "d MB", this.MAX_MEMORY_DIGITS + 3);
    private FormattedLabel systemAvailableMemoryLabel = new FormattedLabel("Allocated JVM Memory: ", "%" + this.MAX_MEMORY_DIGITS + "d MB", this.MAX_MEMORY_DIGITS + 3);

    public SystemPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.systemOSInfoLabel.setFont(FormattedLabel.FONT);
        c.gridwidth = 1;
        gridbag.setConstraints(this.systemOSInfoLabel, c);
        this.add(this.systemOSInfoLabel);
        this.systemJavaInfoLabel.setFont(FormattedLabel.FONT);
        c.gridwidth = 0;
        gridbag.setConstraints(this.systemJavaInfoLabel, c);
        this.add(this.systemJavaInfoLabel);
        c.gridwidth = 1;
        gridbag.setConstraints(this.systemMemUsageLabel, c);
        this.add(this.systemMemUsageLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this.systemAvailableMemoryLabel, c);
        this.add(this.systemAvailableMemoryLabel);
        this.systemMaximumMemoryLabel.setFont(FormattedLabel.FONT);
        c.gridwidth = 0;
        gridbag.setConstraints(this.systemMaximumMemoryLabel, c);
        this.add(this.systemMaximumMemoryLabel);
    }

    @Override
    public void update() {
        long memUsage = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
        this.systemMemUsageLabel.update(memUsage);
        this.systemAvailableMemoryLabel.update(Runtime.getRuntime().totalMemory() / 0x100000L);
    }

    @Override
    public void clear() {
        this.systemMemUsageLabel.clear();
        this.systemAvailableMemoryLabel.clear();
    }
}

